<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterGroup Struct
 * @subpackage Structs
 */
class MeterGroup extends AbstractStructBase
{
    /**
     * The MeterGroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterGroupID;
    /**
     * The MeterGroupTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterGroupTypeID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The GroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupName;
    /**
     * Constructor method for MeterGroup
     * @uses MeterGroup::setMeterGroupID()
     * @uses MeterGroup::setMeterGroupTypeID()
     * @uses MeterGroup::setCreateDate()
     * @uses MeterGroup::setGroupName()
     * @param int $meterGroupID
     * @param int $meterGroupTypeID
     * @param string $createDate
     * @param string $groupName
     */
    public function __construct($meterGroupID = null, $meterGroupTypeID = null, $createDate = null, $groupName = null)
    {
        $this
            ->setMeterGroupID($meterGroupID)
            ->setMeterGroupTypeID($meterGroupTypeID)
            ->setCreateDate($createDate)
            ->setGroupName($groupName);
    }
    /**
     * Get MeterGroupID value
     * @return int
     */
    public function getMeterGroupID()
    {
        return $this->MeterGroupID;
    }
    /**
     * Set MeterGroupID value
     * @param int $meterGroupID
     * @return \SGCIS\Struct\MeterGroup
     */
    public function setMeterGroupID($meterGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($meterGroupID) && !is_numeric($meterGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterGroupID)), __LINE__);
        }
        $this->MeterGroupID = $meterGroupID;
        return $this;
    }
    /**
     * Get MeterGroupTypeID value
     * @return int
     */
    public function getMeterGroupTypeID()
    {
        return $this->MeterGroupTypeID;
    }
    /**
     * Set MeterGroupTypeID value
     * @param int $meterGroupTypeID
     * @return \SGCIS\Struct\MeterGroup
     */
    public function setMeterGroupTypeID($meterGroupTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($meterGroupTypeID) && !is_numeric($meterGroupTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterGroupTypeID)), __LINE__);
        }
        $this->MeterGroupTypeID = $meterGroupTypeID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\MeterGroup
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get GroupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->GroupName;
    }
    /**
     * Set GroupName value
     * @param string $groupName
     * @return \SGCIS\Struct\MeterGroup
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupName)), __LINE__);
        }
        $this->GroupName = $groupName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\MeterGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
