<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterCopy Struct
 * @subpackage Structs
 */
class MeterCopy extends BaseDTO
{
    /**
     * The MeterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The MeterTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterTypeName;
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNumber;
    /**
     * The MeterInventoryStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterInventoryStatusName;
    /**
     * Constructor method for MeterCopy
     * @uses MeterCopy::setMeterID()
     * @uses MeterCopy::setActive()
     * @uses MeterCopy::setMeterTypeName()
     * @uses MeterCopy::setSerialNumber()
     * @uses MeterCopy::setMeterInventoryStatusName()
     * @param int $meterID
     * @param bool $active
     * @param string $meterTypeName
     * @param string $serialNumber
     * @param string $meterInventoryStatusName
     */
    public function __construct($meterID = null, $active = null, $meterTypeName = null, $serialNumber = null, $meterInventoryStatusName = null)
    {
        $this
            ->setMeterID($meterID)
            ->setActive($active)
            ->setMeterTypeName($meterTypeName)
            ->setSerialNumber($serialNumber)
            ->setMeterInventoryStatusName($meterInventoryStatusName);
    }
    /**
     * Get MeterID value
     * @return int
     */
    public function getMeterID()
    {
        return $this->MeterID;
    }
    /**
     * Set MeterID value
     * @param int $meterID
     * @return \SGCIS\Struct\MeterCopy
     */
    public function setMeterID($meterID = null)
    {
        // validation for constraint: int
        if (!is_null($meterID) && !is_numeric($meterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterID)), __LINE__);
        }
        $this->MeterID = $meterID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\MeterCopy
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get MeterTypeName value
     * @return string|null
     */
    public function getMeterTypeName()
    {
        return $this->MeterTypeName;
    }
    /**
     * Set MeterTypeName value
     * @param string $meterTypeName
     * @return \SGCIS\Struct\MeterCopy
     */
    public function setMeterTypeName($meterTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($meterTypeName) && !is_string($meterTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterTypeName)), __LINE__);
        }
        $this->MeterTypeName = $meterTypeName;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \SGCIS\Struct\MeterCopy
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get MeterInventoryStatusName value
     * @return string|null
     */
    public function getMeterInventoryStatusName()
    {
        return $this->MeterInventoryStatusName;
    }
    /**
     * Set MeterInventoryStatusName value
     * @param string $meterInventoryStatusName
     * @return \SGCIS\Struct\MeterCopy
     */
    public function setMeterInventoryStatusName($meterInventoryStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($meterInventoryStatusName) && !is_string($meterInventoryStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterInventoryStatusName)), __LINE__);
        }
        $this->MeterInventoryStatusName = $meterInventoryStatusName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\MeterCopy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
