<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Meter Struct
 * @subpackage Structs
 */
class Meter extends BaseDTO
{
    /**
     * The MeterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterID;
    /**
     * The MeterTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterTypeID;
    /**
     * The ManufactureDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ManufactureDate;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The MeterInventoryStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterInventoryStatusID;
    /**
     * The ShipmentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ShipmentDate;
    /**
     * The IsVeeEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVeeEnabled;
    /**
     * The UnitOfMeasureID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitOfMeasureID;
    /**
     * The InstallDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InstallDate;
    /**
     * The MeterGroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterGroupID;
    /**
     * The DistrictID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistrictID;
    /**
     * The IsDistrictMeter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDistrictMeter;
    /**
     * The InFlowDistrictID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InFlowDistrictID;
    /**
     * The OutFlowDistrictID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OutFlowDistrictID;
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNumber;
    /**
     * The ManufacturerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManufacturerName;
    /**
     * The IPAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IPAddress;
    /**
     * The CommCarrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommCarrier;
    /**
     * The PhaseType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhaseType;
    /**
     * The UnitOfMeasureCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * The MeterMultiplier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterMultiplier;
    /**
     * The MarketMeterType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketMeterType;
    /**
     * The HostSystemMeterIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HostSystemMeterIdentifier;
    /**
     * The MeterTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterTypeName;
    /**
     * The MeterInventoryStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterInventoryStatusName;
    /**
     * The DistributionServiceProviderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionServiceProviderName;
    /**
     * The MeterStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterStatusName;
    /**
     * The MeterProcessor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterProcessor;
    /**
     * The MeterSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterSize;
    /**
     * The ServicePointMeters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServicePointMeter
     */
    public $ServicePointMeters;
    /**
     * The DeviceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceID;
    /**
     * The InstallDateDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstallDateDisplay;
    /**
     * The DistrictName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistrictName;
    /**
     * The FlowDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlowDirection;
    /**
     * Constructor method for Meter
     * @uses Meter::setMeterID()
     * @uses Meter::setMeterTypeID()
     * @uses Meter::setManufactureDate()
     * @uses Meter::setActive()
     * @uses Meter::setLongitude()
     * @uses Meter::setLatitude()
     * @uses Meter::setMeterInventoryStatusID()
     * @uses Meter::setShipmentDate()
     * @uses Meter::setIsVeeEnabled()
     * @uses Meter::setUnitOfMeasureID()
     * @uses Meter::setInstallDate()
     * @uses Meter::setMeterGroupID()
     * @uses Meter::setDistrictID()
     * @uses Meter::setIsDistrictMeter()
     * @uses Meter::setInFlowDistrictID()
     * @uses Meter::setOutFlowDistrictID()
     * @uses Meter::setSerialNumber()
     * @uses Meter::setManufacturerName()
     * @uses Meter::setIPAddress()
     * @uses Meter::setCommCarrier()
     * @uses Meter::setPhaseType()
     * @uses Meter::setUnitOfMeasureCode()
     * @uses Meter::setMeterMultiplier()
     * @uses Meter::setMarketMeterType()
     * @uses Meter::setHostSystemMeterIdentifier()
     * @uses Meter::setMeterTypeName()
     * @uses Meter::setMeterInventoryStatusName()
     * @uses Meter::setDistributionServiceProviderName()
     * @uses Meter::setMeterStatusName()
     * @uses Meter::setMeterProcessor()
     * @uses Meter::setMeterSize()
     * @uses Meter::setServicePointMeters()
     * @uses Meter::setDeviceID()
     * @uses Meter::setInstallDateDisplay()
     * @uses Meter::setDistrictName()
     * @uses Meter::setFlowDirection()
     * @param int $meterID
     * @param int $meterTypeID
     * @param string $manufactureDate
     * @param bool $active
     * @param float $longitude
     * @param float $latitude
     * @param int $meterInventoryStatusID
     * @param string $shipmentDate
     * @param bool $isVeeEnabled
     * @param int $unitOfMeasureID
     * @param string $installDate
     * @param int $meterGroupID
     * @param int $districtID
     * @param bool $isDistrictMeter
     * @param int $inFlowDistrictID
     * @param int $outFlowDistrictID
     * @param string $serialNumber
     * @param string $manufacturerName
     * @param string $iPAddress
     * @param string $commCarrier
     * @param string $phaseType
     * @param string $unitOfMeasureCode
     * @param string $meterMultiplier
     * @param string $marketMeterType
     * @param string $hostSystemMeterIdentifier
     * @param string $meterTypeName
     * @param string $meterInventoryStatusName
     * @param string $distributionServiceProviderName
     * @param string $meterStatusName
     * @param string $meterProcessor
     * @param string $meterSize
     * @param \SGCIS\Array\ArrayOfServicePointMeter $servicePointMeters
     * @param string $deviceID
     * @param string $installDateDisplay
     * @param string $districtName
     * @param string $flowDirection
     */
    public function __construct($meterID = null, $meterTypeID = null, $manufactureDate = null, $active = null, $longitude = null, $latitude = null, $meterInventoryStatusID = null, $shipmentDate = null, $isVeeEnabled = null, $unitOfMeasureID = null, $installDate = null, $meterGroupID = null, $districtID = null, $isDistrictMeter = null, $inFlowDistrictID = null, $outFlowDistrictID = null, $serialNumber = null, $manufacturerName = null, $iPAddress = null, $commCarrier = null, $phaseType = null, $unitOfMeasureCode = null, $meterMultiplier = null, $marketMeterType = null, $hostSystemMeterIdentifier = null, $meterTypeName = null, $meterInventoryStatusName = null, $distributionServiceProviderName = null, $meterStatusName = null, $meterProcessor = null, $meterSize = null, \SGCIS\Array\ArrayOfServicePointMeter $servicePointMeters = null, $deviceID = null, $installDateDisplay = null, $districtName = null, $flowDirection = null)
    {
        $this
            ->setMeterID($meterID)
            ->setMeterTypeID($meterTypeID)
            ->setManufactureDate($manufactureDate)
            ->setActive($active)
            ->setLongitude($longitude)
            ->setLatitude($latitude)
            ->setMeterInventoryStatusID($meterInventoryStatusID)
            ->setShipmentDate($shipmentDate)
            ->setIsVeeEnabled($isVeeEnabled)
            ->setUnitOfMeasureID($unitOfMeasureID)
            ->setInstallDate($installDate)
            ->setMeterGroupID($meterGroupID)
            ->setDistrictID($districtID)
            ->setIsDistrictMeter($isDistrictMeter)
            ->setInFlowDistrictID($inFlowDistrictID)
            ->setOutFlowDistrictID($outFlowDistrictID)
            ->setSerialNumber($serialNumber)
            ->setManufacturerName($manufacturerName)
            ->setIPAddress($iPAddress)
            ->setCommCarrier($commCarrier)
            ->setPhaseType($phaseType)
            ->setUnitOfMeasureCode($unitOfMeasureCode)
            ->setMeterMultiplier($meterMultiplier)
            ->setMarketMeterType($marketMeterType)
            ->setHostSystemMeterIdentifier($hostSystemMeterIdentifier)
            ->setMeterTypeName($meterTypeName)
            ->setMeterInventoryStatusName($meterInventoryStatusName)
            ->setDistributionServiceProviderName($distributionServiceProviderName)
            ->setMeterStatusName($meterStatusName)
            ->setMeterProcessor($meterProcessor)
            ->setMeterSize($meterSize)
            ->setServicePointMeters($servicePointMeters)
            ->setDeviceID($deviceID)
            ->setInstallDateDisplay($installDateDisplay)
            ->setDistrictName($districtName)
            ->setFlowDirection($flowDirection);
    }
    /**
     * Get MeterID value
     * @return int
     */
    public function getMeterID()
    {
        return $this->MeterID;
    }
    /**
     * Set MeterID value
     * @param int $meterID
     * @return \SGCIS\Struct\Meter
     */
    public function setMeterID($meterID = null)
    {
        // validation for constraint: int
        if (!is_null($meterID) && !is_numeric($meterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterID)), __LINE__);
        }
        $this->MeterID = $meterID;
        return $this;
    }
    /**
     * Get MeterTypeID value
     * @return int
     */
    public function getMeterTypeID()
    {
        return $this->MeterTypeID;
    }
    /**
     * Set MeterTypeID value
     * @param int $meterTypeID
     * @return \SGCIS\Struct\Meter
     */
    public function setMeterTypeID($meterTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($meterTypeID) && !is_numeric($meterTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterTypeID)), __LINE__);
        }
        $this->MeterTypeID = $meterTypeID;
        return $this;
    }
    /**
     * Get ManufactureDate value
     * @return string
     */
    public function getManufactureDate()
    {
        return $this->ManufactureDate;
    }
    /**
     * Set ManufactureDate value
     * @param string $manufactureDate
     * @return \SGCIS\Struct\Meter
     */
    public function setManufactureDate($manufactureDate = null)
    {
        // validation for constraint: string
        if (!is_null($manufactureDate) && !is_string($manufactureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manufactureDate)), __LINE__);
        }
        $this->ManufactureDate = $manufactureDate;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\Meter
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \SGCIS\Struct\Meter
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \SGCIS\Struct\Meter
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get MeterInventoryStatusID value
     * @return int
     */
    public function getMeterInventoryStatusID()
    {
        return $this->MeterInventoryStatusID;
    }
    /**
     * Set MeterInventoryStatusID value
     * @param int $meterInventoryStatusID
     * @return \SGCIS\Struct\Meter
     */
    public function setMeterInventoryStatusID($meterInventoryStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($meterInventoryStatusID) && !is_numeric($meterInventoryStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterInventoryStatusID)), __LINE__);
        }
        $this->MeterInventoryStatusID = $meterInventoryStatusID;
        return $this;
    }
    /**
     * Get ShipmentDate value
     * @return string
     */
    public function getShipmentDate()
    {
        return $this->ShipmentDate;
    }
    /**
     * Set ShipmentDate value
     * @param string $shipmentDate
     * @return \SGCIS\Struct\Meter
     */
    public function setShipmentDate($shipmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDate) && !is_string($shipmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentDate)), __LINE__);
        }
        $this->ShipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get IsVeeEnabled value
     * @return bool
     */
    public function getIsVeeEnabled()
    {
        return $this->IsVeeEnabled;
    }
    /**
     * Set IsVeeEnabled value
     * @param bool $isVeeEnabled
     * @return \SGCIS\Struct\Meter
     */
    public function setIsVeeEnabled($isVeeEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVeeEnabled) && !is_bool($isVeeEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isVeeEnabled)), __LINE__);
        }
        $this->IsVeeEnabled = $isVeeEnabled;
        return $this;
    }
    /**
     * Get UnitOfMeasureID value
     * @return int
     */
    public function getUnitOfMeasureID()
    {
        return $this->UnitOfMeasureID;
    }
    /**
     * Set UnitOfMeasureID value
     * @param int $unitOfMeasureID
     * @return \SGCIS\Struct\Meter
     */
    public function setUnitOfMeasureID($unitOfMeasureID = null)
    {
        // validation for constraint: int
        if (!is_null($unitOfMeasureID) && !is_numeric($unitOfMeasureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitOfMeasureID)), __LINE__);
        }
        $this->UnitOfMeasureID = $unitOfMeasureID;
        return $this;
    }
    /**
     * Get InstallDate value
     * @return string
     */
    public function getInstallDate()
    {
        return $this->InstallDate;
    }
    /**
     * Set InstallDate value
     * @param string $installDate
     * @return \SGCIS\Struct\Meter
     */
    public function setInstallDate($installDate = null)
    {
        // validation for constraint: string
        if (!is_null($installDate) && !is_string($installDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installDate)), __LINE__);
        }
        $this->InstallDate = $installDate;
        return $this;
    }
    /**
     * Get MeterGroupID value
     * @return int
     */
    public function getMeterGroupID()
    {
        return $this->MeterGroupID;
    }
    /**
     * Set MeterGroupID value
     * @param int $meterGroupID
     * @return \SGCIS\Struct\Meter
     */
    public function setMeterGroupID($meterGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($meterGroupID) && !is_numeric($meterGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterGroupID)), __LINE__);
        }
        $this->MeterGroupID = $meterGroupID;
        return $this;
    }
    /**
     * Get DistrictID value
     * @return int
     */
    public function getDistrictID()
    {
        return $this->DistrictID;
    }
    /**
     * Set DistrictID value
     * @param int $districtID
     * @return \SGCIS\Struct\Meter
     */
    public function setDistrictID($districtID = null)
    {
        // validation for constraint: int
        if (!is_null($districtID) && !is_numeric($districtID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($districtID)), __LINE__);
        }
        $this->DistrictID = $districtID;
        return $this;
    }
    /**
     * Get IsDistrictMeter value
     * @return bool
     */
    public function getIsDistrictMeter()
    {
        return $this->IsDistrictMeter;
    }
    /**
     * Set IsDistrictMeter value
     * @param bool $isDistrictMeter
     * @return \SGCIS\Struct\Meter
     */
    public function setIsDistrictMeter($isDistrictMeter = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDistrictMeter) && !is_bool($isDistrictMeter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDistrictMeter)), __LINE__);
        }
        $this->IsDistrictMeter = $isDistrictMeter;
        return $this;
    }
    /**
     * Get InFlowDistrictID value
     * @return int
     */
    public function getInFlowDistrictID()
    {
        return $this->InFlowDistrictID;
    }
    /**
     * Set InFlowDistrictID value
     * @param int $inFlowDistrictID
     * @return \SGCIS\Struct\Meter
     */
    public function setInFlowDistrictID($inFlowDistrictID = null)
    {
        // validation for constraint: int
        if (!is_null($inFlowDistrictID) && !is_numeric($inFlowDistrictID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($inFlowDistrictID)), __LINE__);
        }
        $this->InFlowDistrictID = $inFlowDistrictID;
        return $this;
    }
    /**
     * Get OutFlowDistrictID value
     * @return int
     */
    public function getOutFlowDistrictID()
    {
        return $this->OutFlowDistrictID;
    }
    /**
     * Set OutFlowDistrictID value
     * @param int $outFlowDistrictID
     * @return \SGCIS\Struct\Meter
     */
    public function setOutFlowDistrictID($outFlowDistrictID = null)
    {
        // validation for constraint: int
        if (!is_null($outFlowDistrictID) && !is_numeric($outFlowDistrictID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($outFlowDistrictID)), __LINE__);
        }
        $this->OutFlowDistrictID = $outFlowDistrictID;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \SGCIS\Struct\Meter
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get ManufacturerName value
     * @return string|null
     */
    public function getManufacturerName()
    {
        return $this->ManufacturerName;
    }
    /**
     * Set ManufacturerName value
     * @param string $manufacturerName
     * @return \SGCIS\Struct\Meter
     */
    public function setManufacturerName($manufacturerName = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerName) && !is_string($manufacturerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manufacturerName)), __LINE__);
        }
        $this->ManufacturerName = $manufacturerName;
        return $this;
    }
    /**
     * Get IPAddress value
     * @return string|null
     */
    public function getIPAddress()
    {
        return $this->IPAddress;
    }
    /**
     * Set IPAddress value
     * @param string $iPAddress
     * @return \SGCIS\Struct\Meter
     */
    public function setIPAddress($iPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($iPAddress) && !is_string($iPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPAddress)), __LINE__);
        }
        $this->IPAddress = $iPAddress;
        return $this;
    }
    /**
     * Get CommCarrier value
     * @return string|null
     */
    public function getCommCarrier()
    {
        return $this->CommCarrier;
    }
    /**
     * Set CommCarrier value
     * @param string $commCarrier
     * @return \SGCIS\Struct\Meter
     */
    public function setCommCarrier($commCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($commCarrier) && !is_string($commCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commCarrier)), __LINE__);
        }
        $this->CommCarrier = $commCarrier;
        return $this;
    }
    /**
     * Get PhaseType value
     * @return string|null
     */
    public function getPhaseType()
    {
        return $this->PhaseType;
    }
    /**
     * Set PhaseType value
     * @param string $phaseType
     * @return \SGCIS\Struct\Meter
     */
    public function setPhaseType($phaseType = null)
    {
        // validation for constraint: string
        if (!is_null($phaseType) && !is_string($phaseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phaseType)), __LINE__);
        }
        $this->PhaseType = $phaseType;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \SGCIS\Struct\Meter
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitOfMeasureCode)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Get MeterMultiplier value
     * @return string|null
     */
    public function getMeterMultiplier()
    {
        return $this->MeterMultiplier;
    }
    /**
     * Set MeterMultiplier value
     * @param string $meterMultiplier
     * @return \SGCIS\Struct\Meter
     */
    public function setMeterMultiplier($meterMultiplier = null)
    {
        // validation for constraint: string
        if (!is_null($meterMultiplier) && !is_string($meterMultiplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterMultiplier)), __LINE__);
        }
        $this->MeterMultiplier = $meterMultiplier;
        return $this;
    }
    /**
     * Get MarketMeterType value
     * @return string|null
     */
    public function getMarketMeterType()
    {
        return $this->MarketMeterType;
    }
    /**
     * Set MarketMeterType value
     * @param string $marketMeterType
     * @return \SGCIS\Struct\Meter
     */
    public function setMarketMeterType($marketMeterType = null)
    {
        // validation for constraint: string
        if (!is_null($marketMeterType) && !is_string($marketMeterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketMeterType)), __LINE__);
        }
        $this->MarketMeterType = $marketMeterType;
        return $this;
    }
    /**
     * Get HostSystemMeterIdentifier value
     * @return string|null
     */
    public function getHostSystemMeterIdentifier()
    {
        return $this->HostSystemMeterIdentifier;
    }
    /**
     * Set HostSystemMeterIdentifier value
     * @param string $hostSystemMeterIdentifier
     * @return \SGCIS\Struct\Meter
     */
    public function setHostSystemMeterIdentifier($hostSystemMeterIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($hostSystemMeterIdentifier) && !is_string($hostSystemMeterIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostSystemMeterIdentifier)), __LINE__);
        }
        $this->HostSystemMeterIdentifier = $hostSystemMeterIdentifier;
        return $this;
    }
    /**
     * Get MeterTypeName value
     * @return string|null
     */
    public function getMeterTypeName()
    {
        return $this->MeterTypeName;
    }
    /**
     * Set MeterTypeName value
     * @param string $meterTypeName
     * @return \SGCIS\Struct\Meter
     */
    public function setMeterTypeName($meterTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($meterTypeName) && !is_string($meterTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterTypeName)), __LINE__);
        }
        $this->MeterTypeName = $meterTypeName;
        return $this;
    }
    /**
     * Get MeterInventoryStatusName value
     * @return string|null
     */
    public function getMeterInventoryStatusName()
    {
        return $this->MeterInventoryStatusName;
    }
    /**
     * Set MeterInventoryStatusName value
     * @param string $meterInventoryStatusName
     * @return \SGCIS\Struct\Meter
     */
    public function setMeterInventoryStatusName($meterInventoryStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($meterInventoryStatusName) && !is_string($meterInventoryStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterInventoryStatusName)), __LINE__);
        }
        $this->MeterInventoryStatusName = $meterInventoryStatusName;
        return $this;
    }
    /**
     * Get DistributionServiceProviderName value
     * @return string|null
     */
    public function getDistributionServiceProviderName()
    {
        return $this->DistributionServiceProviderName;
    }
    /**
     * Set DistributionServiceProviderName value
     * @param string $distributionServiceProviderName
     * @return \SGCIS\Struct\Meter
     */
    public function setDistributionServiceProviderName($distributionServiceProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($distributionServiceProviderName) && !is_string($distributionServiceProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionServiceProviderName)), __LINE__);
        }
        $this->DistributionServiceProviderName = $distributionServiceProviderName;
        return $this;
    }
    /**
     * Get MeterStatusName value
     * @return string|null
     */
    public function getMeterStatusName()
    {
        return $this->MeterStatusName;
    }
    /**
     * Set MeterStatusName value
     * @param string $meterStatusName
     * @return \SGCIS\Struct\Meter
     */
    public function setMeterStatusName($meterStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($meterStatusName) && !is_string($meterStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterStatusName)), __LINE__);
        }
        $this->MeterStatusName = $meterStatusName;
        return $this;
    }
    /**
     * Get MeterProcessor value
     * @return string|null
     */
    public function getMeterProcessor()
    {
        return $this->MeterProcessor;
    }
    /**
     * Set MeterProcessor value
     * @param string $meterProcessor
     * @return \SGCIS\Struct\Meter
     */
    public function setMeterProcessor($meterProcessor = null)
    {
        // validation for constraint: string
        if (!is_null($meterProcessor) && !is_string($meterProcessor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterProcessor)), __LINE__);
        }
        $this->MeterProcessor = $meterProcessor;
        return $this;
    }
    /**
     * Get MeterSize value
     * @return string|null
     */
    public function getMeterSize()
    {
        return $this->MeterSize;
    }
    /**
     * Set MeterSize value
     * @param string $meterSize
     * @return \SGCIS\Struct\Meter
     */
    public function setMeterSize($meterSize = null)
    {
        // validation for constraint: string
        if (!is_null($meterSize) && !is_string($meterSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterSize)), __LINE__);
        }
        $this->MeterSize = $meterSize;
        return $this;
    }
    /**
     * Get ServicePointMeters value
     * @return \SGCIS\Array\ArrayOfServicePointMeter|null
     */
    public function getServicePointMeters()
    {
        return $this->ServicePointMeters;
    }
    /**
     * Set ServicePointMeters value
     * @param \SGCIS\Array\ArrayOfServicePointMeter $servicePointMeters
     * @return \SGCIS\Struct\Meter
     */
    public function setServicePointMeters(\SGCIS\Array\ArrayOfServicePointMeter $servicePointMeters = null)
    {
        $this->ServicePointMeters = $servicePointMeters;
        return $this;
    }
    /**
     * Get DeviceID value
     * @return string|null
     */
    public function getDeviceID()
    {
        return $this->DeviceID;
    }
    /**
     * Set DeviceID value
     * @param string $deviceID
     * @return \SGCIS\Struct\Meter
     */
    public function setDeviceID($deviceID = null)
    {
        // validation for constraint: string
        if (!is_null($deviceID) && !is_string($deviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceID)), __LINE__);
        }
        $this->DeviceID = $deviceID;
        return $this;
    }
    /**
     * Get InstallDateDisplay value
     * @return string|null
     */
    public function getInstallDateDisplay()
    {
        return $this->InstallDateDisplay;
    }
    /**
     * Set InstallDateDisplay value
     * @param string $installDateDisplay
     * @return \SGCIS\Struct\Meter
     */
    public function setInstallDateDisplay($installDateDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($installDateDisplay) && !is_string($installDateDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installDateDisplay)), __LINE__);
        }
        $this->InstallDateDisplay = $installDateDisplay;
        return $this;
    }
    /**
     * Get DistrictName value
     * @return string|null
     */
    public function getDistrictName()
    {
        return $this->DistrictName;
    }
    /**
     * Set DistrictName value
     * @param string $districtName
     * @return \SGCIS\Struct\Meter
     */
    public function setDistrictName($districtName = null)
    {
        // validation for constraint: string
        if (!is_null($districtName) && !is_string($districtName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($districtName)), __LINE__);
        }
        $this->DistrictName = $districtName;
        return $this;
    }
    /**
     * Get FlowDirection value
     * @return string|null
     */
    public function getFlowDirection()
    {
        return $this->FlowDirection;
    }
    /**
     * Set FlowDirection value
     * @param string $flowDirection
     * @return \SGCIS\Struct\Meter
     */
    public function setFlowDirection($flowDirection = null)
    {
        // validation for constraint: string
        if (!is_null($flowDirection) && !is_string($flowDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flowDirection)), __LINE__);
        }
        $this->FlowDirection = $flowDirection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Meter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
