<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Language Struct
 * @subpackage Structs
 */
class Language extends AbstractStructBase
{
    /**
     * The LanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LanguageID;
    /**
     * The LanguageName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LanguageName;
    /**
     * Constructor method for Language
     * @uses Language::setLanguageID()
     * @uses Language::setLanguageName()
     * @param int $languageID
     * @param string $languageName
     */
    public function __construct($languageID = null, $languageName = null)
    {
        $this
            ->setLanguageID($languageID)
            ->setLanguageName($languageName);
    }
    /**
     * Get LanguageID value
     * @return int
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \SGCIS\Struct\Language
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !is_numeric($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get LanguageName value
     * @return string|null
     */
    public function getLanguageName()
    {
        return $this->LanguageName;
    }
    /**
     * Set LanguageName value
     * @param string $languageName
     * @return \SGCIS\Struct\Language
     */
    public function setLanguageName($languageName = null)
    {
        // validation for constraint: string
        if (!is_null($languageName) && !is_string($languageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageName)), __LINE__);
        }
        $this->LanguageName = $languageName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Language
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
