<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeEvent Struct
 * @subpackage Structs
 */
class FeeEvent extends BaseDTO
{
    /**
     * The FeeEventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FeeEventID;
    /**
     * The FeeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FeeID;
    /**
     * The SystemEventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemEventID;
    /**
     * The SystemEventName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemEventName;
    /**
     * The SystemEventDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemEventDescription;
    /**
     * The FeeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeName;
    /**
     * The FeeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeDescription;
    /**
     * Constructor method for FeeEvent
     * @uses FeeEvent::setFeeEventID()
     * @uses FeeEvent::setFeeID()
     * @uses FeeEvent::setSystemEventID()
     * @uses FeeEvent::setSystemEventName()
     * @uses FeeEvent::setSystemEventDescription()
     * @uses FeeEvent::setFeeName()
     * @uses FeeEvent::setFeeDescription()
     * @param int $feeEventID
     * @param int $feeID
     * @param int $systemEventID
     * @param string $systemEventName
     * @param string $systemEventDescription
     * @param string $feeName
     * @param string $feeDescription
     */
    public function __construct($feeEventID = null, $feeID = null, $systemEventID = null, $systemEventName = null, $systemEventDescription = null, $feeName = null, $feeDescription = null)
    {
        $this
            ->setFeeEventID($feeEventID)
            ->setFeeID($feeID)
            ->setSystemEventID($systemEventID)
            ->setSystemEventName($systemEventName)
            ->setSystemEventDescription($systemEventDescription)
            ->setFeeName($feeName)
            ->setFeeDescription($feeDescription);
    }
    /**
     * Get FeeEventID value
     * @return int
     */
    public function getFeeEventID()
    {
        return $this->FeeEventID;
    }
    /**
     * Set FeeEventID value
     * @param int $feeEventID
     * @return \SGCIS\Struct\FeeEvent
     */
    public function setFeeEventID($feeEventID = null)
    {
        // validation for constraint: int
        if (!is_null($feeEventID) && !is_numeric($feeEventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($feeEventID)), __LINE__);
        }
        $this->FeeEventID = $feeEventID;
        return $this;
    }
    /**
     * Get FeeID value
     * @return int
     */
    public function getFeeID()
    {
        return $this->FeeID;
    }
    /**
     * Set FeeID value
     * @param int $feeID
     * @return \SGCIS\Struct\FeeEvent
     */
    public function setFeeID($feeID = null)
    {
        // validation for constraint: int
        if (!is_null($feeID) && !is_numeric($feeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($feeID)), __LINE__);
        }
        $this->FeeID = $feeID;
        return $this;
    }
    /**
     * Get SystemEventID value
     * @return int
     */
    public function getSystemEventID()
    {
        return $this->SystemEventID;
    }
    /**
     * Set SystemEventID value
     * @param int $systemEventID
     * @return \SGCIS\Struct\FeeEvent
     */
    public function setSystemEventID($systemEventID = null)
    {
        // validation for constraint: int
        if (!is_null($systemEventID) && !is_numeric($systemEventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemEventID)), __LINE__);
        }
        $this->SystemEventID = $systemEventID;
        return $this;
    }
    /**
     * Get SystemEventName value
     * @return string|null
     */
    public function getSystemEventName()
    {
        return $this->SystemEventName;
    }
    /**
     * Set SystemEventName value
     * @param string $systemEventName
     * @return \SGCIS\Struct\FeeEvent
     */
    public function setSystemEventName($systemEventName = null)
    {
        // validation for constraint: string
        if (!is_null($systemEventName) && !is_string($systemEventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemEventName)), __LINE__);
        }
        $this->SystemEventName = $systemEventName;
        return $this;
    }
    /**
     * Get SystemEventDescription value
     * @return string|null
     */
    public function getSystemEventDescription()
    {
        return $this->SystemEventDescription;
    }
    /**
     * Set SystemEventDescription value
     * @param string $systemEventDescription
     * @return \SGCIS\Struct\FeeEvent
     */
    public function setSystemEventDescription($systemEventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($systemEventDescription) && !is_string($systemEventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemEventDescription)), __LINE__);
        }
        $this->SystemEventDescription = $systemEventDescription;
        return $this;
    }
    /**
     * Get FeeName value
     * @return string|null
     */
    public function getFeeName()
    {
        return $this->FeeName;
    }
    /**
     * Set FeeName value
     * @param string $feeName
     * @return \SGCIS\Struct\FeeEvent
     */
    public function setFeeName($feeName = null)
    {
        // validation for constraint: string
        if (!is_null($feeName) && !is_string($feeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeName)), __LINE__);
        }
        $this->FeeName = $feeName;
        return $this;
    }
    /**
     * Get FeeDescription value
     * @return string|null
     */
    public function getFeeDescription()
    {
        return $this->FeeDescription;
    }
    /**
     * Set FeeDescription value
     * @param string $feeDescription
     * @return \SGCIS\Struct\FeeEvent
     */
    public function setFeeDescription($feeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($feeDescription) && !is_string($feeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeDescription)), __LINE__);
        }
        $this->FeeDescription = $feeDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\FeeEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
