<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributionServiceProviderAudit Struct
 * @subpackage Structs
 */
class DistributionServiceProviderAudit extends BaseDTO
{
    /**
     * The DistributionServiceProviderAuditID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderAuditID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The ItemChanged
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemChanged;
    /**
     * The BeforeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BeforeValue;
    /**
     * The AfterValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AfterValue;
    /**
     * Constructor method for DistributionServiceProviderAudit
     * @uses DistributionServiceProviderAudit::setDistributionServiceProviderAuditID()
     * @uses DistributionServiceProviderAudit::setDistributionServiceProviderID()
     * @uses DistributionServiceProviderAudit::setUserName()
     * @uses DistributionServiceProviderAudit::setItemChanged()
     * @uses DistributionServiceProviderAudit::setBeforeValue()
     * @uses DistributionServiceProviderAudit::setAfterValue()
     * @param int $distributionServiceProviderAuditID
     * @param int $distributionServiceProviderID
     * @param string $userName
     * @param string $itemChanged
     * @param string $beforeValue
     * @param string $afterValue
     */
    public function __construct($distributionServiceProviderAuditID = null, $distributionServiceProviderID = null, $userName = null, $itemChanged = null, $beforeValue = null, $afterValue = null)
    {
        $this
            ->setDistributionServiceProviderAuditID($distributionServiceProviderAuditID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setUserName($userName)
            ->setItemChanged($itemChanged)
            ->setBeforeValue($beforeValue)
            ->setAfterValue($afterValue);
    }
    /**
     * Get DistributionServiceProviderAuditID value
     * @return int
     */
    public function getDistributionServiceProviderAuditID()
    {
        return $this->DistributionServiceProviderAuditID;
    }
    /**
     * Set DistributionServiceProviderAuditID value
     * @param int $distributionServiceProviderAuditID
     * @return \SGCIS\Struct\DistributionServiceProviderAudit
     */
    public function setDistributionServiceProviderAuditID($distributionServiceProviderAuditID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderAuditID) && !is_numeric($distributionServiceProviderAuditID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderAuditID)), __LINE__);
        }
        $this->DistributionServiceProviderAuditID = $distributionServiceProviderAuditID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\DistributionServiceProviderAudit
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\DistributionServiceProviderAudit
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get ItemChanged value
     * @return string|null
     */
    public function getItemChanged()
    {
        return $this->ItemChanged;
    }
    /**
     * Set ItemChanged value
     * @param string $itemChanged
     * @return \SGCIS\Struct\DistributionServiceProviderAudit
     */
    public function setItemChanged($itemChanged = null)
    {
        // validation for constraint: string
        if (!is_null($itemChanged) && !is_string($itemChanged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemChanged)), __LINE__);
        }
        $this->ItemChanged = $itemChanged;
        return $this;
    }
    /**
     * Get BeforeValue value
     * @return string|null
     */
    public function getBeforeValue()
    {
        return $this->BeforeValue;
    }
    /**
     * Set BeforeValue value
     * @param string $beforeValue
     * @return \SGCIS\Struct\DistributionServiceProviderAudit
     */
    public function setBeforeValue($beforeValue = null)
    {
        // validation for constraint: string
        if (!is_null($beforeValue) && !is_string($beforeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beforeValue)), __LINE__);
        }
        $this->BeforeValue = $beforeValue;
        return $this;
    }
    /**
     * Get AfterValue value
     * @return string|null
     */
    public function getAfterValue()
    {
        return $this->AfterValue;
    }
    /**
     * Set AfterValue value
     * @param string $afterValue
     * @return \SGCIS\Struct\DistributionServiceProviderAudit
     */
    public function setAfterValue($afterValue = null)
    {
        // validation for constraint: string
        if (!is_null($afterValue) && !is_string($afterValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($afterValue)), __LINE__);
        }
        $this->AfterValue = $afterValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\DistributionServiceProviderAudit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
