<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DailyBurnRate Struct
 * @subpackage Structs
 */
class DailyBurnRate extends AbstractStructBase
{
    /**
     * The DailyBurnRateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DailyBurnRateID;
    /**
     * The RateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The MarketPricingNodeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MarketPricingNodeID;
    /**
     * The AdderTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AdderTotal;
    /**
     * The PowerCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PowerCost;
    /**
     * The ProviderCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ProviderCharges;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Rate;
    /**
     * The Consumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption;
    /**
     * The MarketPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MarketPrice;
    /**
     * The BurnRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BurnRate;
    /**
     * The LookAheadDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LookAheadDays;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The LoadProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoadProfile;
    /**
     * Constructor method for DailyBurnRate
     * @uses DailyBurnRate::setDailyBurnRateID()
     * @uses DailyBurnRate::setRateID()
     * @uses DailyBurnRate::setDistributionServiceProviderID()
     * @uses DailyBurnRate::setMarketPricingNodeID()
     * @uses DailyBurnRate::setAdderTotal()
     * @uses DailyBurnRate::setPowerCost()
     * @uses DailyBurnRate::setProviderCharges()
     * @uses DailyBurnRate::setRate()
     * @uses DailyBurnRate::setConsumption()
     * @uses DailyBurnRate::setMarketPrice()
     * @uses DailyBurnRate::setBurnRate()
     * @uses DailyBurnRate::setLookAheadDays()
     * @uses DailyBurnRate::setCreateDate()
     * @uses DailyBurnRate::setLoadProfile()
     * @param int $dailyBurnRateID
     * @param int $rateID
     * @param int $distributionServiceProviderID
     * @param int $marketPricingNodeID
     * @param float $adderTotal
     * @param float $powerCost
     * @param float $providerCharges
     * @param float $rate
     * @param float $consumption
     * @param float $marketPrice
     * @param float $burnRate
     * @param int $lookAheadDays
     * @param string $createDate
     * @param string $loadProfile
     */
    public function __construct($dailyBurnRateID = null, $rateID = null, $distributionServiceProviderID = null, $marketPricingNodeID = null, $adderTotal = null, $powerCost = null, $providerCharges = null, $rate = null, $consumption = null, $marketPrice = null, $burnRate = null, $lookAheadDays = null, $createDate = null, $loadProfile = null)
    {
        $this
            ->setDailyBurnRateID($dailyBurnRateID)
            ->setRateID($rateID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setMarketPricingNodeID($marketPricingNodeID)
            ->setAdderTotal($adderTotal)
            ->setPowerCost($powerCost)
            ->setProviderCharges($providerCharges)
            ->setRate($rate)
            ->setConsumption($consumption)
            ->setMarketPrice($marketPrice)
            ->setBurnRate($burnRate)
            ->setLookAheadDays($lookAheadDays)
            ->setCreateDate($createDate)
            ->setLoadProfile($loadProfile);
    }
    /**
     * Get DailyBurnRateID value
     * @return int
     */
    public function getDailyBurnRateID()
    {
        return $this->DailyBurnRateID;
    }
    /**
     * Set DailyBurnRateID value
     * @param int $dailyBurnRateID
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setDailyBurnRateID($dailyBurnRateID = null)
    {
        // validation for constraint: int
        if (!is_null($dailyBurnRateID) && !is_numeric($dailyBurnRateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dailyBurnRateID)), __LINE__);
        }
        $this->DailyBurnRateID = $dailyBurnRateID;
        return $this;
    }
    /**
     * Get RateID value
     * @return int
     */
    public function getRateID()
    {
        return $this->RateID;
    }
    /**
     * Set RateID value
     * @param int $rateID
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setRateID($rateID = null)
    {
        // validation for constraint: int
        if (!is_null($rateID) && !is_numeric($rateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateID)), __LINE__);
        }
        $this->RateID = $rateID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get MarketPricingNodeID value
     * @return int
     */
    public function getMarketPricingNodeID()
    {
        return $this->MarketPricingNodeID;
    }
    /**
     * Set MarketPricingNodeID value
     * @param int $marketPricingNodeID
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setMarketPricingNodeID($marketPricingNodeID = null)
    {
        // validation for constraint: int
        if (!is_null($marketPricingNodeID) && !is_numeric($marketPricingNodeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($marketPricingNodeID)), __LINE__);
        }
        $this->MarketPricingNodeID = $marketPricingNodeID;
        return $this;
    }
    /**
     * Get AdderTotal value
     * @return float
     */
    public function getAdderTotal()
    {
        return $this->AdderTotal;
    }
    /**
     * Set AdderTotal value
     * @param float $adderTotal
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setAdderTotal($adderTotal = null)
    {
        $this->AdderTotal = $adderTotal;
        return $this;
    }
    /**
     * Get PowerCost value
     * @return float
     */
    public function getPowerCost()
    {
        return $this->PowerCost;
    }
    /**
     * Set PowerCost value
     * @param float $powerCost
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setPowerCost($powerCost = null)
    {
        $this->PowerCost = $powerCost;
        return $this;
    }
    /**
     * Get ProviderCharges value
     * @return float
     */
    public function getProviderCharges()
    {
        return $this->ProviderCharges;
    }
    /**
     * Set ProviderCharges value
     * @param float $providerCharges
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setProviderCharges($providerCharges = null)
    {
        $this->ProviderCharges = $providerCharges;
        return $this;
    }
    /**
     * Get Rate value
     * @return float
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setRate($rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get Consumption value
     * @return float
     */
    public function getConsumption()
    {
        return $this->Consumption;
    }
    /**
     * Set Consumption value
     * @param float $consumption
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setConsumption($consumption = null)
    {
        $this->Consumption = $consumption;
        return $this;
    }
    /**
     * Get MarketPrice value
     * @return float
     */
    public function getMarketPrice()
    {
        return $this->MarketPrice;
    }
    /**
     * Set MarketPrice value
     * @param float $marketPrice
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setMarketPrice($marketPrice = null)
    {
        $this->MarketPrice = $marketPrice;
        return $this;
    }
    /**
     * Get BurnRate value
     * @return float
     */
    public function getBurnRate()
    {
        return $this->BurnRate;
    }
    /**
     * Set BurnRate value
     * @param float $burnRate
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setBurnRate($burnRate = null)
    {
        $this->BurnRate = $burnRate;
        return $this;
    }
    /**
     * Get LookAheadDays value
     * @return int
     */
    public function getLookAheadDays()
    {
        return $this->LookAheadDays;
    }
    /**
     * Set LookAheadDays value
     * @param int $lookAheadDays
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setLookAheadDays($lookAheadDays = null)
    {
        // validation for constraint: int
        if (!is_null($lookAheadDays) && !is_numeric($lookAheadDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lookAheadDays)), __LINE__);
        }
        $this->LookAheadDays = $lookAheadDays;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get LoadProfile value
     * @return string|null
     */
    public function getLoadProfile()
    {
        return $this->LoadProfile;
    }
    /**
     * Set LoadProfile value
     * @param string $loadProfile
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public function setLoadProfile($loadProfile = null)
    {
        // validation for constraint: string
        if (!is_null($loadProfile) && !is_string($loadProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loadProfile)), __LINE__);
        }
        $this->LoadProfile = $loadProfile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\DailyBurnRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
