<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateAccountRequest Struct
 * @subpackage Structs
 */
class CreateAccountRequest extends ServiceRequestBase
{
    /**
     * The IsMoveInRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMoveInRequest;
    /**
     * The MoveInDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MoveInDate;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The ToSkipSwitchHoldValidation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ToSkipSwitchHoldValidation;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Account
     */
    public $Account;
    /**
     * The AccountDepositOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountDepositOption
     */
    public $AccountDepositOption;
    /**
     * Constructor method for CreateAccountRequest
     * @uses CreateAccountRequest::setIsMoveInRequest()
     * @uses CreateAccountRequest::setMoveInDate()
     * @uses CreateAccountRequest::setUserID()
     * @uses CreateAccountRequest::setToSkipSwitchHoldValidation()
     * @uses CreateAccountRequest::setAccount()
     * @uses CreateAccountRequest::setAccountDepositOption()
     * @param bool $isMoveInRequest
     * @param string $moveInDate
     * @param int $userID
     * @param bool $toSkipSwitchHoldValidation
     * @param \SGCIS\Struct\Account $account
     * @param \SGCIS\Struct\AccountDepositOption $accountDepositOption
     */
    public function __construct($isMoveInRequest = null, $moveInDate = null, $userID = null, $toSkipSwitchHoldValidation = null, \SGCIS\Struct\Account $account = null, \SGCIS\Struct\AccountDepositOption $accountDepositOption = null)
    {
        $this
            ->setIsMoveInRequest($isMoveInRequest)
            ->setMoveInDate($moveInDate)
            ->setUserID($userID)
            ->setToSkipSwitchHoldValidation($toSkipSwitchHoldValidation)
            ->setAccount($account)
            ->setAccountDepositOption($accountDepositOption);
    }
    /**
     * Get IsMoveInRequest value
     * @return bool
     */
    public function getIsMoveInRequest()
    {
        return $this->IsMoveInRequest;
    }
    /**
     * Set IsMoveInRequest value
     * @param bool $isMoveInRequest
     * @return \SGCIS\Struct\CreateAccountRequest
     */
    public function setIsMoveInRequest($isMoveInRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMoveInRequest) && !is_bool($isMoveInRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMoveInRequest)), __LINE__);
        }
        $this->IsMoveInRequest = $isMoveInRequest;
        return $this;
    }
    /**
     * Get MoveInDate value
     * @return string
     */
    public function getMoveInDate()
    {
        return $this->MoveInDate;
    }
    /**
     * Set MoveInDate value
     * @param string $moveInDate
     * @return \SGCIS\Struct\CreateAccountRequest
     */
    public function setMoveInDate($moveInDate = null)
    {
        // validation for constraint: string
        if (!is_null($moveInDate) && !is_string($moveInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moveInDate)), __LINE__);
        }
        $this->MoveInDate = $moveInDate;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\CreateAccountRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get ToSkipSwitchHoldValidation value
     * @return bool
     */
    public function getToSkipSwitchHoldValidation()
    {
        return $this->ToSkipSwitchHoldValidation;
    }
    /**
     * Set ToSkipSwitchHoldValidation value
     * @param bool $toSkipSwitchHoldValidation
     * @return \SGCIS\Struct\CreateAccountRequest
     */
    public function setToSkipSwitchHoldValidation($toSkipSwitchHoldValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($toSkipSwitchHoldValidation) && !is_bool($toSkipSwitchHoldValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($toSkipSwitchHoldValidation)), __LINE__);
        }
        $this->ToSkipSwitchHoldValidation = $toSkipSwitchHoldValidation;
        return $this;
    }
    /**
     * Get Account value
     * @return \SGCIS\Struct\Account|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \SGCIS\Struct\Account $account
     * @return \SGCIS\Struct\CreateAccountRequest
     */
    public function setAccount(\SGCIS\Struct\Account $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get AccountDepositOption value
     * @return \SGCIS\Struct\AccountDepositOption|null
     */
    public function getAccountDepositOption()
    {
        return $this->AccountDepositOption;
    }
    /**
     * Set AccountDepositOption value
     * @param \SGCIS\Struct\AccountDepositOption $accountDepositOption
     * @return \SGCIS\Struct\CreateAccountRequest
     */
    public function setAccountDepositOption(\SGCIS\Struct\AccountDepositOption $accountDepositOption = null)
    {
        $this->AccountDepositOption = $accountDepositOption;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\CreateAccountRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
