<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeTier Struct
 * @subpackage Structs
 */
class ChargeTier extends AbstractStructBase
{
    /**
     * The ChargeTierID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeTierID;
    /**
     * The ChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeID;
    /**
     * The FromAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FromAmount;
    /**
     * The ToAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ToAmount;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Rate;
    /**
     * The TierLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TierLevel;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * Constructor method for ChargeTier
     * @uses ChargeTier::setChargeTierID()
     * @uses ChargeTier::setChargeID()
     * @uses ChargeTier::setFromAmount()
     * @uses ChargeTier::setToAmount()
     * @uses ChargeTier::setRate()
     * @uses ChargeTier::setTierLevel()
     * @uses ChargeTier::setCreateDate()
     * @param int $chargeTierID
     * @param int $chargeID
     * @param float $fromAmount
     * @param float $toAmount
     * @param float $rate
     * @param string $tierLevel
     * @param string $createDate
     */
    public function __construct($chargeTierID = null, $chargeID = null, $fromAmount = null, $toAmount = null, $rate = null, $tierLevel = null, $createDate = null)
    {
        $this
            ->setChargeTierID($chargeTierID)
            ->setChargeID($chargeID)
            ->setFromAmount($fromAmount)
            ->setToAmount($toAmount)
            ->setRate($rate)
            ->setTierLevel($tierLevel)
            ->setCreateDate($createDate);
    }
    /**
     * Get ChargeTierID value
     * @return int
     */
    public function getChargeTierID()
    {
        return $this->ChargeTierID;
    }
    /**
     * Set ChargeTierID value
     * @param int $chargeTierID
     * @return \SGCIS\Struct\ChargeTier
     */
    public function setChargeTierID($chargeTierID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeTierID) && !is_numeric($chargeTierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeTierID)), __LINE__);
        }
        $this->ChargeTierID = $chargeTierID;
        return $this;
    }
    /**
     * Get ChargeID value
     * @return int
     */
    public function getChargeID()
    {
        return $this->ChargeID;
    }
    /**
     * Set ChargeID value
     * @param int $chargeID
     * @return \SGCIS\Struct\ChargeTier
     */
    public function setChargeID($chargeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeID) && !is_numeric($chargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeID)), __LINE__);
        }
        $this->ChargeID = $chargeID;
        return $this;
    }
    /**
     * Get FromAmount value
     * @return float
     */
    public function getFromAmount()
    {
        return $this->FromAmount;
    }
    /**
     * Set FromAmount value
     * @param float $fromAmount
     * @return \SGCIS\Struct\ChargeTier
     */
    public function setFromAmount($fromAmount = null)
    {
        $this->FromAmount = $fromAmount;
        return $this;
    }
    /**
     * Get ToAmount value
     * @return float
     */
    public function getToAmount()
    {
        return $this->ToAmount;
    }
    /**
     * Set ToAmount value
     * @param float $toAmount
     * @return \SGCIS\Struct\ChargeTier
     */
    public function setToAmount($toAmount = null)
    {
        $this->ToAmount = $toAmount;
        return $this;
    }
    /**
     * Get Rate value
     * @return float
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \SGCIS\Struct\ChargeTier
     */
    public function setRate($rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get TierLevel value
     * @return string|null
     */
    public function getTierLevel()
    {
        return $this->TierLevel;
    }
    /**
     * Set TierLevel value
     * @param string $tierLevel
     * @return \SGCIS\Struct\ChargeTier
     */
    public function setTierLevel($tierLevel = null)
    {
        // validation for constraint: string
        if (!is_null($tierLevel) && !is_string($tierLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tierLevel)), __LINE__);
        }
        $this->TierLevel = $tierLevel;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\ChargeTier
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ChargeTier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
