<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeGroup Struct
 * @subpackage Structs
 */
class ChargeGroup extends AbstractStructBase
{
    /**
     * The ChargeGroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeGroupID;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The DateApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateApproved;
    /**
     * The IsApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsApproved;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The ChargeGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeGroupName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The BillingDisplayDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingDisplayDescription;
    /**
     * The ApprovedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApprovedByUserName;
    /**
     * The Charges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfCharge
     */
    public $Charges;
    /**
     * Constructor method for ChargeGroup
     * @uses ChargeGroup::setChargeGroupID()
     * @uses ChargeGroup::setIsActive()
     * @uses ChargeGroup::setDateApproved()
     * @uses ChargeGroup::setIsApproved()
     * @uses ChargeGroup::setAmount()
     * @uses ChargeGroup::setChargeGroupName()
     * @uses ChargeGroup::setDescription()
     * @uses ChargeGroup::setBillingDisplayDescription()
     * @uses ChargeGroup::setApprovedByUserName()
     * @uses ChargeGroup::setCharges()
     * @param int $chargeGroupID
     * @param bool $isActive
     * @param string $dateApproved
     * @param bool $isApproved
     * @param float $amount
     * @param string $chargeGroupName
     * @param string $description
     * @param string $billingDisplayDescription
     * @param string $approvedByUserName
     * @param \SGCIS\Array\ArrayOfCharge $charges
     */
    public function __construct($chargeGroupID = null, $isActive = null, $dateApproved = null, $isApproved = null, $amount = null, $chargeGroupName = null, $description = null, $billingDisplayDescription = null, $approvedByUserName = null, \SGCIS\Array\ArrayOfCharge $charges = null)
    {
        $this
            ->setChargeGroupID($chargeGroupID)
            ->setIsActive($isActive)
            ->setDateApproved($dateApproved)
            ->setIsApproved($isApproved)
            ->setAmount($amount)
            ->setChargeGroupName($chargeGroupName)
            ->setDescription($description)
            ->setBillingDisplayDescription($billingDisplayDescription)
            ->setApprovedByUserName($approvedByUserName)
            ->setCharges($charges);
    }
    /**
     * Get ChargeGroupID value
     * @return int
     */
    public function getChargeGroupID()
    {
        return $this->ChargeGroupID;
    }
    /**
     * Set ChargeGroupID value
     * @param int $chargeGroupID
     * @return \SGCIS\Struct\ChargeGroup
     */
    public function setChargeGroupID($chargeGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeGroupID) && !is_numeric($chargeGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeGroupID)), __LINE__);
        }
        $this->ChargeGroupID = $chargeGroupID;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \SGCIS\Struct\ChargeGroup
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get DateApproved value
     * @return string
     */
    public function getDateApproved()
    {
        return $this->DateApproved;
    }
    /**
     * Set DateApproved value
     * @param string $dateApproved
     * @return \SGCIS\Struct\ChargeGroup
     */
    public function setDateApproved($dateApproved = null)
    {
        // validation for constraint: string
        if (!is_null($dateApproved) && !is_string($dateApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateApproved)), __LINE__);
        }
        $this->DateApproved = $dateApproved;
        return $this;
    }
    /**
     * Get IsApproved value
     * @return bool
     */
    public function getIsApproved()
    {
        return $this->IsApproved;
    }
    /**
     * Set IsApproved value
     * @param bool $isApproved
     * @return \SGCIS\Struct\ChargeGroup
     */
    public function setIsApproved($isApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApproved) && !is_bool($isApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isApproved)), __LINE__);
        }
        $this->IsApproved = $isApproved;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SGCIS\Struct\ChargeGroup
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ChargeGroupName value
     * @return string|null
     */
    public function getChargeGroupName()
    {
        return $this->ChargeGroupName;
    }
    /**
     * Set ChargeGroupName value
     * @param string $chargeGroupName
     * @return \SGCIS\Struct\ChargeGroup
     */
    public function setChargeGroupName($chargeGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeGroupName) && !is_string($chargeGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeGroupName)), __LINE__);
        }
        $this->ChargeGroupName = $chargeGroupName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\ChargeGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get BillingDisplayDescription value
     * @return string|null
     */
    public function getBillingDisplayDescription()
    {
        return $this->BillingDisplayDescription;
    }
    /**
     * Set BillingDisplayDescription value
     * @param string $billingDisplayDescription
     * @return \SGCIS\Struct\ChargeGroup
     */
    public function setBillingDisplayDescription($billingDisplayDescription = null)
    {
        // validation for constraint: string
        if (!is_null($billingDisplayDescription) && !is_string($billingDisplayDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingDisplayDescription)), __LINE__);
        }
        $this->BillingDisplayDescription = $billingDisplayDescription;
        return $this;
    }
    /**
     * Get ApprovedByUserName value
     * @return string|null
     */
    public function getApprovedByUserName()
    {
        return $this->ApprovedByUserName;
    }
    /**
     * Set ApprovedByUserName value
     * @param string $approvedByUserName
     * @return \SGCIS\Struct\ChargeGroup
     */
    public function setApprovedByUserName($approvedByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($approvedByUserName) && !is_string($approvedByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approvedByUserName)), __LINE__);
        }
        $this->ApprovedByUserName = $approvedByUserName;
        return $this;
    }
    /**
     * Get Charges value
     * @return \SGCIS\Array\ArrayOfCharge|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * Set Charges value
     * @param \SGCIS\Array\ArrayOfCharge $charges
     * @return \SGCIS\Struct\ChargeGroup
     */
    public function setCharges(\SGCIS\Array\ArrayOfCharge $charges = null)
    {
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ChargeGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
