<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeDistributionServiceProvider Struct
 * @subpackage Structs
 */
class ChargeDistributionServiceProvider extends AbstractStructBase
{
    /**
     * The ChargeDistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeDistributionServiceProviderID;
    /**
     * The ChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * Constructor method for ChargeDistributionServiceProvider
     * @uses ChargeDistributionServiceProvider::setChargeDistributionServiceProviderID()
     * @uses ChargeDistributionServiceProvider::setChargeID()
     * @uses ChargeDistributionServiceProvider::setDistributionServiceProviderID()
     * @param int $chargeDistributionServiceProviderID
     * @param int $chargeID
     * @param int $distributionServiceProviderID
     */
    public function __construct($chargeDistributionServiceProviderID = null, $chargeID = null, $distributionServiceProviderID = null)
    {
        $this
            ->setChargeDistributionServiceProviderID($chargeDistributionServiceProviderID)
            ->setChargeID($chargeID)
            ->setDistributionServiceProviderID($distributionServiceProviderID);
    }
    /**
     * Get ChargeDistributionServiceProviderID value
     * @return int
     */
    public function getChargeDistributionServiceProviderID()
    {
        return $this->ChargeDistributionServiceProviderID;
    }
    /**
     * Set ChargeDistributionServiceProviderID value
     * @param int $chargeDistributionServiceProviderID
     * @return \SGCIS\Struct\ChargeDistributionServiceProvider
     */
    public function setChargeDistributionServiceProviderID($chargeDistributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeDistributionServiceProviderID) && !is_numeric($chargeDistributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeDistributionServiceProviderID)), __LINE__);
        }
        $this->ChargeDistributionServiceProviderID = $chargeDistributionServiceProviderID;
        return $this;
    }
    /**
     * Get ChargeID value
     * @return int
     */
    public function getChargeID()
    {
        return $this->ChargeID;
    }
    /**
     * Set ChargeID value
     * @param int $chargeID
     * @return \SGCIS\Struct\ChargeDistributionServiceProvider
     */
    public function setChargeID($chargeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeID) && !is_numeric($chargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeID)), __LINE__);
        }
        $this->ChargeID = $chargeID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\ChargeDistributionServiceProvider
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ChargeDistributionServiceProvider
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
