<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeUserPasswordRequest Struct
 * @subpackage Structs
 */
class ChangeUserPasswordRequest extends ServiceRequestBase
{
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The CurrentPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrentPassword;
    /**
     * The NewPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewPassword;
    /**
     * Constructor method for ChangeUserPasswordRequest
     * @uses ChangeUserPasswordRequest::setUserID()
     * @uses ChangeUserPasswordRequest::setUserName()
     * @uses ChangeUserPasswordRequest::setCurrentPassword()
     * @uses ChangeUserPasswordRequest::setNewPassword()
     * @param int $userID
     * @param string $userName
     * @param string $currentPassword
     * @param string $newPassword
     */
    public function __construct($userID = null, $userName = null, $currentPassword = null, $newPassword = null)
    {
        $this
            ->setUserID($userID)
            ->setUserName($userName)
            ->setCurrentPassword($currentPassword)
            ->setNewPassword($newPassword);
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\ChangeUserPasswordRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\ChangeUserPasswordRequest
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get CurrentPassword value
     * @return string|null
     */
    public function getCurrentPassword()
    {
        return $this->CurrentPassword;
    }
    /**
     * Set CurrentPassword value
     * @param string $currentPassword
     * @return \SGCIS\Struct\ChangeUserPasswordRequest
     */
    public function setCurrentPassword($currentPassword = null)
    {
        // validation for constraint: string
        if (!is_null($currentPassword) && !is_string($currentPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentPassword)), __LINE__);
        }
        $this->CurrentPassword = $currentPassword;
        return $this;
    }
    /**
     * Get NewPassword value
     * @return string|null
     */
    public function getNewPassword()
    {
        return $this->NewPassword;
    }
    /**
     * Set NewPassword value
     * @param string $newPassword
     * @return \SGCIS\Struct\ChangeUserPasswordRequest
     */
    public function setNewPassword($newPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newPassword) && !is_string($newPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPassword)), __LINE__);
        }
        $this->NewPassword = $newPassword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ChangeUserPasswordRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
