<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CCHGroupTaxDetail Struct
 * @subpackage Structs
 */
class CCHGroupTaxDetail extends AbstractStructBase
{
    /**
     * The CCHGroupTaxDetailID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CCHGroupTaxDetailID;
    /**
     * The CCHGroupTaxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CCHGroupTaxID;
    /**
     * The AccountTransactionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTransactionID;
    /**
     * The TaxAuthorityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TaxAuthorityID;
    /**
     * The RevenueBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RevenueBase;
    /**
     * The TaxRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxRate;
    /**
     * The PercentageTaxable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PercentageTaxable;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Tax;
    /**
     * The TaxOnTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxOnTax;
    /**
     * The TaxTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxTotal;
    /**
     * The TaxAccrualBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxAccrualBalance;
    /**
     * The IsPosted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPosted;
    /**
     * The PostedAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PostedAmount;
    /**
     * The UseForAccrual
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseForAccrual;
    /**
     * The TaxAuthorityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxAuthorityName;
    /**
     * The TaxAuthorityType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxAuthorityType;
    /**
     * The TaxTypeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxTypeCode;
    /**
     * The TaxTypeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxTypeDescription;
    /**
     * The CountyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountyName;
    /**
     * The LocationTaxAuthType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationTaxAuthType;
    /**
     * Constructor method for CCHGroupTaxDetail
     * @uses CCHGroupTaxDetail::setCCHGroupTaxDetailID()
     * @uses CCHGroupTaxDetail::setCCHGroupTaxID()
     * @uses CCHGroupTaxDetail::setAccountTransactionID()
     * @uses CCHGroupTaxDetail::setTaxAuthorityID()
     * @uses CCHGroupTaxDetail::setRevenueBase()
     * @uses CCHGroupTaxDetail::setTaxRate()
     * @uses CCHGroupTaxDetail::setPercentageTaxable()
     * @uses CCHGroupTaxDetail::setTax()
     * @uses CCHGroupTaxDetail::setTaxOnTax()
     * @uses CCHGroupTaxDetail::setTaxTotal()
     * @uses CCHGroupTaxDetail::setTaxAccrualBalance()
     * @uses CCHGroupTaxDetail::setIsPosted()
     * @uses CCHGroupTaxDetail::setPostedAmount()
     * @uses CCHGroupTaxDetail::setUseForAccrual()
     * @uses CCHGroupTaxDetail::setTaxAuthorityName()
     * @uses CCHGroupTaxDetail::setTaxAuthorityType()
     * @uses CCHGroupTaxDetail::setTaxTypeCode()
     * @uses CCHGroupTaxDetail::setTaxTypeDescription()
     * @uses CCHGroupTaxDetail::setCountyName()
     * @uses CCHGroupTaxDetail::setLocationTaxAuthType()
     * @param int $cCHGroupTaxDetailID
     * @param int $cCHGroupTaxID
     * @param int $accountTransactionID
     * @param int $taxAuthorityID
     * @param float $revenueBase
     * @param float $taxRate
     * @param float $percentageTaxable
     * @param float $tax
     * @param float $taxOnTax
     * @param float $taxTotal
     * @param float $taxAccrualBalance
     * @param bool $isPosted
     * @param float $postedAmount
     * @param bool $useForAccrual
     * @param string $taxAuthorityName
     * @param string $taxAuthorityType
     * @param string $taxTypeCode
     * @param string $taxTypeDescription
     * @param string $countyName
     * @param string $locationTaxAuthType
     */
    public function __construct($cCHGroupTaxDetailID = null, $cCHGroupTaxID = null, $accountTransactionID = null, $taxAuthorityID = null, $revenueBase = null, $taxRate = null, $percentageTaxable = null, $tax = null, $taxOnTax = null, $taxTotal = null, $taxAccrualBalance = null, $isPosted = null, $postedAmount = null, $useForAccrual = null, $taxAuthorityName = null, $taxAuthorityType = null, $taxTypeCode = null, $taxTypeDescription = null, $countyName = null, $locationTaxAuthType = null)
    {
        $this
            ->setCCHGroupTaxDetailID($cCHGroupTaxDetailID)
            ->setCCHGroupTaxID($cCHGroupTaxID)
            ->setAccountTransactionID($accountTransactionID)
            ->setTaxAuthorityID($taxAuthorityID)
            ->setRevenueBase($revenueBase)
            ->setTaxRate($taxRate)
            ->setPercentageTaxable($percentageTaxable)
            ->setTax($tax)
            ->setTaxOnTax($taxOnTax)
            ->setTaxTotal($taxTotal)
            ->setTaxAccrualBalance($taxAccrualBalance)
            ->setIsPosted($isPosted)
            ->setPostedAmount($postedAmount)
            ->setUseForAccrual($useForAccrual)
            ->setTaxAuthorityName($taxAuthorityName)
            ->setTaxAuthorityType($taxAuthorityType)
            ->setTaxTypeCode($taxTypeCode)
            ->setTaxTypeDescription($taxTypeDescription)
            ->setCountyName($countyName)
            ->setLocationTaxAuthType($locationTaxAuthType);
    }
    /**
     * Get CCHGroupTaxDetailID value
     * @return int
     */
    public function getCCHGroupTaxDetailID()
    {
        return $this->CCHGroupTaxDetailID;
    }
    /**
     * Set CCHGroupTaxDetailID value
     * @param int $cCHGroupTaxDetailID
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setCCHGroupTaxDetailID($cCHGroupTaxDetailID = null)
    {
        // validation for constraint: int
        if (!is_null($cCHGroupTaxDetailID) && !is_numeric($cCHGroupTaxDetailID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cCHGroupTaxDetailID)), __LINE__);
        }
        $this->CCHGroupTaxDetailID = $cCHGroupTaxDetailID;
        return $this;
    }
    /**
     * Get CCHGroupTaxID value
     * @return int
     */
    public function getCCHGroupTaxID()
    {
        return $this->CCHGroupTaxID;
    }
    /**
     * Set CCHGroupTaxID value
     * @param int $cCHGroupTaxID
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setCCHGroupTaxID($cCHGroupTaxID = null)
    {
        // validation for constraint: int
        if (!is_null($cCHGroupTaxID) && !is_numeric($cCHGroupTaxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cCHGroupTaxID)), __LINE__);
        }
        $this->CCHGroupTaxID = $cCHGroupTaxID;
        return $this;
    }
    /**
     * Get AccountTransactionID value
     * @return int
     */
    public function getAccountTransactionID()
    {
        return $this->AccountTransactionID;
    }
    /**
     * Set AccountTransactionID value
     * @param int $accountTransactionID
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setAccountTransactionID($accountTransactionID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTransactionID) && !is_numeric($accountTransactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTransactionID)), __LINE__);
        }
        $this->AccountTransactionID = $accountTransactionID;
        return $this;
    }
    /**
     * Get TaxAuthorityID value
     * @return int
     */
    public function getTaxAuthorityID()
    {
        return $this->TaxAuthorityID;
    }
    /**
     * Set TaxAuthorityID value
     * @param int $taxAuthorityID
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setTaxAuthorityID($taxAuthorityID = null)
    {
        // validation for constraint: int
        if (!is_null($taxAuthorityID) && !is_numeric($taxAuthorityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($taxAuthorityID)), __LINE__);
        }
        $this->TaxAuthorityID = $taxAuthorityID;
        return $this;
    }
    /**
     * Get RevenueBase value
     * @return float
     */
    public function getRevenueBase()
    {
        return $this->RevenueBase;
    }
    /**
     * Set RevenueBase value
     * @param float $revenueBase
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setRevenueBase($revenueBase = null)
    {
        $this->RevenueBase = $revenueBase;
        return $this;
    }
    /**
     * Get TaxRate value
     * @return float
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param float $taxRate
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setTaxRate($taxRate = null)
    {
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get PercentageTaxable value
     * @return float
     */
    public function getPercentageTaxable()
    {
        return $this->PercentageTaxable;
    }
    /**
     * Set PercentageTaxable value
     * @param float $percentageTaxable
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setPercentageTaxable($percentageTaxable = null)
    {
        $this->PercentageTaxable = $percentageTaxable;
        return $this;
    }
    /**
     * Get Tax value
     * @return float
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setTax($tax = null)
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get TaxOnTax value
     * @return float
     */
    public function getTaxOnTax()
    {
        return $this->TaxOnTax;
    }
    /**
     * Set TaxOnTax value
     * @param float $taxOnTax
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setTaxOnTax($taxOnTax = null)
    {
        $this->TaxOnTax = $taxOnTax;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return float
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * Set TaxTotal value
     * @param float $taxTotal
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setTaxTotal($taxTotal = null)
    {
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get TaxAccrualBalance value
     * @return float
     */
    public function getTaxAccrualBalance()
    {
        return $this->TaxAccrualBalance;
    }
    /**
     * Set TaxAccrualBalance value
     * @param float $taxAccrualBalance
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setTaxAccrualBalance($taxAccrualBalance = null)
    {
        $this->TaxAccrualBalance = $taxAccrualBalance;
        return $this;
    }
    /**
     * Get IsPosted value
     * @return bool
     */
    public function getIsPosted()
    {
        return $this->IsPosted;
    }
    /**
     * Set IsPosted value
     * @param bool $isPosted
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setIsPosted($isPosted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPosted) && !is_bool($isPosted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPosted)), __LINE__);
        }
        $this->IsPosted = $isPosted;
        return $this;
    }
    /**
     * Get PostedAmount value
     * @return float
     */
    public function getPostedAmount()
    {
        return $this->PostedAmount;
    }
    /**
     * Set PostedAmount value
     * @param float $postedAmount
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setPostedAmount($postedAmount = null)
    {
        $this->PostedAmount = $postedAmount;
        return $this;
    }
    /**
     * Get UseForAccrual value
     * @return bool
     */
    public function getUseForAccrual()
    {
        return $this->UseForAccrual;
    }
    /**
     * Set UseForAccrual value
     * @param bool $useForAccrual
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setUseForAccrual($useForAccrual = null)
    {
        // validation for constraint: boolean
        if (!is_null($useForAccrual) && !is_bool($useForAccrual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useForAccrual)), __LINE__);
        }
        $this->UseForAccrual = $useForAccrual;
        return $this;
    }
    /**
     * Get TaxAuthorityName value
     * @return string|null
     */
    public function getTaxAuthorityName()
    {
        return $this->TaxAuthorityName;
    }
    /**
     * Set TaxAuthorityName value
     * @param string $taxAuthorityName
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setTaxAuthorityName($taxAuthorityName = null)
    {
        // validation for constraint: string
        if (!is_null($taxAuthorityName) && !is_string($taxAuthorityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxAuthorityName)), __LINE__);
        }
        $this->TaxAuthorityName = $taxAuthorityName;
        return $this;
    }
    /**
     * Get TaxAuthorityType value
     * @return string|null
     */
    public function getTaxAuthorityType()
    {
        return $this->TaxAuthorityType;
    }
    /**
     * Set TaxAuthorityType value
     * @param string $taxAuthorityType
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setTaxAuthorityType($taxAuthorityType = null)
    {
        // validation for constraint: string
        if (!is_null($taxAuthorityType) && !is_string($taxAuthorityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxAuthorityType)), __LINE__);
        }
        $this->TaxAuthorityType = $taxAuthorityType;
        return $this;
    }
    /**
     * Get TaxTypeCode value
     * @return string|null
     */
    public function getTaxTypeCode()
    {
        return $this->TaxTypeCode;
    }
    /**
     * Set TaxTypeCode value
     * @param string $taxTypeCode
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setTaxTypeCode($taxTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxTypeCode) && !is_string($taxTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxTypeCode)), __LINE__);
        }
        $this->TaxTypeCode = $taxTypeCode;
        return $this;
    }
    /**
     * Get TaxTypeDescription value
     * @return string|null
     */
    public function getTaxTypeDescription()
    {
        return $this->TaxTypeDescription;
    }
    /**
     * Set TaxTypeDescription value
     * @param string $taxTypeDescription
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setTaxTypeDescription($taxTypeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($taxTypeDescription) && !is_string($taxTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxTypeDescription)), __LINE__);
        }
        $this->TaxTypeDescription = $taxTypeDescription;
        return $this;
    }
    /**
     * Get CountyName value
     * @return string|null
     */
    public function getCountyName()
    {
        return $this->CountyName;
    }
    /**
     * Set CountyName value
     * @param string $countyName
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setCountyName($countyName = null)
    {
        // validation for constraint: string
        if (!is_null($countyName) && !is_string($countyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countyName)), __LINE__);
        }
        $this->CountyName = $countyName;
        return $this;
    }
    /**
     * Get LocationTaxAuthType value
     * @return string|null
     */
    public function getLocationTaxAuthType()
    {
        return $this->LocationTaxAuthType;
    }
    /**
     * Set LocationTaxAuthType value
     * @param string $locationTaxAuthType
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public function setLocationTaxAuthType($locationTaxAuthType = null)
    {
        // validation for constraint: string
        if (!is_null($locationTaxAuthType) && !is_string($locationTaxAuthType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationTaxAuthType)), __LINE__);
        }
        $this->LocationTaxAuthType = $locationTaxAuthType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\CCHGroupTaxDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
