<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CCHGroupTax Struct
 * @subpackage Structs
 */
class CCHGroupTax extends AbstractStructBase
{
    /**
     * The CCHGroupTaxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CCHGroupTaxID;
    /**
     * The BillServicePointChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointChargeID;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The Revenue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Revenue;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Tax;
    /**
     * The TaxOnTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxOnTax;
    /**
     * The TaxTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxTotal;
    /**
     * The EffectiveRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EffectiveRate;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The TaxTransactionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TaxTransactionDate;
    /**
     * The StateCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateCode;
    /**
     * The LineNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LineNumber;
    /**
     * The InvoiceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The CustomerNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The TransactionTypeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionTypeCode;
    /**
     * The TransactionServiceDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionServiceDescription;
    /**
     * The CchGroupTaxDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfCCHGroupTaxDetail
     */
    public $CchGroupTaxDetails;
    /**
     * Constructor method for CCHGroupTax
     * @uses CCHGroupTax::setCCHGroupTaxID()
     * @uses CCHGroupTax::setBillServicePointChargeID()
     * @uses CCHGroupTax::setAccountServicePointID()
     * @uses CCHGroupTax::setRevenue()
     * @uses CCHGroupTax::setTax()
     * @uses CCHGroupTax::setTaxOnTax()
     * @uses CCHGroupTax::setTaxTotal()
     * @uses CCHGroupTax::setEffectiveRate()
     * @uses CCHGroupTax::setCreateDate()
     * @uses CCHGroupTax::setTaxTransactionDate()
     * @uses CCHGroupTax::setStateCode()
     * @uses CCHGroupTax::setLineNumber()
     * @uses CCHGroupTax::setInvoiceNumber()
     * @uses CCHGroupTax::setCustomerNumber()
     * @uses CCHGroupTax::setTransactionTypeCode()
     * @uses CCHGroupTax::setTransactionServiceDescription()
     * @uses CCHGroupTax::setCchGroupTaxDetails()
     * @param int $cCHGroupTaxID
     * @param int $billServicePointChargeID
     * @param int $accountServicePointID
     * @param float $revenue
     * @param float $tax
     * @param float $taxOnTax
     * @param float $taxTotal
     * @param float $effectiveRate
     * @param string $createDate
     * @param string $taxTransactionDate
     * @param string $stateCode
     * @param string $lineNumber
     * @param string $invoiceNumber
     * @param string $customerNumber
     * @param string $transactionTypeCode
     * @param string $transactionServiceDescription
     * @param \SGCIS\Array\ArrayOfCCHGroupTaxDetail $cchGroupTaxDetails
     */
    public function __construct($cCHGroupTaxID = null, $billServicePointChargeID = null, $accountServicePointID = null, $revenue = null, $tax = null, $taxOnTax = null, $taxTotal = null, $effectiveRate = null, $createDate = null, $taxTransactionDate = null, $stateCode = null, $lineNumber = null, $invoiceNumber = null, $customerNumber = null, $transactionTypeCode = null, $transactionServiceDescription = null, \SGCIS\Array\ArrayOfCCHGroupTaxDetail $cchGroupTaxDetails = null)
    {
        $this
            ->setCCHGroupTaxID($cCHGroupTaxID)
            ->setBillServicePointChargeID($billServicePointChargeID)
            ->setAccountServicePointID($accountServicePointID)
            ->setRevenue($revenue)
            ->setTax($tax)
            ->setTaxOnTax($taxOnTax)
            ->setTaxTotal($taxTotal)
            ->setEffectiveRate($effectiveRate)
            ->setCreateDate($createDate)
            ->setTaxTransactionDate($taxTransactionDate)
            ->setStateCode($stateCode)
            ->setLineNumber($lineNumber)
            ->setInvoiceNumber($invoiceNumber)
            ->setCustomerNumber($customerNumber)
            ->setTransactionTypeCode($transactionTypeCode)
            ->setTransactionServiceDescription($transactionServiceDescription)
            ->setCchGroupTaxDetails($cchGroupTaxDetails);
    }
    /**
     * Get CCHGroupTaxID value
     * @return int
     */
    public function getCCHGroupTaxID()
    {
        return $this->CCHGroupTaxID;
    }
    /**
     * Set CCHGroupTaxID value
     * @param int $cCHGroupTaxID
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setCCHGroupTaxID($cCHGroupTaxID = null)
    {
        // validation for constraint: int
        if (!is_null($cCHGroupTaxID) && !is_numeric($cCHGroupTaxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cCHGroupTaxID)), __LINE__);
        }
        $this->CCHGroupTaxID = $cCHGroupTaxID;
        return $this;
    }
    /**
     * Get BillServicePointChargeID value
     * @return int
     */
    public function getBillServicePointChargeID()
    {
        return $this->BillServicePointChargeID;
    }
    /**
     * Set BillServicePointChargeID value
     * @param int $billServicePointChargeID
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setBillServicePointChargeID($billServicePointChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointChargeID) && !is_numeric($billServicePointChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointChargeID)), __LINE__);
        }
        $this->BillServicePointChargeID = $billServicePointChargeID;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get Revenue value
     * @return float
     */
    public function getRevenue()
    {
        return $this->Revenue;
    }
    /**
     * Set Revenue value
     * @param float $revenue
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setRevenue($revenue = null)
    {
        $this->Revenue = $revenue;
        return $this;
    }
    /**
     * Get Tax value
     * @return float
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setTax($tax = null)
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get TaxOnTax value
     * @return float
     */
    public function getTaxOnTax()
    {
        return $this->TaxOnTax;
    }
    /**
     * Set TaxOnTax value
     * @param float $taxOnTax
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setTaxOnTax($taxOnTax = null)
    {
        $this->TaxOnTax = $taxOnTax;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return float
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * Set TaxTotal value
     * @param float $taxTotal
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setTaxTotal($taxTotal = null)
    {
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get EffectiveRate value
     * @return float
     */
    public function getEffectiveRate()
    {
        return $this->EffectiveRate;
    }
    /**
     * Set EffectiveRate value
     * @param float $effectiveRate
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setEffectiveRate($effectiveRate = null)
    {
        $this->EffectiveRate = $effectiveRate;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get TaxTransactionDate value
     * @return string
     */
    public function getTaxTransactionDate()
    {
        return $this->TaxTransactionDate;
    }
    /**
     * Set TaxTransactionDate value
     * @param string $taxTransactionDate
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setTaxTransactionDate($taxTransactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($taxTransactionDate) && !is_string($taxTransactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxTransactionDate)), __LINE__);
        }
        $this->TaxTransactionDate = $taxTransactionDate;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get LineNumber value
     * @return string|null
     */
    public function getLineNumber()
    {
        return $this->LineNumber;
    }
    /**
     * Set LineNumber value
     * @param string $lineNumber
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lineNumber) && !is_string($lineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineNumber)), __LINE__);
        }
        $this->LineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get TransactionTypeCode value
     * @return string|null
     */
    public function getTransactionTypeCode()
    {
        return $this->TransactionTypeCode;
    }
    /**
     * Set TransactionTypeCode value
     * @param string $transactionTypeCode
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setTransactionTypeCode($transactionTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionTypeCode) && !is_string($transactionTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionTypeCode)), __LINE__);
        }
        $this->TransactionTypeCode = $transactionTypeCode;
        return $this;
    }
    /**
     * Get TransactionServiceDescription value
     * @return string|null
     */
    public function getTransactionServiceDescription()
    {
        return $this->TransactionServiceDescription;
    }
    /**
     * Set TransactionServiceDescription value
     * @param string $transactionServiceDescription
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setTransactionServiceDescription($transactionServiceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($transactionServiceDescription) && !is_string($transactionServiceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionServiceDescription)), __LINE__);
        }
        $this->TransactionServiceDescription = $transactionServiceDescription;
        return $this;
    }
    /**
     * Get CchGroupTaxDetails value
     * @return \SGCIS\Array\ArrayOfCCHGroupTaxDetail|null
     */
    public function getCchGroupTaxDetails()
    {
        return $this->CchGroupTaxDetails;
    }
    /**
     * Set CchGroupTaxDetails value
     * @param \SGCIS\Array\ArrayOfCCHGroupTaxDetail $cchGroupTaxDetails
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public function setCchGroupTaxDetails(\SGCIS\Array\ArrayOfCCHGroupTaxDetail $cchGroupTaxDetails = null)
    {
        $this->CchGroupTaxDetails = $cchGroupTaxDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\CCHGroupTax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
