<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingRequest Struct
 * @subpackage Structs
 */
class BillingRequest extends ServiceRequestBase
{
    /**
     * The BillCalculationMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillCalculationMethodID;
    /**
     * The BillStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillStatusID;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The NumberOfLastBills
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfLastBills;
    /**
     * The BillIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfInt
     */
    public $BillIDs;
    /**
     * The IntervalBillIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfInt
     */
    public $IntervalBillIDs;
    /**
     * The BillChargeDisplayItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillChargeDisplayItem
     */
    public $BillChargeDisplayItems;
    /**
     * The Bill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Bill
     */
    public $Bill;
    /**
     * The Bills
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBill
     */
    public $Bills;
    /**
     * The QueryParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\BillApprovalQueryParameters
     */
    public $QueryParameters;
    /**
     * The TNIQueryParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\TransactionsNotImportedQueryParameters
     */
    public $TNIQueryParameters;
    /**
     * The EDIID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EDIID;
    /**
     * Constructor method for BillingRequest
     * @uses BillingRequest::setBillCalculationMethodID()
     * @uses BillingRequest::setBillStatusID()
     * @uses BillingRequest::setBillID()
     * @uses BillingRequest::setAccountID()
     * @uses BillingRequest::setUserID()
     * @uses BillingRequest::setNumberOfLastBills()
     * @uses BillingRequest::setBillIDs()
     * @uses BillingRequest::setIntervalBillIDs()
     * @uses BillingRequest::setBillChargeDisplayItems()
     * @uses BillingRequest::setBill()
     * @uses BillingRequest::setBills()
     * @uses BillingRequest::setQueryParameters()
     * @uses BillingRequest::setTNIQueryParameters()
     * @uses BillingRequest::setEDIID()
     * @param int $billCalculationMethodID
     * @param int $billStatusID
     * @param int $billID
     * @param int $accountID
     * @param int $userID
     * @param int $numberOfLastBills
     * @param \SGCIS\Array\ArrayOfInt $billIDs
     * @param \SGCIS\Array\ArrayOfInt $intervalBillIDs
     * @param \SGCIS\Array\ArrayOfBillChargeDisplayItem $billChargeDisplayItems
     * @param \SGCIS\Struct\Bill $bill
     * @param \SGCIS\Array\ArrayOfBill $bills
     * @param \SGCIS\Struct\BillApprovalQueryParameters $queryParameters
     * @param \SGCIS\Struct\TransactionsNotImportedQueryParameters $tNIQueryParameters
     * @param string $eDIID
     */
    public function __construct($billCalculationMethodID = null, $billStatusID = null, $billID = null, $accountID = null, $userID = null, $numberOfLastBills = null, \SGCIS\Array\ArrayOfInt $billIDs = null, \SGCIS\Array\ArrayOfInt $intervalBillIDs = null, \SGCIS\Array\ArrayOfBillChargeDisplayItem $billChargeDisplayItems = null, \SGCIS\Struct\Bill $bill = null, \SGCIS\Array\ArrayOfBill $bills = null, \SGCIS\Struct\BillApprovalQueryParameters $queryParameters = null, \SGCIS\Struct\TransactionsNotImportedQueryParameters $tNIQueryParameters = null, $eDIID = null)
    {
        $this
            ->setBillCalculationMethodID($billCalculationMethodID)
            ->setBillStatusID($billStatusID)
            ->setBillID($billID)
            ->setAccountID($accountID)
            ->setUserID($userID)
            ->setNumberOfLastBills($numberOfLastBills)
            ->setBillIDs($billIDs)
            ->setIntervalBillIDs($intervalBillIDs)
            ->setBillChargeDisplayItems($billChargeDisplayItems)
            ->setBill($bill)
            ->setBills($bills)
            ->setQueryParameters($queryParameters)
            ->setTNIQueryParameters($tNIQueryParameters)
            ->setEDIID($eDIID);
    }
    /**
     * Get BillCalculationMethodID value
     * @return int
     */
    public function getBillCalculationMethodID()
    {
        return $this->BillCalculationMethodID;
    }
    /**
     * Set BillCalculationMethodID value
     * @param int $billCalculationMethodID
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setBillCalculationMethodID($billCalculationMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($billCalculationMethodID) && !is_numeric($billCalculationMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billCalculationMethodID)), __LINE__);
        }
        $this->BillCalculationMethodID = $billCalculationMethodID;
        return $this;
    }
    /**
     * Get BillStatusID value
     * @return int
     */
    public function getBillStatusID()
    {
        return $this->BillStatusID;
    }
    /**
     * Set BillStatusID value
     * @param int $billStatusID
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setBillStatusID($billStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($billStatusID) && !is_numeric($billStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billStatusID)), __LINE__);
        }
        $this->BillStatusID = $billStatusID;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get NumberOfLastBills value
     * @return int
     */
    public function getNumberOfLastBills()
    {
        return $this->NumberOfLastBills;
    }
    /**
     * Set NumberOfLastBills value
     * @param int $numberOfLastBills
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setNumberOfLastBills($numberOfLastBills = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfLastBills) && !is_numeric($numberOfLastBills)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfLastBills)), __LINE__);
        }
        $this->NumberOfLastBills = $numberOfLastBills;
        return $this;
    }
    /**
     * Get BillIDs value
     * @return \SGCIS\Array\ArrayOfInt|null
     */
    public function getBillIDs()
    {
        return $this->BillIDs;
    }
    /**
     * Set BillIDs value
     * @param \SGCIS\Array\ArrayOfInt $billIDs
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setBillIDs(\SGCIS\Array\ArrayOfInt $billIDs = null)
    {
        $this->BillIDs = $billIDs;
        return $this;
    }
    /**
     * Get IntervalBillIDs value
     * @return \SGCIS\Array\ArrayOfInt|null
     */
    public function getIntervalBillIDs()
    {
        return $this->IntervalBillIDs;
    }
    /**
     * Set IntervalBillIDs value
     * @param \SGCIS\Array\ArrayOfInt $intervalBillIDs
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setIntervalBillIDs(\SGCIS\Array\ArrayOfInt $intervalBillIDs = null)
    {
        $this->IntervalBillIDs = $intervalBillIDs;
        return $this;
    }
    /**
     * Get BillChargeDisplayItems value
     * @return \SGCIS\Array\ArrayOfBillChargeDisplayItem|null
     */
    public function getBillChargeDisplayItems()
    {
        return $this->BillChargeDisplayItems;
    }
    /**
     * Set BillChargeDisplayItems value
     * @param \SGCIS\Array\ArrayOfBillChargeDisplayItem $billChargeDisplayItems
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setBillChargeDisplayItems(\SGCIS\Array\ArrayOfBillChargeDisplayItem $billChargeDisplayItems = null)
    {
        $this->BillChargeDisplayItems = $billChargeDisplayItems;
        return $this;
    }
    /**
     * Get Bill value
     * @return \SGCIS\Struct\Bill|null
     */
    public function getBill()
    {
        return $this->Bill;
    }
    /**
     * Set Bill value
     * @param \SGCIS\Struct\Bill $bill
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setBill(\SGCIS\Struct\Bill $bill = null)
    {
        $this->Bill = $bill;
        return $this;
    }
    /**
     * Get Bills value
     * @return \SGCIS\Array\ArrayOfBill|null
     */
    public function getBills()
    {
        return $this->Bills;
    }
    /**
     * Set Bills value
     * @param \SGCIS\Array\ArrayOfBill $bills
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setBills(\SGCIS\Array\ArrayOfBill $bills = null)
    {
        $this->Bills = $bills;
        return $this;
    }
    /**
     * Get QueryParameters value
     * @return \SGCIS\Struct\BillApprovalQueryParameters|null
     */
    public function getQueryParameters()
    {
        return $this->QueryParameters;
    }
    /**
     * Set QueryParameters value
     * @param \SGCIS\Struct\BillApprovalQueryParameters $queryParameters
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setQueryParameters(\SGCIS\Struct\BillApprovalQueryParameters $queryParameters = null)
    {
        $this->QueryParameters = $queryParameters;
        return $this;
    }
    /**
     * Get TNIQueryParameters value
     * @return \SGCIS\Struct\TransactionsNotImportedQueryParameters|null
     */
    public function getTNIQueryParameters()
    {
        return $this->TNIQueryParameters;
    }
    /**
     * Set TNIQueryParameters value
     * @param \SGCIS\Struct\TransactionsNotImportedQueryParameters $tNIQueryParameters
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setTNIQueryParameters(\SGCIS\Struct\TransactionsNotImportedQueryParameters $tNIQueryParameters = null)
    {
        $this->TNIQueryParameters = $tNIQueryParameters;
        return $this;
    }
    /**
     * Get EDIID value
     * @return string|null
     */
    public function getEDIID()
    {
        return $this->EDIID;
    }
    /**
     * Set EDIID value
     * @param string $eDIID
     * @return \SGCIS\Struct\BillingRequest
     */
    public function setEDIID($eDIID = null)
    {
        // validation for constraint: string
        if (!is_null($eDIID) && !is_string($eDIID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eDIID)), __LINE__);
        }
        $this->EDIID = $eDIID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
