<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillUserNote Struct
 * @subpackage Structs
 */
class BillUserNote extends AbstractStructBase
{
    /**
     * The BillUserNoteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillUserNoteID;
    /**
     * The MasterBillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MasterBillID;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The NoteDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NoteDate;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The NoteText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoteText;
    /**
     * Constructor method for BillUserNote
     * @uses BillUserNote::setBillUserNoteID()
     * @uses BillUserNote::setMasterBillID()
     * @uses BillUserNote::setBillID()
     * @uses BillUserNote::setNoteDate()
     * @uses BillUserNote::setUserName()
     * @uses BillUserNote::setNoteText()
     * @param int $billUserNoteID
     * @param int $masterBillID
     * @param int $billID
     * @param string $noteDate
     * @param string $userName
     * @param string $noteText
     */
    public function __construct($billUserNoteID = null, $masterBillID = null, $billID = null, $noteDate = null, $userName = null, $noteText = null)
    {
        $this
            ->setBillUserNoteID($billUserNoteID)
            ->setMasterBillID($masterBillID)
            ->setBillID($billID)
            ->setNoteDate($noteDate)
            ->setUserName($userName)
            ->setNoteText($noteText);
    }
    /**
     * Get BillUserNoteID value
     * @return int
     */
    public function getBillUserNoteID()
    {
        return $this->BillUserNoteID;
    }
    /**
     * Set BillUserNoteID value
     * @param int $billUserNoteID
     * @return \SGCIS\Struct\BillUserNote
     */
    public function setBillUserNoteID($billUserNoteID = null)
    {
        // validation for constraint: int
        if (!is_null($billUserNoteID) && !is_numeric($billUserNoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billUserNoteID)), __LINE__);
        }
        $this->BillUserNoteID = $billUserNoteID;
        return $this;
    }
    /**
     * Get MasterBillID value
     * @return int
     */
    public function getMasterBillID()
    {
        return $this->MasterBillID;
    }
    /**
     * Set MasterBillID value
     * @param int $masterBillID
     * @return \SGCIS\Struct\BillUserNote
     */
    public function setMasterBillID($masterBillID = null)
    {
        // validation for constraint: int
        if (!is_null($masterBillID) && !is_numeric($masterBillID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($masterBillID)), __LINE__);
        }
        $this->MasterBillID = $masterBillID;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\BillUserNote
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get NoteDate value
     * @return string
     */
    public function getNoteDate()
    {
        return $this->NoteDate;
    }
    /**
     * Set NoteDate value
     * @param string $noteDate
     * @return \SGCIS\Struct\BillUserNote
     */
    public function setNoteDate($noteDate = null)
    {
        // validation for constraint: string
        if (!is_null($noteDate) && !is_string($noteDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noteDate)), __LINE__);
        }
        $this->NoteDate = $noteDate;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\BillUserNote
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get NoteText value
     * @return string|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param string $noteText
     * @return \SGCIS\Struct\BillUserNote
     */
    public function setNoteText($noteText = null)
    {
        // validation for constraint: string
        if (!is_null($noteText) && !is_string($noteText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noteText)), __LINE__);
        }
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillUserNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
