<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillStatusHistory Struct
 * @subpackage Structs
 */
class BillStatusHistory extends AbstractStructBase
{
    /**
     * The BillStatusHistoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillStatusHistoryID;
    /**
     * The MasterBillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MasterBillID;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The BillStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillStatusID;
    /**
     * The StatusDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StatusDate;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for BillStatusHistory
     * @uses BillStatusHistory::setBillStatusHistoryID()
     * @uses BillStatusHistory::setMasterBillID()
     * @uses BillStatusHistory::setBillID()
     * @uses BillStatusHistory::setBillStatusID()
     * @uses BillStatusHistory::setStatusDate()
     * @uses BillStatusHistory::setCreateDate()
     * @uses BillStatusHistory::setUserName()
     * @param int $billStatusHistoryID
     * @param int $masterBillID
     * @param int $billID
     * @param int $billStatusID
     * @param string $statusDate
     * @param string $createDate
     * @param string $userName
     */
    public function __construct($billStatusHistoryID = null, $masterBillID = null, $billID = null, $billStatusID = null, $statusDate = null, $createDate = null, $userName = null)
    {
        $this
            ->setBillStatusHistoryID($billStatusHistoryID)
            ->setMasterBillID($masterBillID)
            ->setBillID($billID)
            ->setBillStatusID($billStatusID)
            ->setStatusDate($statusDate)
            ->setCreateDate($createDate)
            ->setUserName($userName);
    }
    /**
     * Get BillStatusHistoryID value
     * @return int
     */
    public function getBillStatusHistoryID()
    {
        return $this->BillStatusHistoryID;
    }
    /**
     * Set BillStatusHistoryID value
     * @param int $billStatusHistoryID
     * @return \SGCIS\Struct\BillStatusHistory
     */
    public function setBillStatusHistoryID($billStatusHistoryID = null)
    {
        // validation for constraint: int
        if (!is_null($billStatusHistoryID) && !is_numeric($billStatusHistoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billStatusHistoryID)), __LINE__);
        }
        $this->BillStatusHistoryID = $billStatusHistoryID;
        return $this;
    }
    /**
     * Get MasterBillID value
     * @return int
     */
    public function getMasterBillID()
    {
        return $this->MasterBillID;
    }
    /**
     * Set MasterBillID value
     * @param int $masterBillID
     * @return \SGCIS\Struct\BillStatusHistory
     */
    public function setMasterBillID($masterBillID = null)
    {
        // validation for constraint: int
        if (!is_null($masterBillID) && !is_numeric($masterBillID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($masterBillID)), __LINE__);
        }
        $this->MasterBillID = $masterBillID;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\BillStatusHistory
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get BillStatusID value
     * @return int
     */
    public function getBillStatusID()
    {
        return $this->BillStatusID;
    }
    /**
     * Set BillStatusID value
     * @param int $billStatusID
     * @return \SGCIS\Struct\BillStatusHistory
     */
    public function setBillStatusID($billStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($billStatusID) && !is_numeric($billStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billStatusID)), __LINE__);
        }
        $this->BillStatusID = $billStatusID;
        return $this;
    }
    /**
     * Get StatusDate value
     * @return string
     */
    public function getStatusDate()
    {
        return $this->StatusDate;
    }
    /**
     * Set StatusDate value
     * @param string $statusDate
     * @return \SGCIS\Struct\BillStatusHistory
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDate)), __LINE__);
        }
        $this->StatusDate = $statusDate;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\BillStatusHistory
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\BillStatusHistory
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillStatusHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
