<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillServicePoint Struct
 * @subpackage Structs
 */
class BillServicePoint extends AbstractStructBase
{
    /**
     * The BillServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointID;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The IsFirstBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFirstBill;
    /**
     * The IsFinalBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFinalBill;
    /**
     * The FlatBillingTotalActualBills
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FlatBillingTotalActualBills;
    /**
     * The FlatBillingTotalPlanDifference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FlatBillingTotalPlanDifference;
    /**
     * The FlatBillingTotalFlatBilling
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FlatBillingTotalFlatBilling;
    /**
     * The FlatBillAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FlatBillAmount;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The AddressCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressCity;
    /**
     * The AddressState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressState;
    /**
     * The AddressZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressZipCode;
    /**
     * The BillHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\BillHeader
     */
    public $BillHeader;
    /**
     * The ServicePointCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillServicePointCharge
     */
    public $ServicePointCharges;
    /**
     * The ServicePointMeteredUsage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillServicePointMeteredUsage
     */
    public $ServicePointMeteredUsage;
    /**
     * The BillServicePointExceptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillServicePointBillingException
     */
    public $BillServicePointExceptions;
    /**
     * The Rates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfRate
     */
    public $Rates;
    /**
     * The ContractDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillServicePointContractDetail
     */
    public $ContractDetails;
    /**
     * The ServicePointMeterReads
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfMeterRead
     */
    public $ServicePointMeterReads;
    /**
     * The BillNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillNumber;
    /**
     * The FlatBillingMonthYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlatBillingMonthYear;
    /**
     * Constructor method for BillServicePoint
     * @uses BillServicePoint::setBillServicePointID()
     * @uses BillServicePoint::setBillID()
     * @uses BillServicePoint::setAccountServicePointID()
     * @uses BillServicePoint::setDistributionServiceProviderID()
     * @uses BillServicePoint::setCreateDate()
     * @uses BillServicePoint::setIsFirstBill()
     * @uses BillServicePoint::setIsFinalBill()
     * @uses BillServicePoint::setFlatBillingTotalActualBills()
     * @uses BillServicePoint::setFlatBillingTotalPlanDifference()
     * @uses BillServicePoint::setFlatBillingTotalFlatBilling()
     * @uses BillServicePoint::setFlatBillAmount()
     * @uses BillServicePoint::setServiceProviderIdentifier()
     * @uses BillServicePoint::setCompanyName()
     * @uses BillServicePoint::setAddress1()
     * @uses BillServicePoint::setAddress2()
     * @uses BillServicePoint::setAddressCity()
     * @uses BillServicePoint::setAddressState()
     * @uses BillServicePoint::setAddressZipCode()
     * @uses BillServicePoint::setBillHeader()
     * @uses BillServicePoint::setServicePointCharges()
     * @uses BillServicePoint::setServicePointMeteredUsage()
     * @uses BillServicePoint::setBillServicePointExceptions()
     * @uses BillServicePoint::setRates()
     * @uses BillServicePoint::setContractDetails()
     * @uses BillServicePoint::setServicePointMeterReads()
     * @uses BillServicePoint::setBillNumber()
     * @uses BillServicePoint::setFlatBillingMonthYear()
     * @param int $billServicePointID
     * @param int $billID
     * @param int $accountServicePointID
     * @param int $distributionServiceProviderID
     * @param string $createDate
     * @param bool $isFirstBill
     * @param bool $isFinalBill
     * @param float $flatBillingTotalActualBills
     * @param float $flatBillingTotalPlanDifference
     * @param float $flatBillingTotalFlatBilling
     * @param float $flatBillAmount
     * @param string $serviceProviderIdentifier
     * @param string $companyName
     * @param string $address1
     * @param string $address2
     * @param string $addressCity
     * @param string $addressState
     * @param string $addressZipCode
     * @param \SGCIS\Struct\BillHeader $billHeader
     * @param \SGCIS\Array\ArrayOfBillServicePointCharge $servicePointCharges
     * @param \SGCIS\Array\ArrayOfBillServicePointMeteredUsage $servicePointMeteredUsage
     * @param \SGCIS\Array\ArrayOfBillServicePointBillingException $billServicePointExceptions
     * @param \SGCIS\Array\ArrayOfRate $rates
     * @param \SGCIS\Array\ArrayOfBillServicePointContractDetail $contractDetails
     * @param \SGCIS\Array\ArrayOfMeterRead $servicePointMeterReads
     * @param string $billNumber
     * @param string $flatBillingMonthYear
     */
    public function __construct($billServicePointID = null, $billID = null, $accountServicePointID = null, $distributionServiceProviderID = null, $createDate = null, $isFirstBill = null, $isFinalBill = null, $flatBillingTotalActualBills = null, $flatBillingTotalPlanDifference = null, $flatBillingTotalFlatBilling = null, $flatBillAmount = null, $serviceProviderIdentifier = null, $companyName = null, $address1 = null, $address2 = null, $addressCity = null, $addressState = null, $addressZipCode = null, \SGCIS\Struct\BillHeader $billHeader = null, \SGCIS\Array\ArrayOfBillServicePointCharge $servicePointCharges = null, \SGCIS\Array\ArrayOfBillServicePointMeteredUsage $servicePointMeteredUsage = null, \SGCIS\Array\ArrayOfBillServicePointBillingException $billServicePointExceptions = null, \SGCIS\Array\ArrayOfRate $rates = null, \SGCIS\Array\ArrayOfBillServicePointContractDetail $contractDetails = null, \SGCIS\Array\ArrayOfMeterRead $servicePointMeterReads = null, $billNumber = null, $flatBillingMonthYear = null)
    {
        $this
            ->setBillServicePointID($billServicePointID)
            ->setBillID($billID)
            ->setAccountServicePointID($accountServicePointID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setCreateDate($createDate)
            ->setIsFirstBill($isFirstBill)
            ->setIsFinalBill($isFinalBill)
            ->setFlatBillingTotalActualBills($flatBillingTotalActualBills)
            ->setFlatBillingTotalPlanDifference($flatBillingTotalPlanDifference)
            ->setFlatBillingTotalFlatBilling($flatBillingTotalFlatBilling)
            ->setFlatBillAmount($flatBillAmount)
            ->setServiceProviderIdentifier($serviceProviderIdentifier)
            ->setCompanyName($companyName)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddressCity($addressCity)
            ->setAddressState($addressState)
            ->setAddressZipCode($addressZipCode)
            ->setBillHeader($billHeader)
            ->setServicePointCharges($servicePointCharges)
            ->setServicePointMeteredUsage($servicePointMeteredUsage)
            ->setBillServicePointExceptions($billServicePointExceptions)
            ->setRates($rates)
            ->setContractDetails($contractDetails)
            ->setServicePointMeterReads($servicePointMeterReads)
            ->setBillNumber($billNumber)
            ->setFlatBillingMonthYear($flatBillingMonthYear);
    }
    /**
     * Get BillServicePointID value
     * @return int
     */
    public function getBillServicePointID()
    {
        return $this->BillServicePointID;
    }
    /**
     * Set BillServicePointID value
     * @param int $billServicePointID
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setBillServicePointID($billServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointID) && !is_numeric($billServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointID)), __LINE__);
        }
        $this->BillServicePointID = $billServicePointID;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get IsFirstBill value
     * @return bool
     */
    public function getIsFirstBill()
    {
        return $this->IsFirstBill;
    }
    /**
     * Set IsFirstBill value
     * @param bool $isFirstBill
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setIsFirstBill($isFirstBill = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFirstBill) && !is_bool($isFirstBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isFirstBill)), __LINE__);
        }
        $this->IsFirstBill = $isFirstBill;
        return $this;
    }
    /**
     * Get IsFinalBill value
     * @return bool
     */
    public function getIsFinalBill()
    {
        return $this->IsFinalBill;
    }
    /**
     * Set IsFinalBill value
     * @param bool $isFinalBill
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setIsFinalBill($isFinalBill = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFinalBill) && !is_bool($isFinalBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isFinalBill)), __LINE__);
        }
        $this->IsFinalBill = $isFinalBill;
        return $this;
    }
    /**
     * Get FlatBillingTotalActualBills value
     * @return float
     */
    public function getFlatBillingTotalActualBills()
    {
        return $this->FlatBillingTotalActualBills;
    }
    /**
     * Set FlatBillingTotalActualBills value
     * @param float $flatBillingTotalActualBills
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setFlatBillingTotalActualBills($flatBillingTotalActualBills = null)
    {
        $this->FlatBillingTotalActualBills = $flatBillingTotalActualBills;
        return $this;
    }
    /**
     * Get FlatBillingTotalPlanDifference value
     * @return float
     */
    public function getFlatBillingTotalPlanDifference()
    {
        return $this->FlatBillingTotalPlanDifference;
    }
    /**
     * Set FlatBillingTotalPlanDifference value
     * @param float $flatBillingTotalPlanDifference
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setFlatBillingTotalPlanDifference($flatBillingTotalPlanDifference = null)
    {
        $this->FlatBillingTotalPlanDifference = $flatBillingTotalPlanDifference;
        return $this;
    }
    /**
     * Get FlatBillingTotalFlatBilling value
     * @return float
     */
    public function getFlatBillingTotalFlatBilling()
    {
        return $this->FlatBillingTotalFlatBilling;
    }
    /**
     * Set FlatBillingTotalFlatBilling value
     * @param float $flatBillingTotalFlatBilling
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setFlatBillingTotalFlatBilling($flatBillingTotalFlatBilling = null)
    {
        $this->FlatBillingTotalFlatBilling = $flatBillingTotalFlatBilling;
        return $this;
    }
    /**
     * Get FlatBillAmount value
     * @return float
     */
    public function getFlatBillAmount()
    {
        return $this->FlatBillAmount;
    }
    /**
     * Set FlatBillAmount value
     * @param float $flatBillAmount
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setFlatBillAmount($flatBillAmount = null)
    {
        $this->FlatBillAmount = $flatBillAmount;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get AddressCity value
     * @return string|null
     */
    public function getAddressCity()
    {
        return $this->AddressCity;
    }
    /**
     * Set AddressCity value
     * @param string $addressCity
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setAddressCity($addressCity = null)
    {
        // validation for constraint: string
        if (!is_null($addressCity) && !is_string($addressCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressCity)), __LINE__);
        }
        $this->AddressCity = $addressCity;
        return $this;
    }
    /**
     * Get AddressState value
     * @return string|null
     */
    public function getAddressState()
    {
        return $this->AddressState;
    }
    /**
     * Set AddressState value
     * @param string $addressState
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setAddressState($addressState = null)
    {
        // validation for constraint: string
        if (!is_null($addressState) && !is_string($addressState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressState)), __LINE__);
        }
        $this->AddressState = $addressState;
        return $this;
    }
    /**
     * Get AddressZipCode value
     * @return string|null
     */
    public function getAddressZipCode()
    {
        return $this->AddressZipCode;
    }
    /**
     * Set AddressZipCode value
     * @param string $addressZipCode
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setAddressZipCode($addressZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressZipCode) && !is_string($addressZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressZipCode)), __LINE__);
        }
        $this->AddressZipCode = $addressZipCode;
        return $this;
    }
    /**
     * Get BillHeader value
     * @return \SGCIS\Struct\BillHeader|null
     */
    public function getBillHeader()
    {
        return $this->BillHeader;
    }
    /**
     * Set BillHeader value
     * @param \SGCIS\Struct\BillHeader $billHeader
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setBillHeader(\SGCIS\Struct\BillHeader $billHeader = null)
    {
        $this->BillHeader = $billHeader;
        return $this;
    }
    /**
     * Get ServicePointCharges value
     * @return \SGCIS\Array\ArrayOfBillServicePointCharge|null
     */
    public function getServicePointCharges()
    {
        return $this->ServicePointCharges;
    }
    /**
     * Set ServicePointCharges value
     * @param \SGCIS\Array\ArrayOfBillServicePointCharge $servicePointCharges
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setServicePointCharges(\SGCIS\Array\ArrayOfBillServicePointCharge $servicePointCharges = null)
    {
        $this->ServicePointCharges = $servicePointCharges;
        return $this;
    }
    /**
     * Get ServicePointMeteredUsage value
     * @return \SGCIS\Array\ArrayOfBillServicePointMeteredUsage|null
     */
    public function getServicePointMeteredUsage()
    {
        return $this->ServicePointMeteredUsage;
    }
    /**
     * Set ServicePointMeteredUsage value
     * @param \SGCIS\Array\ArrayOfBillServicePointMeteredUsage $servicePointMeteredUsage
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setServicePointMeteredUsage(\SGCIS\Array\ArrayOfBillServicePointMeteredUsage $servicePointMeteredUsage = null)
    {
        $this->ServicePointMeteredUsage = $servicePointMeteredUsage;
        return $this;
    }
    /**
     * Get BillServicePointExceptions value
     * @return \SGCIS\Array\ArrayOfBillServicePointBillingException|null
     */
    public function getBillServicePointExceptions()
    {
        return $this->BillServicePointExceptions;
    }
    /**
     * Set BillServicePointExceptions value
     * @param \SGCIS\Array\ArrayOfBillServicePointBillingException $billServicePointExceptions
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setBillServicePointExceptions(\SGCIS\Array\ArrayOfBillServicePointBillingException $billServicePointExceptions = null)
    {
        $this->BillServicePointExceptions = $billServicePointExceptions;
        return $this;
    }
    /**
     * Get Rates value
     * @return \SGCIS\Array\ArrayOfRate|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \SGCIS\Array\ArrayOfRate $rates
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setRates(\SGCIS\Array\ArrayOfRate $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get ContractDetails value
     * @return \SGCIS\Array\ArrayOfBillServicePointContractDetail|null
     */
    public function getContractDetails()
    {
        return $this->ContractDetails;
    }
    /**
     * Set ContractDetails value
     * @param \SGCIS\Array\ArrayOfBillServicePointContractDetail $contractDetails
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setContractDetails(\SGCIS\Array\ArrayOfBillServicePointContractDetail $contractDetails = null)
    {
        $this->ContractDetails = $contractDetails;
        return $this;
    }
    /**
     * Get ServicePointMeterReads value
     * @return \SGCIS\Array\ArrayOfMeterRead|null
     */
    public function getServicePointMeterReads()
    {
        return $this->ServicePointMeterReads;
    }
    /**
     * Set ServicePointMeterReads value
     * @param \SGCIS\Array\ArrayOfMeterRead $servicePointMeterReads
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setServicePointMeterReads(\SGCIS\Array\ArrayOfMeterRead $servicePointMeterReads = null)
    {
        $this->ServicePointMeterReads = $servicePointMeterReads;
        return $this;
    }
    /**
     * Get BillNumber value
     * @return string|null
     */
    public function getBillNumber()
    {
        return $this->BillNumber;
    }
    /**
     * Set BillNumber value
     * @param string $billNumber
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setBillNumber($billNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billNumber) && !is_string($billNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billNumber)), __LINE__);
        }
        $this->BillNumber = $billNumber;
        return $this;
    }
    /**
     * Get FlatBillingMonthYear value
     * @return string|null
     */
    public function getFlatBillingMonthYear()
    {
        return $this->FlatBillingMonthYear;
    }
    /**
     * Set FlatBillingMonthYear value
     * @param string $flatBillingMonthYear
     * @return \SGCIS\Struct\BillServicePoint
     */
    public function setFlatBillingMonthYear($flatBillingMonthYear = null)
    {
        // validation for constraint: string
        if (!is_null($flatBillingMonthYear) && !is_string($flatBillingMonthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flatBillingMonthYear)), __LINE__);
        }
        $this->FlatBillingMonthYear = $flatBillingMonthYear;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillServicePoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
