<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillLevelizedBillSummary Struct
 * @subpackage Structs
 */
class BillLevelizedBillSummary extends AbstractStructBase
{
    /**
     * The BillLevelizedBillSummaryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillLevelizedBillSummaryID;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The YearEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $YearEndDate;
    /**
     * The ChargesToDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChargesToDate;
    /**
     * The BillingTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BillingTotal;
    /**
     * The PlanDifference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PlanDifference;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * Constructor method for BillLevelizedBillSummary
     * @uses BillLevelizedBillSummary::setBillLevelizedBillSummaryID()
     * @uses BillLevelizedBillSummary::setBillID()
     * @uses BillLevelizedBillSummary::setYearEndDate()
     * @uses BillLevelizedBillSummary::setChargesToDate()
     * @uses BillLevelizedBillSummary::setBillingTotal()
     * @uses BillLevelizedBillSummary::setPlanDifference()
     * @uses BillLevelizedBillSummary::setCreateDate()
     * @param int $billLevelizedBillSummaryID
     * @param int $billID
     * @param string $yearEndDate
     * @param float $chargesToDate
     * @param float $billingTotal
     * @param float $planDifference
     * @param string $createDate
     */
    public function __construct($billLevelizedBillSummaryID = null, $billID = null, $yearEndDate = null, $chargesToDate = null, $billingTotal = null, $planDifference = null, $createDate = null)
    {
        $this
            ->setBillLevelizedBillSummaryID($billLevelizedBillSummaryID)
            ->setBillID($billID)
            ->setYearEndDate($yearEndDate)
            ->setChargesToDate($chargesToDate)
            ->setBillingTotal($billingTotal)
            ->setPlanDifference($planDifference)
            ->setCreateDate($createDate);
    }
    /**
     * Get BillLevelizedBillSummaryID value
     * @return int
     */
    public function getBillLevelizedBillSummaryID()
    {
        return $this->BillLevelizedBillSummaryID;
    }
    /**
     * Set BillLevelizedBillSummaryID value
     * @param int $billLevelizedBillSummaryID
     * @return \SGCIS\Struct\BillLevelizedBillSummary
     */
    public function setBillLevelizedBillSummaryID($billLevelizedBillSummaryID = null)
    {
        // validation for constraint: int
        if (!is_null($billLevelizedBillSummaryID) && !is_numeric($billLevelizedBillSummaryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billLevelizedBillSummaryID)), __LINE__);
        }
        $this->BillLevelizedBillSummaryID = $billLevelizedBillSummaryID;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\BillLevelizedBillSummary
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get YearEndDate value
     * @return string
     */
    public function getYearEndDate()
    {
        return $this->YearEndDate;
    }
    /**
     * Set YearEndDate value
     * @param string $yearEndDate
     * @return \SGCIS\Struct\BillLevelizedBillSummary
     */
    public function setYearEndDate($yearEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($yearEndDate) && !is_string($yearEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($yearEndDate)), __LINE__);
        }
        $this->YearEndDate = $yearEndDate;
        return $this;
    }
    /**
     * Get ChargesToDate value
     * @return float
     */
    public function getChargesToDate()
    {
        return $this->ChargesToDate;
    }
    /**
     * Set ChargesToDate value
     * @param float $chargesToDate
     * @return \SGCIS\Struct\BillLevelizedBillSummary
     */
    public function setChargesToDate($chargesToDate = null)
    {
        $this->ChargesToDate = $chargesToDate;
        return $this;
    }
    /**
     * Get BillingTotal value
     * @return float
     */
    public function getBillingTotal()
    {
        return $this->BillingTotal;
    }
    /**
     * Set BillingTotal value
     * @param float $billingTotal
     * @return \SGCIS\Struct\BillLevelizedBillSummary
     */
    public function setBillingTotal($billingTotal = null)
    {
        $this->BillingTotal = $billingTotal;
        return $this;
    }
    /**
     * Get PlanDifference value
     * @return float
     */
    public function getPlanDifference()
    {
        return $this->PlanDifference;
    }
    /**
     * Set PlanDifference value
     * @param float $planDifference
     * @return \SGCIS\Struct\BillLevelizedBillSummary
     */
    public function setPlanDifference($planDifference = null)
    {
        $this->PlanDifference = $planDifference;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\BillLevelizedBillSummary
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillLevelizedBillSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
