<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillHeader Struct
 * @subpackage Structs
 */
class BillHeader extends AbstractStructBase
{
    /**
     * The BillHeaderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillHeaderID;
    /**
     * The MasterBillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MasterBillID;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The BillServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointID;
    /**
     * The BillDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BillDate;
    /**
     * The PeriodStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodStartDate;
    /**
     * The PeriodEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodEndDate;
    /**
     * The PreviousPeriodBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PreviousPeriodBalance;
    /**
     * The NewCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NewCharges;
    /**
     * The TotalPaymentsAdjustments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPaymentsAdjustments;
    /**
     * The TotalAmountDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalAmountDue;
    /**
     * The AmountAfterDueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountAfterDueDate;
    /**
     * The PaymentDueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentDueDate;
    /**
     * The LevelizedBillAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LevelizedBillAmount;
    /**
     * The LevelizedBillDifference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LevelizedBillDifference;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The IsFinalBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFinalBill;
    /**
     * The DeferredBudgetBillBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DeferredBudgetBillBalance;
    /**
     * The BalanceForward
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BalanceForward;
    /**
     * The TotalkWh
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalkWh;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The BillNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillNumber;
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The PrimaryPersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryPersonName;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The AddressCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressCity;
    /**
     * The AddressState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressState;
    /**
     * The AddressZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressZipCode;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The BillCondition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillCondition;
    /**
     * The ScanLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScanLine;
    /**
     * Constructor method for BillHeader
     * @uses BillHeader::setBillHeaderID()
     * @uses BillHeader::setMasterBillID()
     * @uses BillHeader::setBillID()
     * @uses BillHeader::setBillServicePointID()
     * @uses BillHeader::setBillDate()
     * @uses BillHeader::setPeriodStartDate()
     * @uses BillHeader::setPeriodEndDate()
     * @uses BillHeader::setPreviousPeriodBalance()
     * @uses BillHeader::setNewCharges()
     * @uses BillHeader::setTotalPaymentsAdjustments()
     * @uses BillHeader::setTotalAmountDue()
     * @uses BillHeader::setAmountAfterDueDate()
     * @uses BillHeader::setPaymentDueDate()
     * @uses BillHeader::setLevelizedBillAmount()
     * @uses BillHeader::setLevelizedBillDifference()
     * @uses BillHeader::setCreateDate()
     * @uses BillHeader::setIsFinalBill()
     * @uses BillHeader::setDeferredBudgetBillBalance()
     * @uses BillHeader::setBalanceForward()
     * @uses BillHeader::setTotalkWh()
     * @uses BillHeader::setAccountNumber()
     * @uses BillHeader::setBillNumber()
     * @uses BillHeader::setCompanyName()
     * @uses BillHeader::setPrimaryPersonName()
     * @uses BillHeader::setAddress1()
     * @uses BillHeader::setAddress2()
     * @uses BillHeader::setAddressCity()
     * @uses BillHeader::setAddressState()
     * @uses BillHeader::setAddressZipCode()
     * @uses BillHeader::setEmailAddress()
     * @uses BillHeader::setBillCondition()
     * @uses BillHeader::setScanLine()
     * @param int $billHeaderID
     * @param int $masterBillID
     * @param int $billID
     * @param int $billServicePointID
     * @param string $billDate
     * @param string $periodStartDate
     * @param string $periodEndDate
     * @param float $previousPeriodBalance
     * @param float $newCharges
     * @param float $totalPaymentsAdjustments
     * @param float $totalAmountDue
     * @param float $amountAfterDueDate
     * @param string $paymentDueDate
     * @param float $levelizedBillAmount
     * @param float $levelizedBillDifference
     * @param string $createDate
     * @param bool $isFinalBill
     * @param float $deferredBudgetBillBalance
     * @param float $balanceForward
     * @param float $totalkWh
     * @param string $accountNumber
     * @param string $billNumber
     * @param string $companyName
     * @param string $primaryPersonName
     * @param string $address1
     * @param string $address2
     * @param string $addressCity
     * @param string $addressState
     * @param string $addressZipCode
     * @param string $emailAddress
     * @param string $billCondition
     * @param string $scanLine
     */
    public function __construct($billHeaderID = null, $masterBillID = null, $billID = null, $billServicePointID = null, $billDate = null, $periodStartDate = null, $periodEndDate = null, $previousPeriodBalance = null, $newCharges = null, $totalPaymentsAdjustments = null, $totalAmountDue = null, $amountAfterDueDate = null, $paymentDueDate = null, $levelizedBillAmount = null, $levelizedBillDifference = null, $createDate = null, $isFinalBill = null, $deferredBudgetBillBalance = null, $balanceForward = null, $totalkWh = null, $accountNumber = null, $billNumber = null, $companyName = null, $primaryPersonName = null, $address1 = null, $address2 = null, $addressCity = null, $addressState = null, $addressZipCode = null, $emailAddress = null, $billCondition = null, $scanLine = null)
    {
        $this
            ->setBillHeaderID($billHeaderID)
            ->setMasterBillID($masterBillID)
            ->setBillID($billID)
            ->setBillServicePointID($billServicePointID)
            ->setBillDate($billDate)
            ->setPeriodStartDate($periodStartDate)
            ->setPeriodEndDate($periodEndDate)
            ->setPreviousPeriodBalance($previousPeriodBalance)
            ->setNewCharges($newCharges)
            ->setTotalPaymentsAdjustments($totalPaymentsAdjustments)
            ->setTotalAmountDue($totalAmountDue)
            ->setAmountAfterDueDate($amountAfterDueDate)
            ->setPaymentDueDate($paymentDueDate)
            ->setLevelizedBillAmount($levelizedBillAmount)
            ->setLevelizedBillDifference($levelizedBillDifference)
            ->setCreateDate($createDate)
            ->setIsFinalBill($isFinalBill)
            ->setDeferredBudgetBillBalance($deferredBudgetBillBalance)
            ->setBalanceForward($balanceForward)
            ->setTotalkWh($totalkWh)
            ->setAccountNumber($accountNumber)
            ->setBillNumber($billNumber)
            ->setCompanyName($companyName)
            ->setPrimaryPersonName($primaryPersonName)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddressCity($addressCity)
            ->setAddressState($addressState)
            ->setAddressZipCode($addressZipCode)
            ->setEmailAddress($emailAddress)
            ->setBillCondition($billCondition)
            ->setScanLine($scanLine);
    }
    /**
     * Get BillHeaderID value
     * @return int
     */
    public function getBillHeaderID()
    {
        return $this->BillHeaderID;
    }
    /**
     * Set BillHeaderID value
     * @param int $billHeaderID
     * @return \SGCIS\Struct\BillHeader
     */
    public function setBillHeaderID($billHeaderID = null)
    {
        // validation for constraint: int
        if (!is_null($billHeaderID) && !is_numeric($billHeaderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billHeaderID)), __LINE__);
        }
        $this->BillHeaderID = $billHeaderID;
        return $this;
    }
    /**
     * Get MasterBillID value
     * @return int
     */
    public function getMasterBillID()
    {
        return $this->MasterBillID;
    }
    /**
     * Set MasterBillID value
     * @param int $masterBillID
     * @return \SGCIS\Struct\BillHeader
     */
    public function setMasterBillID($masterBillID = null)
    {
        // validation for constraint: int
        if (!is_null($masterBillID) && !is_numeric($masterBillID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($masterBillID)), __LINE__);
        }
        $this->MasterBillID = $masterBillID;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\BillHeader
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get BillServicePointID value
     * @return int
     */
    public function getBillServicePointID()
    {
        return $this->BillServicePointID;
    }
    /**
     * Set BillServicePointID value
     * @param int $billServicePointID
     * @return \SGCIS\Struct\BillHeader
     */
    public function setBillServicePointID($billServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointID) && !is_numeric($billServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointID)), __LINE__);
        }
        $this->BillServicePointID = $billServicePointID;
        return $this;
    }
    /**
     * Get BillDate value
     * @return string
     */
    public function getBillDate()
    {
        return $this->BillDate;
    }
    /**
     * Set BillDate value
     * @param string $billDate
     * @return \SGCIS\Struct\BillHeader
     */
    public function setBillDate($billDate = null)
    {
        // validation for constraint: string
        if (!is_null($billDate) && !is_string($billDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDate)), __LINE__);
        }
        $this->BillDate = $billDate;
        return $this;
    }
    /**
     * Get PeriodStartDate value
     * @return string
     */
    public function getPeriodStartDate()
    {
        return $this->PeriodStartDate;
    }
    /**
     * Set PeriodStartDate value
     * @param string $periodStartDate
     * @return \SGCIS\Struct\BillHeader
     */
    public function setPeriodStartDate($periodStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodStartDate) && !is_string($periodStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodStartDate)), __LINE__);
        }
        $this->PeriodStartDate = $periodStartDate;
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * @return string
     */
    public function getPeriodEndDate()
    {
        return $this->PeriodEndDate;
    }
    /**
     * Set PeriodEndDate value
     * @param string $periodEndDate
     * @return \SGCIS\Struct\BillHeader
     */
    public function setPeriodEndDate($periodEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodEndDate) && !is_string($periodEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodEndDate)), __LINE__);
        }
        $this->PeriodEndDate = $periodEndDate;
        return $this;
    }
    /**
     * Get PreviousPeriodBalance value
     * @return float
     */
    public function getPreviousPeriodBalance()
    {
        return $this->PreviousPeriodBalance;
    }
    /**
     * Set PreviousPeriodBalance value
     * @param float $previousPeriodBalance
     * @return \SGCIS\Struct\BillHeader
     */
    public function setPreviousPeriodBalance($previousPeriodBalance = null)
    {
        $this->PreviousPeriodBalance = $previousPeriodBalance;
        return $this;
    }
    /**
     * Get NewCharges value
     * @return float
     */
    public function getNewCharges()
    {
        return $this->NewCharges;
    }
    /**
     * Set NewCharges value
     * @param float $newCharges
     * @return \SGCIS\Struct\BillHeader
     */
    public function setNewCharges($newCharges = null)
    {
        $this->NewCharges = $newCharges;
        return $this;
    }
    /**
     * Get TotalPaymentsAdjustments value
     * @return float
     */
    public function getTotalPaymentsAdjustments()
    {
        return $this->TotalPaymentsAdjustments;
    }
    /**
     * Set TotalPaymentsAdjustments value
     * @param float $totalPaymentsAdjustments
     * @return \SGCIS\Struct\BillHeader
     */
    public function setTotalPaymentsAdjustments($totalPaymentsAdjustments = null)
    {
        $this->TotalPaymentsAdjustments = $totalPaymentsAdjustments;
        return $this;
    }
    /**
     * Get TotalAmountDue value
     * @return float
     */
    public function getTotalAmountDue()
    {
        return $this->TotalAmountDue;
    }
    /**
     * Set TotalAmountDue value
     * @param float $totalAmountDue
     * @return \SGCIS\Struct\BillHeader
     */
    public function setTotalAmountDue($totalAmountDue = null)
    {
        $this->TotalAmountDue = $totalAmountDue;
        return $this;
    }
    /**
     * Get AmountAfterDueDate value
     * @return float
     */
    public function getAmountAfterDueDate()
    {
        return $this->AmountAfterDueDate;
    }
    /**
     * Set AmountAfterDueDate value
     * @param float $amountAfterDueDate
     * @return \SGCIS\Struct\BillHeader
     */
    public function setAmountAfterDueDate($amountAfterDueDate = null)
    {
        $this->AmountAfterDueDate = $amountAfterDueDate;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return string
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param string $paymentDueDate
     * @return \SGCIS\Struct\BillHeader
     */
    public function setPaymentDueDate($paymentDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDueDate) && !is_string($paymentDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDueDate)), __LINE__);
        }
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get LevelizedBillAmount value
     * @return float
     */
    public function getLevelizedBillAmount()
    {
        return $this->LevelizedBillAmount;
    }
    /**
     * Set LevelizedBillAmount value
     * @param float $levelizedBillAmount
     * @return \SGCIS\Struct\BillHeader
     */
    public function setLevelizedBillAmount($levelizedBillAmount = null)
    {
        $this->LevelizedBillAmount = $levelizedBillAmount;
        return $this;
    }
    /**
     * Get LevelizedBillDifference value
     * @return float
     */
    public function getLevelizedBillDifference()
    {
        return $this->LevelizedBillDifference;
    }
    /**
     * Set LevelizedBillDifference value
     * @param float $levelizedBillDifference
     * @return \SGCIS\Struct\BillHeader
     */
    public function setLevelizedBillDifference($levelizedBillDifference = null)
    {
        $this->LevelizedBillDifference = $levelizedBillDifference;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\BillHeader
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get IsFinalBill value
     * @return bool
     */
    public function getIsFinalBill()
    {
        return $this->IsFinalBill;
    }
    /**
     * Set IsFinalBill value
     * @param bool $isFinalBill
     * @return \SGCIS\Struct\BillHeader
     */
    public function setIsFinalBill($isFinalBill = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFinalBill) && !is_bool($isFinalBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isFinalBill)), __LINE__);
        }
        $this->IsFinalBill = $isFinalBill;
        return $this;
    }
    /**
     * Get DeferredBudgetBillBalance value
     * @return float
     */
    public function getDeferredBudgetBillBalance()
    {
        return $this->DeferredBudgetBillBalance;
    }
    /**
     * Set DeferredBudgetBillBalance value
     * @param float $deferredBudgetBillBalance
     * @return \SGCIS\Struct\BillHeader
     */
    public function setDeferredBudgetBillBalance($deferredBudgetBillBalance = null)
    {
        $this->DeferredBudgetBillBalance = $deferredBudgetBillBalance;
        return $this;
    }
    /**
     * Get BalanceForward value
     * @return float
     */
    public function getBalanceForward()
    {
        return $this->BalanceForward;
    }
    /**
     * Set BalanceForward value
     * @param float $balanceForward
     * @return \SGCIS\Struct\BillHeader
     */
    public function setBalanceForward($balanceForward = null)
    {
        $this->BalanceForward = $balanceForward;
        return $this;
    }
    /**
     * Get TotalkWh value
     * @return float
     */
    public function getTotalkWh()
    {
        return $this->TotalkWh;
    }
    /**
     * Set TotalkWh value
     * @param float $totalkWh
     * @return \SGCIS\Struct\BillHeader
     */
    public function setTotalkWh($totalkWh = null)
    {
        $this->TotalkWh = $totalkWh;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\BillHeader
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get BillNumber value
     * @return string|null
     */
    public function getBillNumber()
    {
        return $this->BillNumber;
    }
    /**
     * Set BillNumber value
     * @param string $billNumber
     * @return \SGCIS\Struct\BillHeader
     */
    public function setBillNumber($billNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billNumber) && !is_string($billNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billNumber)), __LINE__);
        }
        $this->BillNumber = $billNumber;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \SGCIS\Struct\BillHeader
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get PrimaryPersonName value
     * @return string|null
     */
    public function getPrimaryPersonName()
    {
        return $this->PrimaryPersonName;
    }
    /**
     * Set PrimaryPersonName value
     * @param string $primaryPersonName
     * @return \SGCIS\Struct\BillHeader
     */
    public function setPrimaryPersonName($primaryPersonName = null)
    {
        // validation for constraint: string
        if (!is_null($primaryPersonName) && !is_string($primaryPersonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryPersonName)), __LINE__);
        }
        $this->PrimaryPersonName = $primaryPersonName;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \SGCIS\Struct\BillHeader
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \SGCIS\Struct\BillHeader
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get AddressCity value
     * @return string|null
     */
    public function getAddressCity()
    {
        return $this->AddressCity;
    }
    /**
     * Set AddressCity value
     * @param string $addressCity
     * @return \SGCIS\Struct\BillHeader
     */
    public function setAddressCity($addressCity = null)
    {
        // validation for constraint: string
        if (!is_null($addressCity) && !is_string($addressCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressCity)), __LINE__);
        }
        $this->AddressCity = $addressCity;
        return $this;
    }
    /**
     * Get AddressState value
     * @return string|null
     */
    public function getAddressState()
    {
        return $this->AddressState;
    }
    /**
     * Set AddressState value
     * @param string $addressState
     * @return \SGCIS\Struct\BillHeader
     */
    public function setAddressState($addressState = null)
    {
        // validation for constraint: string
        if (!is_null($addressState) && !is_string($addressState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressState)), __LINE__);
        }
        $this->AddressState = $addressState;
        return $this;
    }
    /**
     * Get AddressZipCode value
     * @return string|null
     */
    public function getAddressZipCode()
    {
        return $this->AddressZipCode;
    }
    /**
     * Set AddressZipCode value
     * @param string $addressZipCode
     * @return \SGCIS\Struct\BillHeader
     */
    public function setAddressZipCode($addressZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressZipCode) && !is_string($addressZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressZipCode)), __LINE__);
        }
        $this->AddressZipCode = $addressZipCode;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \SGCIS\Struct\BillHeader
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get BillCondition value
     * @return string|null
     */
    public function getBillCondition()
    {
        return $this->BillCondition;
    }
    /**
     * Set BillCondition value
     * @param string $billCondition
     * @return \SGCIS\Struct\BillHeader
     */
    public function setBillCondition($billCondition = null)
    {
        // validation for constraint: string
        if (!is_null($billCondition) && !is_string($billCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billCondition)), __LINE__);
        }
        $this->BillCondition = $billCondition;
        return $this;
    }
    /**
     * Get ScanLine value
     * @return string|null
     */
    public function getScanLine()
    {
        return $this->ScanLine;
    }
    /**
     * Set ScanLine value
     * @param string $scanLine
     * @return \SGCIS\Struct\BillHeader
     */
    public function setScanLine($scanLine = null)
    {
        // validation for constraint: string
        if (!is_null($scanLine) && !is_string($scanLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scanLine)), __LINE__);
        }
        $this->ScanLine = $scanLine;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
