<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillBalance Struct
 * @subpackage Structs
 */
class BillBalance extends AbstractStructBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The BillDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BillDate;
    /**
     * The DueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DueDate;
    /**
     * The TotalConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalConsumption;
    /**
     * The TotalBilledAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalBilledAmount;
    /**
     * The CurrentBalanceOwed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurrentBalanceOwed;
    /**
     * The ApplyToDebtAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ApplyToDebtAmount;
    /**
     * The UtilityServiceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UtilityServiceType;
    /**
     * The BillNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillNumber;
    /**
     * Constructor method for BillBalance
     * @uses BillBalance::setAccountID()
     * @uses BillBalance::setBillID()
     * @uses BillBalance::setBillDate()
     * @uses BillBalance::setDueDate()
     * @uses BillBalance::setTotalConsumption()
     * @uses BillBalance::setTotalBilledAmount()
     * @uses BillBalance::setCurrentBalanceOwed()
     * @uses BillBalance::setApplyToDebtAmount()
     * @uses BillBalance::setUtilityServiceType()
     * @uses BillBalance::setBillNumber()
     * @param int $accountID
     * @param int $billID
     * @param string $billDate
     * @param string $dueDate
     * @param float $totalConsumption
     * @param float $totalBilledAmount
     * @param float $currentBalanceOwed
     * @param float $applyToDebtAmount
     * @param int $utilityServiceType
     * @param string $billNumber
     */
    public function __construct($accountID = null, $billID = null, $billDate = null, $dueDate = null, $totalConsumption = null, $totalBilledAmount = null, $currentBalanceOwed = null, $applyToDebtAmount = null, $utilityServiceType = null, $billNumber = null)
    {
        $this
            ->setAccountID($accountID)
            ->setBillID($billID)
            ->setBillDate($billDate)
            ->setDueDate($dueDate)
            ->setTotalConsumption($totalConsumption)
            ->setTotalBilledAmount($totalBilledAmount)
            ->setCurrentBalanceOwed($currentBalanceOwed)
            ->setApplyToDebtAmount($applyToDebtAmount)
            ->setUtilityServiceType($utilityServiceType)
            ->setBillNumber($billNumber);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\BillBalance
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\BillBalance
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get BillDate value
     * @return string
     */
    public function getBillDate()
    {
        return $this->BillDate;
    }
    /**
     * Set BillDate value
     * @param string $billDate
     * @return \SGCIS\Struct\BillBalance
     */
    public function setBillDate($billDate = null)
    {
        // validation for constraint: string
        if (!is_null($billDate) && !is_string($billDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDate)), __LINE__);
        }
        $this->BillDate = $billDate;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \SGCIS\Struct\BillBalance
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get TotalConsumption value
     * @return float
     */
    public function getTotalConsumption()
    {
        return $this->TotalConsumption;
    }
    /**
     * Set TotalConsumption value
     * @param float $totalConsumption
     * @return \SGCIS\Struct\BillBalance
     */
    public function setTotalConsumption($totalConsumption = null)
    {
        $this->TotalConsumption = $totalConsumption;
        return $this;
    }
    /**
     * Get TotalBilledAmount value
     * @return float
     */
    public function getTotalBilledAmount()
    {
        return $this->TotalBilledAmount;
    }
    /**
     * Set TotalBilledAmount value
     * @param float $totalBilledAmount
     * @return \SGCIS\Struct\BillBalance
     */
    public function setTotalBilledAmount($totalBilledAmount = null)
    {
        $this->TotalBilledAmount = $totalBilledAmount;
        return $this;
    }
    /**
     * Get CurrentBalanceOwed value
     * @return float
     */
    public function getCurrentBalanceOwed()
    {
        return $this->CurrentBalanceOwed;
    }
    /**
     * Set CurrentBalanceOwed value
     * @param float $currentBalanceOwed
     * @return \SGCIS\Struct\BillBalance
     */
    public function setCurrentBalanceOwed($currentBalanceOwed = null)
    {
        $this->CurrentBalanceOwed = $currentBalanceOwed;
        return $this;
    }
    /**
     * Get ApplyToDebtAmount value
     * @return float
     */
    public function getApplyToDebtAmount()
    {
        return $this->ApplyToDebtAmount;
    }
    /**
     * Set ApplyToDebtAmount value
     * @param float $applyToDebtAmount
     * @return \SGCIS\Struct\BillBalance
     */
    public function setApplyToDebtAmount($applyToDebtAmount = null)
    {
        $this->ApplyToDebtAmount = $applyToDebtAmount;
        return $this;
    }
    /**
     * Get UtilityServiceType value
     * @return int
     */
    public function getUtilityServiceType()
    {
        return $this->UtilityServiceType;
    }
    /**
     * Set UtilityServiceType value
     * @param int $utilityServiceType
     * @return \SGCIS\Struct\BillBalance
     */
    public function setUtilityServiceType($utilityServiceType = null)
    {
        // validation for constraint: int
        if (!is_null($utilityServiceType) && !is_numeric($utilityServiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($utilityServiceType)), __LINE__);
        }
        $this->UtilityServiceType = $utilityServiceType;
        return $this;
    }
    /**
     * Get BillNumber value
     * @return string|null
     */
    public function getBillNumber()
    {
        return $this->BillNumber;
    }
    /**
     * Set BillNumber value
     * @param string $billNumber
     * @return \SGCIS\Struct\BillBalance
     */
    public function setBillNumber($billNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billNumber) && !is_string($billNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billNumber)), __LINE__);
        }
        $this->BillNumber = $billNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillBalance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
