<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoPaymentResponse Struct
 * @subpackage Structs
 */
class AutoPaymentResponse extends ServiceResponseBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AutoPay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountAutoPay
     */
    public $AutoPay;
    /**
     * The AutoPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountAutoPay
     */
    public $AutoPayments;
    /**
     * Constructor method for AutoPaymentResponse
     * @uses AutoPaymentResponse::setAccountID()
     * @uses AutoPaymentResponse::setAutoPay()
     * @uses AutoPaymentResponse::setAutoPayments()
     * @param int $accountID
     * @param \SGCIS\Struct\AccountAutoPay $autoPay
     * @param \SGCIS\Array\ArrayOfAccountAutoPay $autoPayments
     */
    public function __construct($accountID = null, \SGCIS\Struct\AccountAutoPay $autoPay = null, \SGCIS\Array\ArrayOfAccountAutoPay $autoPayments = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAutoPay($autoPay)
            ->setAutoPayments($autoPayments);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AutoPaymentResponse
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AutoPay value
     * @return \SGCIS\Struct\AccountAutoPay|null
     */
    public function getAutoPay()
    {
        return $this->AutoPay;
    }
    /**
     * Set AutoPay value
     * @param \SGCIS\Struct\AccountAutoPay $autoPay
     * @return \SGCIS\Struct\AutoPaymentResponse
     */
    public function setAutoPay(\SGCIS\Struct\AccountAutoPay $autoPay = null)
    {
        $this->AutoPay = $autoPay;
        return $this;
    }
    /**
     * Get AutoPayments value
     * @return \SGCIS\Array\ArrayOfAccountAutoPay|null
     */
    public function getAutoPayments()
    {
        return $this->AutoPayments;
    }
    /**
     * Set AutoPayments value
     * @param \SGCIS\Array\ArrayOfAccountAutoPay $autoPayments
     * @return \SGCIS\Struct\AutoPaymentResponse
     */
    public function setAutoPayments(\SGCIS\Array\ArrayOfAccountAutoPay $autoPayments = null)
    {
        $this->AutoPayments = $autoPayments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AutoPaymentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
