<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticationHeader Struct
 * @subpackage Structs
 */
class AuthenticationHeader extends AbstractStructBase
{
    /**
     * The InterfaceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InterfaceID;
    /**
     * The SystemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemID;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for AuthenticationHeader
     * @uses AuthenticationHeader::setInterfaceID()
     * @uses AuthenticationHeader::setSystemID()
     * @uses AuthenticationHeader::setUserName()
     * @uses AuthenticationHeader::setPassword()
     * @param int $interfaceID
     * @param string $systemID
     * @param string $userName
     * @param string $password
     */
    public function __construct($interfaceID = null, $systemID = null, $userName = null, $password = null)
    {
        $this
            ->setInterfaceID($interfaceID)
            ->setSystemID($systemID)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get InterfaceID value
     * @return int
     */
    public function getInterfaceID()
    {
        return $this->InterfaceID;
    }
    /**
     * Set InterfaceID value
     * @param int $interfaceID
     * @return \SGCIS\Struct\AuthenticationHeader
     */
    public function setInterfaceID($interfaceID = null)
    {
        // validation for constraint: int
        if (!is_null($interfaceID) && !is_numeric($interfaceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($interfaceID)), __LINE__);
        }
        $this->InterfaceID = $interfaceID;
        return $this;
    }
    /**
     * Get SystemID value
     * @return string|null
     */
    public function getSystemID()
    {
        return $this->SystemID;
    }
    /**
     * Set SystemID value
     * @param string $systemID
     * @return \SGCIS\Struct\AuthenticationHeader
     */
    public function setSystemID($systemID = null)
    {
        // validation for constraint: string
        if (!is_null($systemID) && !is_string($systemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemID)), __LINE__);
        }
        $this->SystemID = $systemID;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\AuthenticationHeader
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \SGCIS\Struct\AuthenticationHeader
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AuthenticationHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
