<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticateAppUserResponse Struct
 * @subpackage Structs
 */
class AuthenticateAppUserResponse extends ServiceResponseBase
{
    /**
     * The IsAuthenticated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAuthenticated;
    /**
     * The IsPasswordChangeRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPasswordChangeRequired;
    /**
     * The IsAccountLocked
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAccountLocked;
    /**
     * The AutheticationErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfString
     */
    public $AutheticationErrors;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\User
     */
    public $User;
    /**
     * Constructor method for AuthenticateAppUserResponse
     * @uses AuthenticateAppUserResponse::setIsAuthenticated()
     * @uses AuthenticateAppUserResponse::setIsPasswordChangeRequired()
     * @uses AuthenticateAppUserResponse::setIsAccountLocked()
     * @uses AuthenticateAppUserResponse::setAutheticationErrors()
     * @uses AuthenticateAppUserResponse::setUser()
     * @param bool $isAuthenticated
     * @param bool $isPasswordChangeRequired
     * @param bool $isAccountLocked
     * @param \SGCIS\Array\ArrayOfString $autheticationErrors
     * @param \SGCIS\Struct\User $user
     */
    public function __construct($isAuthenticated = null, $isPasswordChangeRequired = null, $isAccountLocked = null, \SGCIS\Array\ArrayOfString $autheticationErrors = null, \SGCIS\Struct\User $user = null)
    {
        $this
            ->setIsAuthenticated($isAuthenticated)
            ->setIsPasswordChangeRequired($isPasswordChangeRequired)
            ->setIsAccountLocked($isAccountLocked)
            ->setAutheticationErrors($autheticationErrors)
            ->setUser($user);
    }
    /**
     * Get IsAuthenticated value
     * @return bool
     */
    public function getIsAuthenticated()
    {
        return $this->IsAuthenticated;
    }
    /**
     * Set IsAuthenticated value
     * @param bool $isAuthenticated
     * @return \SGCIS\Struct\AuthenticateAppUserResponse
     */
    public function setIsAuthenticated($isAuthenticated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAuthenticated) && !is_bool($isAuthenticated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAuthenticated)), __LINE__);
        }
        $this->IsAuthenticated = $isAuthenticated;
        return $this;
    }
    /**
     * Get IsPasswordChangeRequired value
     * @return bool
     */
    public function getIsPasswordChangeRequired()
    {
        return $this->IsPasswordChangeRequired;
    }
    /**
     * Set IsPasswordChangeRequired value
     * @param bool $isPasswordChangeRequired
     * @return \SGCIS\Struct\AuthenticateAppUserResponse
     */
    public function setIsPasswordChangeRequired($isPasswordChangeRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPasswordChangeRequired) && !is_bool($isPasswordChangeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPasswordChangeRequired)), __LINE__);
        }
        $this->IsPasswordChangeRequired = $isPasswordChangeRequired;
        return $this;
    }
    /**
     * Get IsAccountLocked value
     * @return bool
     */
    public function getIsAccountLocked()
    {
        return $this->IsAccountLocked;
    }
    /**
     * Set IsAccountLocked value
     * @param bool $isAccountLocked
     * @return \SGCIS\Struct\AuthenticateAppUserResponse
     */
    public function setIsAccountLocked($isAccountLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccountLocked) && !is_bool($isAccountLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAccountLocked)), __LINE__);
        }
        $this->IsAccountLocked = $isAccountLocked;
        return $this;
    }
    /**
     * Get AutheticationErrors value
     * @return \SGCIS\Array\ArrayOfString|null
     */
    public function getAutheticationErrors()
    {
        return $this->AutheticationErrors;
    }
    /**
     * Set AutheticationErrors value
     * @param \SGCIS\Array\ArrayOfString $autheticationErrors
     * @return \SGCIS\Struct\AuthenticateAppUserResponse
     */
    public function setAutheticationErrors(\SGCIS\Array\ArrayOfString $autheticationErrors = null)
    {
        $this->AutheticationErrors = $autheticationErrors;
        return $this;
    }
    /**
     * Get User value
     * @return \SGCIS\Struct\User|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \SGCIS\Struct\User $user
     * @return \SGCIS\Struct\AuthenticateAppUserResponse
     */
    public function setUser(\SGCIS\Struct\User $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AuthenticateAppUserResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
