<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachedFile Struct
 * @subpackage Structs
 */
class AttachedFile extends AbstractStructBase
{
    /**
     * The ContentLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContentLength;
    /**
     * The ContentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentType;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The InputStream
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Stream
     */
    public $InputStream;
    /**
     * The bAttachedFile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bAttachedFile;
    /**
     * Constructor method for AttachedFile
     * @uses AttachedFile::setContentLength()
     * @uses AttachedFile::setContentType()
     * @uses AttachedFile::setFileName()
     * @uses AttachedFile::setInputStream()
     * @uses AttachedFile::setBAttachedFile()
     * @param int $contentLength
     * @param string $contentType
     * @param string $fileName
     * @param \SGCIS\Struct\Stream $inputStream
     * @param string $bAttachedFile
     */
    public function __construct($contentLength = null, $contentType = null, $fileName = null, \SGCIS\Struct\Stream $inputStream = null, $bAttachedFile = null)
    {
        $this
            ->setContentLength($contentLength)
            ->setContentType($contentType)
            ->setFileName($fileName)
            ->setInputStream($inputStream)
            ->setBAttachedFile($bAttachedFile);
    }
    /**
     * Get ContentLength value
     * @return int
     */
    public function getContentLength()
    {
        return $this->ContentLength;
    }
    /**
     * Set ContentLength value
     * @param int $contentLength
     * @return \SGCIS\Struct\AttachedFile
     */
    public function setContentLength($contentLength = null)
    {
        // validation for constraint: int
        if (!is_null($contentLength) && !is_numeric($contentLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contentLength)), __LINE__);
        }
        $this->ContentLength = $contentLength;
        return $this;
    }
    /**
     * Get ContentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \SGCIS\Struct\AttachedFile
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \SGCIS\Struct\AttachedFile
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get InputStream value
     * @return \SGCIS\Struct\Stream|null
     */
    public function getInputStream()
    {
        return $this->InputStream;
    }
    /**
     * Set InputStream value
     * @param \SGCIS\Struct\Stream $inputStream
     * @return \SGCIS\Struct\AttachedFile
     */
    public function setInputStream(\SGCIS\Struct\Stream $inputStream = null)
    {
        $this->InputStream = $inputStream;
        return $this;
    }
    /**
     * Get bAttachedFile value
     * @return string|null
     */
    public function getBAttachedFile()
    {
        return $this->bAttachedFile;
    }
    /**
     * Set bAttachedFile value
     * @param string $bAttachedFile
     * @return \SGCIS\Struct\AttachedFile
     */
    public function setBAttachedFile($bAttachedFile = null)
    {
        // validation for constraint: string
        if (!is_null($bAttachedFile) && !is_string($bAttachedFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bAttachedFile)), __LINE__);
        }
        $this->bAttachedFile = $bAttachedFile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AttachedFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
