<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountTransactionSummary Struct
 * @subpackage Structs
 */
class AccountTransactionSummary extends AbstractStructBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The BeginningBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BeginningBalance;
    /**
     * The TotalOfCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalOfCharges;
    /**
     * The TotalOfPaymentPlans
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalOfPaymentPlans;
    /**
     * The TotalPaymentsCreditsAdjs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPaymentsCreditsAdjs;
    /**
     * The EndingBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EndingBalance;
    /**
     * The TotalkW
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalkW;
    /**
     * The AveragePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AveragePrice;
    /**
     * The FromDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FromDate;
    /**
     * The ToDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ToDate;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Account
     */
    public $Account;
    /**
     * The ActivityDetailItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfActivityDetailItem
     */
    public $ActivityDetailItems;
    /**
     * The ThisPeriodTransactions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountTransaction
     */
    public $ThisPeriodTransactions;
    /**
     * Constructor method for AccountTransactionSummary
     * @uses AccountTransactionSummary::setAccountID()
     * @uses AccountTransactionSummary::setBeginningBalance()
     * @uses AccountTransactionSummary::setTotalOfCharges()
     * @uses AccountTransactionSummary::setTotalOfPaymentPlans()
     * @uses AccountTransactionSummary::setTotalPaymentsCreditsAdjs()
     * @uses AccountTransactionSummary::setEndingBalance()
     * @uses AccountTransactionSummary::setTotalkW()
     * @uses AccountTransactionSummary::setAveragePrice()
     * @uses AccountTransactionSummary::setFromDate()
     * @uses AccountTransactionSummary::setToDate()
     * @uses AccountTransactionSummary::setAccount()
     * @uses AccountTransactionSummary::setActivityDetailItems()
     * @uses AccountTransactionSummary::setThisPeriodTransactions()
     * @param int $accountID
     * @param float $beginningBalance
     * @param float $totalOfCharges
     * @param float $totalOfPaymentPlans
     * @param float $totalPaymentsCreditsAdjs
     * @param float $endingBalance
     * @param float $totalkW
     * @param float $averagePrice
     * @param string $fromDate
     * @param string $toDate
     * @param \SGCIS\Struct\Account $account
     * @param \SGCIS\Array\ArrayOfActivityDetailItem $activityDetailItems
     * @param \SGCIS\Array\ArrayOfAccountTransaction $thisPeriodTransactions
     */
    public function __construct($accountID = null, $beginningBalance = null, $totalOfCharges = null, $totalOfPaymentPlans = null, $totalPaymentsCreditsAdjs = null, $endingBalance = null, $totalkW = null, $averagePrice = null, $fromDate = null, $toDate = null, \SGCIS\Struct\Account $account = null, \SGCIS\Array\ArrayOfActivityDetailItem $activityDetailItems = null, \SGCIS\Array\ArrayOfAccountTransaction $thisPeriodTransactions = null)
    {
        $this
            ->setAccountID($accountID)
            ->setBeginningBalance($beginningBalance)
            ->setTotalOfCharges($totalOfCharges)
            ->setTotalOfPaymentPlans($totalOfPaymentPlans)
            ->setTotalPaymentsCreditsAdjs($totalPaymentsCreditsAdjs)
            ->setEndingBalance($endingBalance)
            ->setTotalkW($totalkW)
            ->setAveragePrice($averagePrice)
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setAccount($account)
            ->setActivityDetailItems($activityDetailItems)
            ->setThisPeriodTransactions($thisPeriodTransactions);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get BeginningBalance value
     * @return float
     */
    public function getBeginningBalance()
    {
        return $this->BeginningBalance;
    }
    /**
     * Set BeginningBalance value
     * @param float $beginningBalance
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setBeginningBalance($beginningBalance = null)
    {
        $this->BeginningBalance = $beginningBalance;
        return $this;
    }
    /**
     * Get TotalOfCharges value
     * @return float
     */
    public function getTotalOfCharges()
    {
        return $this->TotalOfCharges;
    }
    /**
     * Set TotalOfCharges value
     * @param float $totalOfCharges
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setTotalOfCharges($totalOfCharges = null)
    {
        $this->TotalOfCharges = $totalOfCharges;
        return $this;
    }
    /**
     * Get TotalOfPaymentPlans value
     * @return float
     */
    public function getTotalOfPaymentPlans()
    {
        return $this->TotalOfPaymentPlans;
    }
    /**
     * Set TotalOfPaymentPlans value
     * @param float $totalOfPaymentPlans
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setTotalOfPaymentPlans($totalOfPaymentPlans = null)
    {
        $this->TotalOfPaymentPlans = $totalOfPaymentPlans;
        return $this;
    }
    /**
     * Get TotalPaymentsCreditsAdjs value
     * @return float
     */
    public function getTotalPaymentsCreditsAdjs()
    {
        return $this->TotalPaymentsCreditsAdjs;
    }
    /**
     * Set TotalPaymentsCreditsAdjs value
     * @param float $totalPaymentsCreditsAdjs
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setTotalPaymentsCreditsAdjs($totalPaymentsCreditsAdjs = null)
    {
        $this->TotalPaymentsCreditsAdjs = $totalPaymentsCreditsAdjs;
        return $this;
    }
    /**
     * Get EndingBalance value
     * @return float
     */
    public function getEndingBalance()
    {
        return $this->EndingBalance;
    }
    /**
     * Set EndingBalance value
     * @param float $endingBalance
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setEndingBalance($endingBalance = null)
    {
        $this->EndingBalance = $endingBalance;
        return $this;
    }
    /**
     * Get TotalkW value
     * @return float
     */
    public function getTotalkW()
    {
        return $this->TotalkW;
    }
    /**
     * Set TotalkW value
     * @param float $totalkW
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setTotalkW($totalkW = null)
    {
        $this->TotalkW = $totalkW;
        return $this;
    }
    /**
     * Get AveragePrice value
     * @return float
     */
    public function getAveragePrice()
    {
        return $this->AveragePrice;
    }
    /**
     * Set AveragePrice value
     * @param float $averagePrice
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setAveragePrice($averagePrice = null)
    {
        $this->AveragePrice = $averagePrice;
        return $this;
    }
    /**
     * Get FromDate value
     * @return string
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDate)), __LINE__);
        }
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDate)), __LINE__);
        }
        $this->ToDate = $toDate;
        return $this;
    }
    /**
     * Get Account value
     * @return \SGCIS\Struct\Account|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \SGCIS\Struct\Account $account
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setAccount(\SGCIS\Struct\Account $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get ActivityDetailItems value
     * @return \SGCIS\Array\ArrayOfActivityDetailItem|null
     */
    public function getActivityDetailItems()
    {
        return $this->ActivityDetailItems;
    }
    /**
     * Set ActivityDetailItems value
     * @param \SGCIS\Array\ArrayOfActivityDetailItem $activityDetailItems
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setActivityDetailItems(\SGCIS\Array\ArrayOfActivityDetailItem $activityDetailItems = null)
    {
        $this->ActivityDetailItems = $activityDetailItems;
        return $this;
    }
    /**
     * Get ThisPeriodTransactions value
     * @return \SGCIS\Array\ArrayOfAccountTransaction|null
     */
    public function getThisPeriodTransactions()
    {
        return $this->ThisPeriodTransactions;
    }
    /**
     * Set ThisPeriodTransactions value
     * @param \SGCIS\Array\ArrayOfAccountTransaction $thisPeriodTransactions
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public function setThisPeriodTransactions(\SGCIS\Array\ArrayOfAccountTransaction $thisPeriodTransactions = null)
    {
        $this->ThisPeriodTransactions = $thisPeriodTransactions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountTransactionSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
