<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountSummary Struct
 * @subpackage Structs
 */
class AccountSummary extends AbstractStructBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountStatusID;
    /**
     * The AccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeID;
    /**
     * The AccountStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountStartDate;
    /**
     * The AccountEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountEndDate;
    /**
     * The LanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LanguageID;
    /**
     * The NotificationChannelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NotificationChannelID;
    /**
     * The IsEnergyAssistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEnergyAssistance;
    /**
     * The IsMobilePaymentsEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMobilePaymentsEnabled;
    /**
     * The IsDebtManagementEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDebtManagementEnabled;
    /**
     * The IsWithinRecissionPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsWithinRecissionPeriod;
    /**
     * The IsMarketingOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMarketingOptIn;
    /**
     * The MinPaymentToReconnect
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MinPaymentToReconnect;
    /**
     * The IsSoftArmed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSoftArmed;
    /**
     * The ServicePointMeterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointMeterID;
    /**
     * The kWhRemaining
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $kWhRemaining;
    /**
     * The IsPaymentsEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPaymentsEnabled;
    /**
     * The ActivePaymentArrangement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ActivePaymentArrangement;
    /**
     * The NextPayArrangeDueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NextPayArrangeDueDate;
    /**
     * The LastPaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LastPaymentAmount;
    /**
     * The PaymentArrangementBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaymentArrangementBalance;
    /**
     * The AverageDailyUsage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AverageDailyUsage;
    /**
     * The AverageDailyKwh
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AverageDailyKwh;
    /**
     * The CurrentMonthKwh
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurrentMonthKwh;
    /**
     * The DaysRemaining
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DaysRemaining;
    /**
     * The HasBrandedCardAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasBrandedCardAccount;
    /**
     * The BrandedCardAccountBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BrandedCardAccountBalance;
    /**
     * The IsPowerOff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPowerOff;
    /**
     * The AccountBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AccountBalance;
    /**
     * The AvailableBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AvailableBalance;
    /**
     * The PastDueAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PastDueAmount;
    /**
     * The DisconnectThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DisconnectThreshold;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The AccountStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountStatusName;
    /**
     * The AccountTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountTypeName;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The NotificationChannelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotificationChannelName;
    /**
     * The EnergyAssistanceProgramNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnergyAssistanceProgramNames;
    /**
     * The DefaultState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultState;
    /**
     * The PortalMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PortalMessage;
    /**
     * The MeterStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterStatus;
    /**
     * The MailingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountAddress
     */
    public $MailingAddress;
    /**
     * The Person
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Person
     */
    public $Person;
    /**
     * The ServicePoints
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServicePoint
     */
    public $ServicePoints;
    /**
     * The ServiceAgreements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServiceAgreement
     */
    public $ServiceAgreements;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Product
     */
    public $Product;
    /**
     * The DailyBurnRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\DailyBurnRate
     */
    public $DailyBurnRate;
    /**
     * The BillHeaders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillHeader
     */
    public $BillHeaders;
    /**
     * The PaymentAccounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPaymentAccount
     */
    public $PaymentAccounts;
    /**
     * The BillDeliveryMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillDeliveryMethod
     */
    public $BillDeliveryMethod;
    /**
     * Constructor method for AccountSummary
     * @uses AccountSummary::setAccountID()
     * @uses AccountSummary::setAccountStatusID()
     * @uses AccountSummary::setAccountTypeID()
     * @uses AccountSummary::setAccountStartDate()
     * @uses AccountSummary::setAccountEndDate()
     * @uses AccountSummary::setLanguageID()
     * @uses AccountSummary::setNotificationChannelID()
     * @uses AccountSummary::setIsEnergyAssistance()
     * @uses AccountSummary::setIsMobilePaymentsEnabled()
     * @uses AccountSummary::setIsDebtManagementEnabled()
     * @uses AccountSummary::setIsWithinRecissionPeriod()
     * @uses AccountSummary::setIsMarketingOptIn()
     * @uses AccountSummary::setMinPaymentToReconnect()
     * @uses AccountSummary::setIsSoftArmed()
     * @uses AccountSummary::setServicePointMeterID()
     * @uses AccountSummary::setKWhRemaining()
     * @uses AccountSummary::setIsPaymentsEnabled()
     * @uses AccountSummary::setActivePaymentArrangement()
     * @uses AccountSummary::setNextPayArrangeDueDate()
     * @uses AccountSummary::setLastPaymentAmount()
     * @uses AccountSummary::setPaymentArrangementBalance()
     * @uses AccountSummary::setAverageDailyUsage()
     * @uses AccountSummary::setAverageDailyKwh()
     * @uses AccountSummary::setCurrentMonthKwh()
     * @uses AccountSummary::setDaysRemaining()
     * @uses AccountSummary::setHasBrandedCardAccount()
     * @uses AccountSummary::setBrandedCardAccountBalance()
     * @uses AccountSummary::setIsPowerOff()
     * @uses AccountSummary::setAccountBalance()
     * @uses AccountSummary::setAvailableBalance()
     * @uses AccountSummary::setPastDueAmount()
     * @uses AccountSummary::setDisconnectThreshold()
     * @uses AccountSummary::setAccountNumber()
     * @uses AccountSummary::setAccountStatusName()
     * @uses AccountSummary::setAccountTypeName()
     * @uses AccountSummary::setLanguage()
     * @uses AccountSummary::setNotificationChannelName()
     * @uses AccountSummary::setEnergyAssistanceProgramNames()
     * @uses AccountSummary::setDefaultState()
     * @uses AccountSummary::setPortalMessage()
     * @uses AccountSummary::setMeterStatus()
     * @uses AccountSummary::setMailingAddress()
     * @uses AccountSummary::setPerson()
     * @uses AccountSummary::setServicePoints()
     * @uses AccountSummary::setServiceAgreements()
     * @uses AccountSummary::setProduct()
     * @uses AccountSummary::setDailyBurnRate()
     * @uses AccountSummary::setBillHeaders()
     * @uses AccountSummary::setPaymentAccounts()
     * @uses AccountSummary::setBillDeliveryMethod()
     * @param int $accountID
     * @param int $accountStatusID
     * @param int $accountTypeID
     * @param string $accountStartDate
     * @param string $accountEndDate
     * @param int $languageID
     * @param int $notificationChannelID
     * @param bool $isEnergyAssistance
     * @param bool $isMobilePaymentsEnabled
     * @param bool $isDebtManagementEnabled
     * @param bool $isWithinRecissionPeriod
     * @param bool $isMarketingOptIn
     * @param float $minPaymentToReconnect
     * @param bool $isSoftArmed
     * @param int $servicePointMeterID
     * @param float $kWhRemaining
     * @param bool $isPaymentsEnabled
     * @param bool $activePaymentArrangement
     * @param string $nextPayArrangeDueDate
     * @param float $lastPaymentAmount
     * @param float $paymentArrangementBalance
     * @param float $averageDailyUsage
     * @param float $averageDailyKwh
     * @param float $currentMonthKwh
     * @param int $daysRemaining
     * @param bool $hasBrandedCardAccount
     * @param float $brandedCardAccountBalance
     * @param bool $isPowerOff
     * @param float $accountBalance
     * @param float $availableBalance
     * @param float $pastDueAmount
     * @param float $disconnectThreshold
     * @param string $accountNumber
     * @param string $accountStatusName
     * @param string $accountTypeName
     * @param string $language
     * @param string $notificationChannelName
     * @param string $energyAssistanceProgramNames
     * @param string $defaultState
     * @param string $portalMessage
     * @param string $meterStatus
     * @param \SGCIS\Struct\AccountAddress $mailingAddress
     * @param \SGCIS\Struct\Person $person
     * @param \SGCIS\Array\ArrayOfServicePoint $servicePoints
     * @param \SGCIS\Array\ArrayOfServiceAgreement $serviceAgreements
     * @param \SGCIS\Struct\Product $product
     * @param \SGCIS\Struct\DailyBurnRate $dailyBurnRate
     * @param \SGCIS\Array\ArrayOfBillHeader $billHeaders
     * @param \SGCIS\Array\ArrayOfPaymentAccount $paymentAccounts
     * @param \SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethod
     */
    public function __construct($accountID = null, $accountStatusID = null, $accountTypeID = null, $accountStartDate = null, $accountEndDate = null, $languageID = null, $notificationChannelID = null, $isEnergyAssistance = null, $isMobilePaymentsEnabled = null, $isDebtManagementEnabled = null, $isWithinRecissionPeriod = null, $isMarketingOptIn = null, $minPaymentToReconnect = null, $isSoftArmed = null, $servicePointMeterID = null, $kWhRemaining = null, $isPaymentsEnabled = null, $activePaymentArrangement = null, $nextPayArrangeDueDate = null, $lastPaymentAmount = null, $paymentArrangementBalance = null, $averageDailyUsage = null, $averageDailyKwh = null, $currentMonthKwh = null, $daysRemaining = null, $hasBrandedCardAccount = null, $brandedCardAccountBalance = null, $isPowerOff = null, $accountBalance = null, $availableBalance = null, $pastDueAmount = null, $disconnectThreshold = null, $accountNumber = null, $accountStatusName = null, $accountTypeName = null, $language = null, $notificationChannelName = null, $energyAssistanceProgramNames = null, $defaultState = null, $portalMessage = null, $meterStatus = null, \SGCIS\Struct\AccountAddress $mailingAddress = null, \SGCIS\Struct\Person $person = null, \SGCIS\Array\ArrayOfServicePoint $servicePoints = null, \SGCIS\Array\ArrayOfServiceAgreement $serviceAgreements = null, \SGCIS\Struct\Product $product = null, \SGCIS\Struct\DailyBurnRate $dailyBurnRate = null, \SGCIS\Array\ArrayOfBillHeader $billHeaders = null, \SGCIS\Array\ArrayOfPaymentAccount $paymentAccounts = null, \SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethod = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAccountStatusID($accountStatusID)
            ->setAccountTypeID($accountTypeID)
            ->setAccountStartDate($accountStartDate)
            ->setAccountEndDate($accountEndDate)
            ->setLanguageID($languageID)
            ->setNotificationChannelID($notificationChannelID)
            ->setIsEnergyAssistance($isEnergyAssistance)
            ->setIsMobilePaymentsEnabled($isMobilePaymentsEnabled)
            ->setIsDebtManagementEnabled($isDebtManagementEnabled)
            ->setIsWithinRecissionPeriod($isWithinRecissionPeriod)
            ->setIsMarketingOptIn($isMarketingOptIn)
            ->setMinPaymentToReconnect($minPaymentToReconnect)
            ->setIsSoftArmed($isSoftArmed)
            ->setServicePointMeterID($servicePointMeterID)
            ->setKWhRemaining($kWhRemaining)
            ->setIsPaymentsEnabled($isPaymentsEnabled)
            ->setActivePaymentArrangement($activePaymentArrangement)
            ->setNextPayArrangeDueDate($nextPayArrangeDueDate)
            ->setLastPaymentAmount($lastPaymentAmount)
            ->setPaymentArrangementBalance($paymentArrangementBalance)
            ->setAverageDailyUsage($averageDailyUsage)
            ->setAverageDailyKwh($averageDailyKwh)
            ->setCurrentMonthKwh($currentMonthKwh)
            ->setDaysRemaining($daysRemaining)
            ->setHasBrandedCardAccount($hasBrandedCardAccount)
            ->setBrandedCardAccountBalance($brandedCardAccountBalance)
            ->setIsPowerOff($isPowerOff)
            ->setAccountBalance($accountBalance)
            ->setAvailableBalance($availableBalance)
            ->setPastDueAmount($pastDueAmount)
            ->setDisconnectThreshold($disconnectThreshold)
            ->setAccountNumber($accountNumber)
            ->setAccountStatusName($accountStatusName)
            ->setAccountTypeName($accountTypeName)
            ->setLanguage($language)
            ->setNotificationChannelName($notificationChannelName)
            ->setEnergyAssistanceProgramNames($energyAssistanceProgramNames)
            ->setDefaultState($defaultState)
            ->setPortalMessage($portalMessage)
            ->setMeterStatus($meterStatus)
            ->setMailingAddress($mailingAddress)
            ->setPerson($person)
            ->setServicePoints($servicePoints)
            ->setServiceAgreements($serviceAgreements)
            ->setProduct($product)
            ->setDailyBurnRate($dailyBurnRate)
            ->setBillHeaders($billHeaders)
            ->setPaymentAccounts($paymentAccounts)
            ->setBillDeliveryMethod($billDeliveryMethod);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountStatusID value
     * @return int
     */
    public function getAccountStatusID()
    {
        return $this->AccountStatusID;
    }
    /**
     * Set AccountStatusID value
     * @param int $accountStatusID
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setAccountStatusID($accountStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($accountStatusID) && !is_numeric($accountStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountStatusID)), __LINE__);
        }
        $this->AccountStatusID = $accountStatusID;
        return $this;
    }
    /**
     * Get AccountTypeID value
     * @return int
     */
    public function getAccountTypeID()
    {
        return $this->AccountTypeID;
    }
    /**
     * Set AccountTypeID value
     * @param int $accountTypeID
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setAccountTypeID($accountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeID) && !is_numeric($accountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTypeID)), __LINE__);
        }
        $this->AccountTypeID = $accountTypeID;
        return $this;
    }
    /**
     * Get AccountStartDate value
     * @return string
     */
    public function getAccountStartDate()
    {
        return $this->AccountStartDate;
    }
    /**
     * Set AccountStartDate value
     * @param string $accountStartDate
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setAccountStartDate($accountStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($accountStartDate) && !is_string($accountStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStartDate)), __LINE__);
        }
        $this->AccountStartDate = $accountStartDate;
        return $this;
    }
    /**
     * Get AccountEndDate value
     * @return string
     */
    public function getAccountEndDate()
    {
        return $this->AccountEndDate;
    }
    /**
     * Set AccountEndDate value
     * @param string $accountEndDate
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setAccountEndDate($accountEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($accountEndDate) && !is_string($accountEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountEndDate)), __LINE__);
        }
        $this->AccountEndDate = $accountEndDate;
        return $this;
    }
    /**
     * Get LanguageID value
     * @return int
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !is_numeric($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get NotificationChannelID value
     * @return int
     */
    public function getNotificationChannelID()
    {
        return $this->NotificationChannelID;
    }
    /**
     * Set NotificationChannelID value
     * @param int $notificationChannelID
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setNotificationChannelID($notificationChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($notificationChannelID) && !is_numeric($notificationChannelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notificationChannelID)), __LINE__);
        }
        $this->NotificationChannelID = $notificationChannelID;
        return $this;
    }
    /**
     * Get IsEnergyAssistance value
     * @return bool
     */
    public function getIsEnergyAssistance()
    {
        return $this->IsEnergyAssistance;
    }
    /**
     * Set IsEnergyAssistance value
     * @param bool $isEnergyAssistance
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setIsEnergyAssistance($isEnergyAssistance = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnergyAssistance) && !is_bool($isEnergyAssistance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEnergyAssistance)), __LINE__);
        }
        $this->IsEnergyAssistance = $isEnergyAssistance;
        return $this;
    }
    /**
     * Get IsMobilePaymentsEnabled value
     * @return bool
     */
    public function getIsMobilePaymentsEnabled()
    {
        return $this->IsMobilePaymentsEnabled;
    }
    /**
     * Set IsMobilePaymentsEnabled value
     * @param bool $isMobilePaymentsEnabled
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setIsMobilePaymentsEnabled($isMobilePaymentsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMobilePaymentsEnabled) && !is_bool($isMobilePaymentsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMobilePaymentsEnabled)), __LINE__);
        }
        $this->IsMobilePaymentsEnabled = $isMobilePaymentsEnabled;
        return $this;
    }
    /**
     * Get IsDebtManagementEnabled value
     * @return bool
     */
    public function getIsDebtManagementEnabled()
    {
        return $this->IsDebtManagementEnabled;
    }
    /**
     * Set IsDebtManagementEnabled value
     * @param bool $isDebtManagementEnabled
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setIsDebtManagementEnabled($isDebtManagementEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDebtManagementEnabled) && !is_bool($isDebtManagementEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDebtManagementEnabled)), __LINE__);
        }
        $this->IsDebtManagementEnabled = $isDebtManagementEnabled;
        return $this;
    }
    /**
     * Get IsWithinRecissionPeriod value
     * @return bool
     */
    public function getIsWithinRecissionPeriod()
    {
        return $this->IsWithinRecissionPeriod;
    }
    /**
     * Set IsWithinRecissionPeriod value
     * @param bool $isWithinRecissionPeriod
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setIsWithinRecissionPeriod($isWithinRecissionPeriod = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWithinRecissionPeriod) && !is_bool($isWithinRecissionPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isWithinRecissionPeriod)), __LINE__);
        }
        $this->IsWithinRecissionPeriod = $isWithinRecissionPeriod;
        return $this;
    }
    /**
     * Get IsMarketingOptIn value
     * @return bool
     */
    public function getIsMarketingOptIn()
    {
        return $this->IsMarketingOptIn;
    }
    /**
     * Set IsMarketingOptIn value
     * @param bool $isMarketingOptIn
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setIsMarketingOptIn($isMarketingOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMarketingOptIn) && !is_bool($isMarketingOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMarketingOptIn)), __LINE__);
        }
        $this->IsMarketingOptIn = $isMarketingOptIn;
        return $this;
    }
    /**
     * Get MinPaymentToReconnect value
     * @return float
     */
    public function getMinPaymentToReconnect()
    {
        return $this->MinPaymentToReconnect;
    }
    /**
     * Set MinPaymentToReconnect value
     * @param float $minPaymentToReconnect
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setMinPaymentToReconnect($minPaymentToReconnect = null)
    {
        $this->MinPaymentToReconnect = $minPaymentToReconnect;
        return $this;
    }
    /**
     * Get IsSoftArmed value
     * @return bool
     */
    public function getIsSoftArmed()
    {
        return $this->IsSoftArmed;
    }
    /**
     * Set IsSoftArmed value
     * @param bool $isSoftArmed
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setIsSoftArmed($isSoftArmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSoftArmed) && !is_bool($isSoftArmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSoftArmed)), __LINE__);
        }
        $this->IsSoftArmed = $isSoftArmed;
        return $this;
    }
    /**
     * Get ServicePointMeterID value
     * @return int
     */
    public function getServicePointMeterID()
    {
        return $this->ServicePointMeterID;
    }
    /**
     * Set ServicePointMeterID value
     * @param int $servicePointMeterID
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setServicePointMeterID($servicePointMeterID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointMeterID) && !is_numeric($servicePointMeterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointMeterID)), __LINE__);
        }
        $this->ServicePointMeterID = $servicePointMeterID;
        return $this;
    }
    /**
     * Get kWhRemaining value
     * @return float
     */
    public function getKWhRemaining()
    {
        return $this->kWhRemaining;
    }
    /**
     * Set kWhRemaining value
     * @param float $kWhRemaining
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setKWhRemaining($kWhRemaining = null)
    {
        $this->kWhRemaining = $kWhRemaining;
        return $this;
    }
    /**
     * Get IsPaymentsEnabled value
     * @return bool
     */
    public function getIsPaymentsEnabled()
    {
        return $this->IsPaymentsEnabled;
    }
    /**
     * Set IsPaymentsEnabled value
     * @param bool $isPaymentsEnabled
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setIsPaymentsEnabled($isPaymentsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaymentsEnabled) && !is_bool($isPaymentsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPaymentsEnabled)), __LINE__);
        }
        $this->IsPaymentsEnabled = $isPaymentsEnabled;
        return $this;
    }
    /**
     * Get ActivePaymentArrangement value
     * @return bool
     */
    public function getActivePaymentArrangement()
    {
        return $this->ActivePaymentArrangement;
    }
    /**
     * Set ActivePaymentArrangement value
     * @param bool $activePaymentArrangement
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setActivePaymentArrangement($activePaymentArrangement = null)
    {
        // validation for constraint: boolean
        if (!is_null($activePaymentArrangement) && !is_bool($activePaymentArrangement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($activePaymentArrangement)), __LINE__);
        }
        $this->ActivePaymentArrangement = $activePaymentArrangement;
        return $this;
    }
    /**
     * Get NextPayArrangeDueDate value
     * @return string
     */
    public function getNextPayArrangeDueDate()
    {
        return $this->NextPayArrangeDueDate;
    }
    /**
     * Set NextPayArrangeDueDate value
     * @param string $nextPayArrangeDueDate
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setNextPayArrangeDueDate($nextPayArrangeDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextPayArrangeDueDate) && !is_string($nextPayArrangeDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextPayArrangeDueDate)), __LINE__);
        }
        $this->NextPayArrangeDueDate = $nextPayArrangeDueDate;
        return $this;
    }
    /**
     * Get LastPaymentAmount value
     * @return float
     */
    public function getLastPaymentAmount()
    {
        return $this->LastPaymentAmount;
    }
    /**
     * Set LastPaymentAmount value
     * @param float $lastPaymentAmount
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setLastPaymentAmount($lastPaymentAmount = null)
    {
        $this->LastPaymentAmount = $lastPaymentAmount;
        return $this;
    }
    /**
     * Get PaymentArrangementBalance value
     * @return float
     */
    public function getPaymentArrangementBalance()
    {
        return $this->PaymentArrangementBalance;
    }
    /**
     * Set PaymentArrangementBalance value
     * @param float $paymentArrangementBalance
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setPaymentArrangementBalance($paymentArrangementBalance = null)
    {
        $this->PaymentArrangementBalance = $paymentArrangementBalance;
        return $this;
    }
    /**
     * Get AverageDailyUsage value
     * @return float
     */
    public function getAverageDailyUsage()
    {
        return $this->AverageDailyUsage;
    }
    /**
     * Set AverageDailyUsage value
     * @param float $averageDailyUsage
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setAverageDailyUsage($averageDailyUsage = null)
    {
        $this->AverageDailyUsage = $averageDailyUsage;
        return $this;
    }
    /**
     * Get AverageDailyKwh value
     * @return float
     */
    public function getAverageDailyKwh()
    {
        return $this->AverageDailyKwh;
    }
    /**
     * Set AverageDailyKwh value
     * @param float $averageDailyKwh
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setAverageDailyKwh($averageDailyKwh = null)
    {
        $this->AverageDailyKwh = $averageDailyKwh;
        return $this;
    }
    /**
     * Get CurrentMonthKwh value
     * @return float
     */
    public function getCurrentMonthKwh()
    {
        return $this->CurrentMonthKwh;
    }
    /**
     * Set CurrentMonthKwh value
     * @param float $currentMonthKwh
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setCurrentMonthKwh($currentMonthKwh = null)
    {
        $this->CurrentMonthKwh = $currentMonthKwh;
        return $this;
    }
    /**
     * Get DaysRemaining value
     * @return int
     */
    public function getDaysRemaining()
    {
        return $this->DaysRemaining;
    }
    /**
     * Set DaysRemaining value
     * @param int $daysRemaining
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setDaysRemaining($daysRemaining = null)
    {
        // validation for constraint: int
        if (!is_null($daysRemaining) && !is_numeric($daysRemaining)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($daysRemaining)), __LINE__);
        }
        $this->DaysRemaining = $daysRemaining;
        return $this;
    }
    /**
     * Get HasBrandedCardAccount value
     * @return bool
     */
    public function getHasBrandedCardAccount()
    {
        return $this->HasBrandedCardAccount;
    }
    /**
     * Set HasBrandedCardAccount value
     * @param bool $hasBrandedCardAccount
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setHasBrandedCardAccount($hasBrandedCardAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasBrandedCardAccount) && !is_bool($hasBrandedCardAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasBrandedCardAccount)), __LINE__);
        }
        $this->HasBrandedCardAccount = $hasBrandedCardAccount;
        return $this;
    }
    /**
     * Get BrandedCardAccountBalance value
     * @return float
     */
    public function getBrandedCardAccountBalance()
    {
        return $this->BrandedCardAccountBalance;
    }
    /**
     * Set BrandedCardAccountBalance value
     * @param float $brandedCardAccountBalance
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setBrandedCardAccountBalance($brandedCardAccountBalance = null)
    {
        $this->BrandedCardAccountBalance = $brandedCardAccountBalance;
        return $this;
    }
    /**
     * Get IsPowerOff value
     * @return bool
     */
    public function getIsPowerOff()
    {
        return $this->IsPowerOff;
    }
    /**
     * Set IsPowerOff value
     * @param bool $isPowerOff
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setIsPowerOff($isPowerOff = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPowerOff) && !is_bool($isPowerOff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPowerOff)), __LINE__);
        }
        $this->IsPowerOff = $isPowerOff;
        return $this;
    }
    /**
     * Get AccountBalance value
     * @return float
     */
    public function getAccountBalance()
    {
        return $this->AccountBalance;
    }
    /**
     * Set AccountBalance value
     * @param float $accountBalance
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setAccountBalance($accountBalance = null)
    {
        $this->AccountBalance = $accountBalance;
        return $this;
    }
    /**
     * Get AvailableBalance value
     * @return float
     */
    public function getAvailableBalance()
    {
        return $this->AvailableBalance;
    }
    /**
     * Set AvailableBalance value
     * @param float $availableBalance
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setAvailableBalance($availableBalance = null)
    {
        $this->AvailableBalance = $availableBalance;
        return $this;
    }
    /**
     * Get PastDueAmount value
     * @return float
     */
    public function getPastDueAmount()
    {
        return $this->PastDueAmount;
    }
    /**
     * Set PastDueAmount value
     * @param float $pastDueAmount
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setPastDueAmount($pastDueAmount = null)
    {
        $this->PastDueAmount = $pastDueAmount;
        return $this;
    }
    /**
     * Get DisconnectThreshold value
     * @return float
     */
    public function getDisconnectThreshold()
    {
        return $this->DisconnectThreshold;
    }
    /**
     * Set DisconnectThreshold value
     * @param float $disconnectThreshold
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setDisconnectThreshold($disconnectThreshold = null)
    {
        $this->DisconnectThreshold = $disconnectThreshold;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AccountStatusName value
     * @return string|null
     */
    public function getAccountStatusName()
    {
        return $this->AccountStatusName;
    }
    /**
     * Set AccountStatusName value
     * @param string $accountStatusName
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setAccountStatusName($accountStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($accountStatusName) && !is_string($accountStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStatusName)), __LINE__);
        }
        $this->AccountStatusName = $accountStatusName;
        return $this;
    }
    /**
     * Get AccountTypeName value
     * @return string|null
     */
    public function getAccountTypeName()
    {
        return $this->AccountTypeName;
    }
    /**
     * Set AccountTypeName value
     * @param string $accountTypeName
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setAccountTypeName($accountTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($accountTypeName) && !is_string($accountTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountTypeName)), __LINE__);
        }
        $this->AccountTypeName = $accountTypeName;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get NotificationChannelName value
     * @return string|null
     */
    public function getNotificationChannelName()
    {
        return $this->NotificationChannelName;
    }
    /**
     * Set NotificationChannelName value
     * @param string $notificationChannelName
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setNotificationChannelName($notificationChannelName = null)
    {
        // validation for constraint: string
        if (!is_null($notificationChannelName) && !is_string($notificationChannelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationChannelName)), __LINE__);
        }
        $this->NotificationChannelName = $notificationChannelName;
        return $this;
    }
    /**
     * Get EnergyAssistanceProgramNames value
     * @return string|null
     */
    public function getEnergyAssistanceProgramNames()
    {
        return $this->EnergyAssistanceProgramNames;
    }
    /**
     * Set EnergyAssistanceProgramNames value
     * @param string $energyAssistanceProgramNames
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setEnergyAssistanceProgramNames($energyAssistanceProgramNames = null)
    {
        // validation for constraint: string
        if (!is_null($energyAssistanceProgramNames) && !is_string($energyAssistanceProgramNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($energyAssistanceProgramNames)), __LINE__);
        }
        $this->EnergyAssistanceProgramNames = $energyAssistanceProgramNames;
        return $this;
    }
    /**
     * Get DefaultState value
     * @return string|null
     */
    public function getDefaultState()
    {
        return $this->DefaultState;
    }
    /**
     * Set DefaultState value
     * @param string $defaultState
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setDefaultState($defaultState = null)
    {
        // validation for constraint: string
        if (!is_null($defaultState) && !is_string($defaultState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultState)), __LINE__);
        }
        $this->DefaultState = $defaultState;
        return $this;
    }
    /**
     * Get PortalMessage value
     * @return string|null
     */
    public function getPortalMessage()
    {
        return $this->PortalMessage;
    }
    /**
     * Set PortalMessage value
     * @param string $portalMessage
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setPortalMessage($portalMessage = null)
    {
        // validation for constraint: string
        if (!is_null($portalMessage) && !is_string($portalMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($portalMessage)), __LINE__);
        }
        $this->PortalMessage = $portalMessage;
        return $this;
    }
    /**
     * Get MeterStatus value
     * @return string|null
     */
    public function getMeterStatus()
    {
        return $this->MeterStatus;
    }
    /**
     * Set MeterStatus value
     * @param string $meterStatus
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setMeterStatus($meterStatus = null)
    {
        // validation for constraint: string
        if (!is_null($meterStatus) && !is_string($meterStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterStatus)), __LINE__);
        }
        $this->MeterStatus = $meterStatus;
        return $this;
    }
    /**
     * Get MailingAddress value
     * @return \SGCIS\Struct\AccountAddress|null
     */
    public function getMailingAddress()
    {
        return $this->MailingAddress;
    }
    /**
     * Set MailingAddress value
     * @param \SGCIS\Struct\AccountAddress $mailingAddress
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setMailingAddress(\SGCIS\Struct\AccountAddress $mailingAddress = null)
    {
        $this->MailingAddress = $mailingAddress;
        return $this;
    }
    /**
     * Get Person value
     * @return \SGCIS\Struct\Person|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \SGCIS\Struct\Person $person
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setPerson(\SGCIS\Struct\Person $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get ServicePoints value
     * @return \SGCIS\Array\ArrayOfServicePoint|null
     */
    public function getServicePoints()
    {
        return $this->ServicePoints;
    }
    /**
     * Set ServicePoints value
     * @param \SGCIS\Array\ArrayOfServicePoint $servicePoints
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setServicePoints(\SGCIS\Array\ArrayOfServicePoint $servicePoints = null)
    {
        $this->ServicePoints = $servicePoints;
        return $this;
    }
    /**
     * Get ServiceAgreements value
     * @return \SGCIS\Array\ArrayOfServiceAgreement|null
     */
    public function getServiceAgreements()
    {
        return $this->ServiceAgreements;
    }
    /**
     * Set ServiceAgreements value
     * @param \SGCIS\Array\ArrayOfServiceAgreement $serviceAgreements
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setServiceAgreements(\SGCIS\Array\ArrayOfServiceAgreement $serviceAgreements = null)
    {
        $this->ServiceAgreements = $serviceAgreements;
        return $this;
    }
    /**
     * Get Product value
     * @return \SGCIS\Struct\Product|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \SGCIS\Struct\Product $product
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setProduct(\SGCIS\Struct\Product $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get DailyBurnRate value
     * @return \SGCIS\Struct\DailyBurnRate|null
     */
    public function getDailyBurnRate()
    {
        return $this->DailyBurnRate;
    }
    /**
     * Set DailyBurnRate value
     * @param \SGCIS\Struct\DailyBurnRate $dailyBurnRate
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setDailyBurnRate(\SGCIS\Struct\DailyBurnRate $dailyBurnRate = null)
    {
        $this->DailyBurnRate = $dailyBurnRate;
        return $this;
    }
    /**
     * Get BillHeaders value
     * @return \SGCIS\Array\ArrayOfBillHeader|null
     */
    public function getBillHeaders()
    {
        return $this->BillHeaders;
    }
    /**
     * Set BillHeaders value
     * @param \SGCIS\Array\ArrayOfBillHeader $billHeaders
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setBillHeaders(\SGCIS\Array\ArrayOfBillHeader $billHeaders = null)
    {
        $this->BillHeaders = $billHeaders;
        return $this;
    }
    /**
     * Get PaymentAccounts value
     * @return \SGCIS\Array\ArrayOfPaymentAccount|null
     */
    public function getPaymentAccounts()
    {
        return $this->PaymentAccounts;
    }
    /**
     * Set PaymentAccounts value
     * @param \SGCIS\Array\ArrayOfPaymentAccount $paymentAccounts
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setPaymentAccounts(\SGCIS\Array\ArrayOfPaymentAccount $paymentAccounts = null)
    {
        $this->PaymentAccounts = $paymentAccounts;
        return $this;
    }
    /**
     * Get BillDeliveryMethod value
     * @return \SGCIS\Array\ArrayOfBillDeliveryMethod|null
     */
    public function getBillDeliveryMethod()
    {
        return $this->BillDeliveryMethod;
    }
    /**
     * Set BillDeliveryMethod value
     * @param \SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethod
     * @return \SGCIS\Struct\AccountSummary
     */
    public function setBillDeliveryMethod(\SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethod = null)
    {
        $this->BillDeliveryMethod = $billDeliveryMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
