<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountStatus Struct
 * @subpackage Structs
 */
class AccountStatus extends AbstractStructBase
{
    /**
     * The AccountStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountStatusID;
    /**
     * The AccountStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountStatusName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for AccountStatus
     * @uses AccountStatus::setAccountStatusID()
     * @uses AccountStatus::setAccountStatusName()
     * @uses AccountStatus::setDescription()
     * @param int $accountStatusID
     * @param string $accountStatusName
     * @param string $description
     */
    public function __construct($accountStatusID = null, $accountStatusName = null, $description = null)
    {
        $this
            ->setAccountStatusID($accountStatusID)
            ->setAccountStatusName($accountStatusName)
            ->setDescription($description);
    }
    /**
     * Get AccountStatusID value
     * @return int
     */
    public function getAccountStatusID()
    {
        return $this->AccountStatusID;
    }
    /**
     * Set AccountStatusID value
     * @param int $accountStatusID
     * @return \SGCIS\Struct\AccountStatus
     */
    public function setAccountStatusID($accountStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($accountStatusID) && !is_numeric($accountStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountStatusID)), __LINE__);
        }
        $this->AccountStatusID = $accountStatusID;
        return $this;
    }
    /**
     * Get AccountStatusName value
     * @return string|null
     */
    public function getAccountStatusName()
    {
        return $this->AccountStatusName;
    }
    /**
     * Set AccountStatusName value
     * @param string $accountStatusName
     * @return \SGCIS\Struct\AccountStatus
     */
    public function setAccountStatusName($accountStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($accountStatusName) && !is_string($accountStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStatusName)), __LINE__);
        }
        $this->AccountStatusName = $accountStatusName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\AccountStatus
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
