<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountServicePointTarrifCharge Struct
 * @subpackage Structs
 */
class AccountServicePointTarrifCharge extends AbstractStructBase
{
    /**
     * The AccountServicePointTarrifChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointTarrifChargeID;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The TarrifChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TarrifChargeID;
    /**
     * The OtherChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OtherChargeID;
    /**
     * The ChargeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChargeAmount;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The ChargeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeType;
    /**
     * The ChargeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The CreatedByUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByUser;
    /**
     * Constructor method for AccountServicePointTarrifCharge
     * @uses AccountServicePointTarrifCharge::setAccountServicePointTarrifChargeID()
     * @uses AccountServicePointTarrifCharge::setAccountServicePointID()
     * @uses AccountServicePointTarrifCharge::setTarrifChargeID()
     * @uses AccountServicePointTarrifCharge::setOtherChargeID()
     * @uses AccountServicePointTarrifCharge::setChargeAmount()
     * @uses AccountServicePointTarrifCharge::setCreateDate()
     * @uses AccountServicePointTarrifCharge::setChargeType()
     * @uses AccountServicePointTarrifCharge::setChargeCode()
     * @uses AccountServicePointTarrifCharge::setDescription()
     * @uses AccountServicePointTarrifCharge::setCreatedByUser()
     * @param int $accountServicePointTarrifChargeID
     * @param int $accountServicePointID
     * @param int $tarrifChargeID
     * @param int $otherChargeID
     * @param float $chargeAmount
     * @param string $createDate
     * @param string $chargeType
     * @param string $chargeCode
     * @param string $description
     * @param string $createdByUser
     */
    public function __construct($accountServicePointTarrifChargeID = null, $accountServicePointID = null, $tarrifChargeID = null, $otherChargeID = null, $chargeAmount = null, $createDate = null, $chargeType = null, $chargeCode = null, $description = null, $createdByUser = null)
    {
        $this
            ->setAccountServicePointTarrifChargeID($accountServicePointTarrifChargeID)
            ->setAccountServicePointID($accountServicePointID)
            ->setTarrifChargeID($tarrifChargeID)
            ->setOtherChargeID($otherChargeID)
            ->setChargeAmount($chargeAmount)
            ->setCreateDate($createDate)
            ->setChargeType($chargeType)
            ->setChargeCode($chargeCode)
            ->setDescription($description)
            ->setCreatedByUser($createdByUser);
    }
    /**
     * Get AccountServicePointTarrifChargeID value
     * @return int
     */
    public function getAccountServicePointTarrifChargeID()
    {
        return $this->AccountServicePointTarrifChargeID;
    }
    /**
     * Set AccountServicePointTarrifChargeID value
     * @param int $accountServicePointTarrifChargeID
     * @return \SGCIS\Struct\AccountServicePointTarrifCharge
     */
    public function setAccountServicePointTarrifChargeID($accountServicePointTarrifChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointTarrifChargeID) && !is_numeric($accountServicePointTarrifChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointTarrifChargeID)), __LINE__);
        }
        $this->AccountServicePointTarrifChargeID = $accountServicePointTarrifChargeID;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\AccountServicePointTarrifCharge
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get TarrifChargeID value
     * @return int
     */
    public function getTarrifChargeID()
    {
        return $this->TarrifChargeID;
    }
    /**
     * Set TarrifChargeID value
     * @param int $tarrifChargeID
     * @return \SGCIS\Struct\AccountServicePointTarrifCharge
     */
    public function setTarrifChargeID($tarrifChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($tarrifChargeID) && !is_numeric($tarrifChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tarrifChargeID)), __LINE__);
        }
        $this->TarrifChargeID = $tarrifChargeID;
        return $this;
    }
    /**
     * Get OtherChargeID value
     * @return int
     */
    public function getOtherChargeID()
    {
        return $this->OtherChargeID;
    }
    /**
     * Set OtherChargeID value
     * @param int $otherChargeID
     * @return \SGCIS\Struct\AccountServicePointTarrifCharge
     */
    public function setOtherChargeID($otherChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($otherChargeID) && !is_numeric($otherChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($otherChargeID)), __LINE__);
        }
        $this->OtherChargeID = $otherChargeID;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return float
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param float $chargeAmount
     * @return \SGCIS\Struct\AccountServicePointTarrifCharge
     */
    public function setChargeAmount($chargeAmount = null)
    {
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\AccountServicePointTarrifCharge
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get ChargeType value
     * @return string|null
     */
    public function getChargeType()
    {
        return $this->ChargeType;
    }
    /**
     * Set ChargeType value
     * @param string $chargeType
     * @return \SGCIS\Struct\AccountServicePointTarrifCharge
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: string
        if (!is_null($chargeType) && !is_string($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeType)), __LINE__);
        }
        $this->ChargeType = $chargeType;
        return $this;
    }
    /**
     * Get ChargeCode value
     * @return string|null
     */
    public function getChargeCode()
    {
        return $this->ChargeCode;
    }
    /**
     * Set ChargeCode value
     * @param string $chargeCode
     * @return \SGCIS\Struct\AccountServicePointTarrifCharge
     */
    public function setChargeCode($chargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCode) && !is_string($chargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeCode)), __LINE__);
        }
        $this->ChargeCode = $chargeCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\AccountServicePointTarrifCharge
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CreatedByUser value
     * @return string|null
     */
    public function getCreatedByUser()
    {
        return $this->CreatedByUser;
    }
    /**
     * Set CreatedByUser value
     * @param string $createdByUser
     * @return \SGCIS\Struct\AccountServicePointTarrifCharge
     */
    public function setCreatedByUser($createdByUser = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUser) && !is_string($createdByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdByUser)), __LINE__);
        }
        $this->CreatedByUser = $createdByUser;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountServicePointTarrifCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
