<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountRequest Struct
 * @subpackage Structs
 */
class AccountRequest extends ServiceRequestBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The IncludeCollections
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeCollections;
    /**
     * The AccountCollectionTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountCollectionTypeID;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The MarketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketID;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Account
     */
    public $Account;
    /**
     * The AccountAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountAddress
     */
    public $AccountAddress;
    /**
     * The AccountDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountDocument
     */
    public $AccountDocument;
    /**
     * The UpdateSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpdateSource;
    /**
     * Constructor method for AccountRequest
     * @uses AccountRequest::setAccountID()
     * @uses AccountRequest::setIncludeCollections()
     * @uses AccountRequest::setAccountCollectionTypeID()
     * @uses AccountRequest::setAccountNumber()
     * @uses AccountRequest::setMarketID()
     * @uses AccountRequest::setAccount()
     * @uses AccountRequest::setAccountAddress()
     * @uses AccountRequest::setAccountDocument()
     * @uses AccountRequest::setUpdateSource()
     * @param int $accountID
     * @param bool $includeCollections
     * @param int $accountCollectionTypeID
     * @param string $accountNumber
     * @param string $marketID
     * @param \SGCIS\Struct\Account $account
     * @param \SGCIS\Struct\AccountAddress $accountAddress
     * @param \SGCIS\Struct\AccountDocument $accountDocument
     * @param string $updateSource
     */
    public function __construct($accountID = null, $includeCollections = null, $accountCollectionTypeID = null, $accountNumber = null, $marketID = null, \SGCIS\Struct\Account $account = null, \SGCIS\Struct\AccountAddress $accountAddress = null, \SGCIS\Struct\AccountDocument $accountDocument = null, $updateSource = null)
    {
        $this
            ->setAccountID($accountID)
            ->setIncludeCollections($includeCollections)
            ->setAccountCollectionTypeID($accountCollectionTypeID)
            ->setAccountNumber($accountNumber)
            ->setMarketID($marketID)
            ->setAccount($account)
            ->setAccountAddress($accountAddress)
            ->setAccountDocument($accountDocument)
            ->setUpdateSource($updateSource);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountRequest
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get IncludeCollections value
     * @return bool
     */
    public function getIncludeCollections()
    {
        return $this->IncludeCollections;
    }
    /**
     * Set IncludeCollections value
     * @param bool $includeCollections
     * @return \SGCIS\Struct\AccountRequest
     */
    public function setIncludeCollections($includeCollections = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCollections) && !is_bool($includeCollections)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeCollections)), __LINE__);
        }
        $this->IncludeCollections = $includeCollections;
        return $this;
    }
    /**
     * Get AccountCollectionTypeID value
     * @return int
     */
    public function getAccountCollectionTypeID()
    {
        return $this->AccountCollectionTypeID;
    }
    /**
     * Set AccountCollectionTypeID value
     * @param int $accountCollectionTypeID
     * @return \SGCIS\Struct\AccountRequest
     */
    public function setAccountCollectionTypeID($accountCollectionTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountCollectionTypeID) && !is_numeric($accountCollectionTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountCollectionTypeID)), __LINE__);
        }
        $this->AccountCollectionTypeID = $accountCollectionTypeID;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\AccountRequest
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get MarketID value
     * @return string|null
     */
    public function getMarketID()
    {
        return $this->MarketID;
    }
    /**
     * Set MarketID value
     * @param string $marketID
     * @return \SGCIS\Struct\AccountRequest
     */
    public function setMarketID($marketID = null)
    {
        // validation for constraint: string
        if (!is_null($marketID) && !is_string($marketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketID)), __LINE__);
        }
        $this->MarketID = $marketID;
        return $this;
    }
    /**
     * Get Account value
     * @return \SGCIS\Struct\Account|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \SGCIS\Struct\Account $account
     * @return \SGCIS\Struct\AccountRequest
     */
    public function setAccount(\SGCIS\Struct\Account $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get AccountAddress value
     * @return \SGCIS\Struct\AccountAddress|null
     */
    public function getAccountAddress()
    {
        return $this->AccountAddress;
    }
    /**
     * Set AccountAddress value
     * @param \SGCIS\Struct\AccountAddress $accountAddress
     * @return \SGCIS\Struct\AccountRequest
     */
    public function setAccountAddress(\SGCIS\Struct\AccountAddress $accountAddress = null)
    {
        $this->AccountAddress = $accountAddress;
        return $this;
    }
    /**
     * Get AccountDocument value
     * @return \SGCIS\Struct\AccountDocument|null
     */
    public function getAccountDocument()
    {
        return $this->AccountDocument;
    }
    /**
     * Set AccountDocument value
     * @param \SGCIS\Struct\AccountDocument $accountDocument
     * @return \SGCIS\Struct\AccountRequest
     */
    public function setAccountDocument(\SGCIS\Struct\AccountDocument $accountDocument = null)
    {
        $this->AccountDocument = $accountDocument;
        return $this;
    }
    /**
     * Get UpdateSource value
     * @return string|null
     */
    public function getUpdateSource()
    {
        return $this->UpdateSource;
    }
    /**
     * Set UpdateSource value
     * @param string $updateSource
     * @return \SGCIS\Struct\AccountRequest
     */
    public function setUpdateSource($updateSource = null)
    {
        // validation for constraint: string
        if (!is_null($updateSource) && !is_string($updateSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateSource)), __LINE__);
        }
        $this->UpdateSource = $updateSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
