<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountNote Struct
 * @subpackage Structs
 */
class AccountNote extends BaseDTO
{
    /**
     * The AccountNoteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountNoteID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The NoteTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NoteTypeID;
    /**
     * The NoteTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoteTypeName;
    /**
     * The NoteText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoteText;
    /**
     * The NoteUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoteUserName;
    /**
     * Constructor method for AccountNote
     * @uses AccountNote::setAccountNoteID()
     * @uses AccountNote::setAccountID()
     * @uses AccountNote::setNoteTypeID()
     * @uses AccountNote::setNoteTypeName()
     * @uses AccountNote::setNoteText()
     * @uses AccountNote::setNoteUserName()
     * @param int $accountNoteID
     * @param int $accountID
     * @param int $noteTypeID
     * @param string $noteTypeName
     * @param string $noteText
     * @param string $noteUserName
     */
    public function __construct($accountNoteID = null, $accountID = null, $noteTypeID = null, $noteTypeName = null, $noteText = null, $noteUserName = null)
    {
        $this
            ->setAccountNoteID($accountNoteID)
            ->setAccountID($accountID)
            ->setNoteTypeID($noteTypeID)
            ->setNoteTypeName($noteTypeName)
            ->setNoteText($noteText)
            ->setNoteUserName($noteUserName);
    }
    /**
     * Get AccountNoteID value
     * @return int
     */
    public function getAccountNoteID()
    {
        return $this->AccountNoteID;
    }
    /**
     * Set AccountNoteID value
     * @param int $accountNoteID
     * @return \SGCIS\Struct\AccountNote
     */
    public function setAccountNoteID($accountNoteID = null)
    {
        // validation for constraint: int
        if (!is_null($accountNoteID) && !is_numeric($accountNoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountNoteID)), __LINE__);
        }
        $this->AccountNoteID = $accountNoteID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountNote
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get NoteTypeID value
     * @return int
     */
    public function getNoteTypeID()
    {
        return $this->NoteTypeID;
    }
    /**
     * Set NoteTypeID value
     * @param int $noteTypeID
     * @return \SGCIS\Struct\AccountNote
     */
    public function setNoteTypeID($noteTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($noteTypeID) && !is_numeric($noteTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noteTypeID)), __LINE__);
        }
        $this->NoteTypeID = $noteTypeID;
        return $this;
    }
    /**
     * Get NoteTypeName value
     * @return string|null
     */
    public function getNoteTypeName()
    {
        return $this->NoteTypeName;
    }
    /**
     * Set NoteTypeName value
     * @param string $noteTypeName
     * @return \SGCIS\Struct\AccountNote
     */
    public function setNoteTypeName($noteTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($noteTypeName) && !is_string($noteTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noteTypeName)), __LINE__);
        }
        $this->NoteTypeName = $noteTypeName;
        return $this;
    }
    /**
     * Get NoteText value
     * @return string|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param string $noteText
     * @return \SGCIS\Struct\AccountNote
     */
    public function setNoteText($noteText = null)
    {
        // validation for constraint: string
        if (!is_null($noteText) && !is_string($noteText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noteText)), __LINE__);
        }
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get NoteUserName value
     * @return string|null
     */
    public function getNoteUserName()
    {
        return $this->NoteUserName;
    }
    /**
     * Set NoteUserName value
     * @param string $noteUserName
     * @return \SGCIS\Struct\AccountNote
     */
    public function setNoteUserName($noteUserName = null)
    {
        // validation for constraint: string
        if (!is_null($noteUserName) && !is_string($noteUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noteUserName)), __LINE__);
        }
        $this->NoteUserName = $noteUserName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
