<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountFee Struct
 * @subpackage Structs
 */
class AccountFee extends BaseDTO
{
    /**
     * The FeeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FeeID;
    /**
     * The IsTaxable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTaxable;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The FeeEventName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeEventName;
    /**
     * The FeeEventDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeEventDescription;
    /**
     * The ChargeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCode;
    /**
     * The FeeEvents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfFeeEvent
     */
    public $FeeEvents;
    /**
     * Constructor method for AccountFee
     * @uses AccountFee::setFeeID()
     * @uses AccountFee::setIsTaxable()
     * @uses AccountFee::setActive()
     * @uses AccountFee::setAmount()
     * @uses AccountFee::setName()
     * @uses AccountFee::setDescription()
     * @uses AccountFee::setFeeEventName()
     * @uses AccountFee::setFeeEventDescription()
     * @uses AccountFee::setChargeCode()
     * @uses AccountFee::setFeeEvents()
     * @param int $feeID
     * @param bool $isTaxable
     * @param bool $active
     * @param float $amount
     * @param string $name
     * @param string $description
     * @param string $feeEventName
     * @param string $feeEventDescription
     * @param string $chargeCode
     * @param \SGCIS\Array\ArrayOfFeeEvent $feeEvents
     */
    public function __construct($feeID = null, $isTaxable = null, $active = null, $amount = null, $name = null, $description = null, $feeEventName = null, $feeEventDescription = null, $chargeCode = null, \SGCIS\Array\ArrayOfFeeEvent $feeEvents = null)
    {
        $this
            ->setFeeID($feeID)
            ->setIsTaxable($isTaxable)
            ->setActive($active)
            ->setAmount($amount)
            ->setName($name)
            ->setDescription($description)
            ->setFeeEventName($feeEventName)
            ->setFeeEventDescription($feeEventDescription)
            ->setChargeCode($chargeCode)
            ->setFeeEvents($feeEvents);
    }
    /**
     * Get FeeID value
     * @return int
     */
    public function getFeeID()
    {
        return $this->FeeID;
    }
    /**
     * Set FeeID value
     * @param int $feeID
     * @return \SGCIS\Struct\AccountFee
     */
    public function setFeeID($feeID = null)
    {
        // validation for constraint: int
        if (!is_null($feeID) && !is_numeric($feeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($feeID)), __LINE__);
        }
        $this->FeeID = $feeID;
        return $this;
    }
    /**
     * Get IsTaxable value
     * @return bool
     */
    public function getIsTaxable()
    {
        return $this->IsTaxable;
    }
    /**
     * Set IsTaxable value
     * @param bool $isTaxable
     * @return \SGCIS\Struct\AccountFee
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTaxable)), __LINE__);
        }
        $this->IsTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\AccountFee
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SGCIS\Struct\AccountFee
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\AccountFee
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\AccountFee
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FeeEventName value
     * @return string|null
     */
    public function getFeeEventName()
    {
        return $this->FeeEventName;
    }
    /**
     * Set FeeEventName value
     * @param string $feeEventName
     * @return \SGCIS\Struct\AccountFee
     */
    public function setFeeEventName($feeEventName = null)
    {
        // validation for constraint: string
        if (!is_null($feeEventName) && !is_string($feeEventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeEventName)), __LINE__);
        }
        $this->FeeEventName = $feeEventName;
        return $this;
    }
    /**
     * Get FeeEventDescription value
     * @return string|null
     */
    public function getFeeEventDescription()
    {
        return $this->FeeEventDescription;
    }
    /**
     * Set FeeEventDescription value
     * @param string $feeEventDescription
     * @return \SGCIS\Struct\AccountFee
     */
    public function setFeeEventDescription($feeEventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($feeEventDescription) && !is_string($feeEventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeEventDescription)), __LINE__);
        }
        $this->FeeEventDescription = $feeEventDescription;
        return $this;
    }
    /**
     * Get ChargeCode value
     * @return string|null
     */
    public function getChargeCode()
    {
        return $this->ChargeCode;
    }
    /**
     * Set ChargeCode value
     * @param string $chargeCode
     * @return \SGCIS\Struct\AccountFee
     */
    public function setChargeCode($chargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCode) && !is_string($chargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeCode)), __LINE__);
        }
        $this->ChargeCode = $chargeCode;
        return $this;
    }
    /**
     * Get FeeEvents value
     * @return \SGCIS\Array\ArrayOfFeeEvent|null
     */
    public function getFeeEvents()
    {
        return $this->FeeEvents;
    }
    /**
     * Set FeeEvents value
     * @param \SGCIS\Array\ArrayOfFeeEvent $feeEvents
     * @return \SGCIS\Struct\AccountFee
     */
    public function setFeeEvents(\SGCIS\Array\ArrayOfFeeEvent $feeEvents = null)
    {
        $this->FeeEvents = $feeEvents;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountFee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
