<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDocumentType Struct
 * @subpackage Structs
 */
class AccountDocumentType extends AbstractStructBase
{
    /**
     * The AccountDocumentTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountDocumentTypeID;
    /**
     * The EditDisabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EditDisabled;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for AccountDocumentType
     * @uses AccountDocumentType::setAccountDocumentTypeID()
     * @uses AccountDocumentType::setEditDisabled()
     * @uses AccountDocumentType::setName()
     * @param int $accountDocumentTypeID
     * @param bool $editDisabled
     * @param string $name
     */
    public function __construct($accountDocumentTypeID = null, $editDisabled = null, $name = null)
    {
        $this
            ->setAccountDocumentTypeID($accountDocumentTypeID)
            ->setEditDisabled($editDisabled)
            ->setName($name);
    }
    /**
     * Get AccountDocumentTypeID value
     * @return int
     */
    public function getAccountDocumentTypeID()
    {
        return $this->AccountDocumentTypeID;
    }
    /**
     * Set AccountDocumentTypeID value
     * @param int $accountDocumentTypeID
     * @return \SGCIS\Struct\AccountDocumentType
     */
    public function setAccountDocumentTypeID($accountDocumentTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountDocumentTypeID) && !is_numeric($accountDocumentTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountDocumentTypeID)), __LINE__);
        }
        $this->AccountDocumentTypeID = $accountDocumentTypeID;
        return $this;
    }
    /**
     * Get EditDisabled value
     * @return bool
     */
    public function getEditDisabled()
    {
        return $this->EditDisabled;
    }
    /**
     * Set EditDisabled value
     * @param bool $editDisabled
     * @return \SGCIS\Struct\AccountDocumentType
     */
    public function setEditDisabled($editDisabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($editDisabled) && !is_bool($editDisabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($editDisabled)), __LINE__);
        }
        $this->EditDisabled = $editDisabled;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\AccountDocumentType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountDocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
