<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDepositOption Struct
 * @subpackage Structs
 */
class AccountDepositOption extends AbstractStructBase
{
    /**
     * The CreateDeposit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CreateDeposit;
    /**
     * The CreateMaxDeposit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CreateMaxDeposit;
    /**
     * The WaiveDeposit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $WaiveDeposit;
    /**
     * The WaiveDepositConfirmed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $WaiveDepositConfirmed;
    /**
     * The DepositWaiverReasonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DepositWaiverReasonID;
    /**
     * The AccountDeposits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountDeposit
     */
    public $AccountDeposits;
    /**
     * Constructor method for AccountDepositOption
     * @uses AccountDepositOption::setCreateDeposit()
     * @uses AccountDepositOption::setCreateMaxDeposit()
     * @uses AccountDepositOption::setWaiveDeposit()
     * @uses AccountDepositOption::setWaiveDepositConfirmed()
     * @uses AccountDepositOption::setDepositWaiverReasonID()
     * @uses AccountDepositOption::setAccountDeposits()
     * @param bool $createDeposit
     * @param bool $createMaxDeposit
     * @param bool $waiveDeposit
     * @param bool $waiveDepositConfirmed
     * @param int $depositWaiverReasonID
     * @param \SGCIS\Array\ArrayOfAccountDeposit $accountDeposits
     */
    public function __construct($createDeposit = null, $createMaxDeposit = null, $waiveDeposit = null, $waiveDepositConfirmed = null, $depositWaiverReasonID = null, \SGCIS\Array\ArrayOfAccountDeposit $accountDeposits = null)
    {
        $this
            ->setCreateDeposit($createDeposit)
            ->setCreateMaxDeposit($createMaxDeposit)
            ->setWaiveDeposit($waiveDeposit)
            ->setWaiveDepositConfirmed($waiveDepositConfirmed)
            ->setDepositWaiverReasonID($depositWaiverReasonID)
            ->setAccountDeposits($accountDeposits);
    }
    /**
     * Get CreateDeposit value
     * @return bool
     */
    public function getCreateDeposit()
    {
        return $this->CreateDeposit;
    }
    /**
     * Set CreateDeposit value
     * @param bool $createDeposit
     * @return \SGCIS\Struct\AccountDepositOption
     */
    public function setCreateDeposit($createDeposit = null)
    {
        // validation for constraint: boolean
        if (!is_null($createDeposit) && !is_bool($createDeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($createDeposit)), __LINE__);
        }
        $this->CreateDeposit = $createDeposit;
        return $this;
    }
    /**
     * Get CreateMaxDeposit value
     * @return bool
     */
    public function getCreateMaxDeposit()
    {
        return $this->CreateMaxDeposit;
    }
    /**
     * Set CreateMaxDeposit value
     * @param bool $createMaxDeposit
     * @return \SGCIS\Struct\AccountDepositOption
     */
    public function setCreateMaxDeposit($createMaxDeposit = null)
    {
        // validation for constraint: boolean
        if (!is_null($createMaxDeposit) && !is_bool($createMaxDeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($createMaxDeposit)), __LINE__);
        }
        $this->CreateMaxDeposit = $createMaxDeposit;
        return $this;
    }
    /**
     * Get WaiveDeposit value
     * @return bool
     */
    public function getWaiveDeposit()
    {
        return $this->WaiveDeposit;
    }
    /**
     * Set WaiveDeposit value
     * @param bool $waiveDeposit
     * @return \SGCIS\Struct\AccountDepositOption
     */
    public function setWaiveDeposit($waiveDeposit = null)
    {
        // validation for constraint: boolean
        if (!is_null($waiveDeposit) && !is_bool($waiveDeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($waiveDeposit)), __LINE__);
        }
        $this->WaiveDeposit = $waiveDeposit;
        return $this;
    }
    /**
     * Get WaiveDepositConfirmed value
     * @return bool
     */
    public function getWaiveDepositConfirmed()
    {
        return $this->WaiveDepositConfirmed;
    }
    /**
     * Set WaiveDepositConfirmed value
     * @param bool $waiveDepositConfirmed
     * @return \SGCIS\Struct\AccountDepositOption
     */
    public function setWaiveDepositConfirmed($waiveDepositConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($waiveDepositConfirmed) && !is_bool($waiveDepositConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($waiveDepositConfirmed)), __LINE__);
        }
        $this->WaiveDepositConfirmed = $waiveDepositConfirmed;
        return $this;
    }
    /**
     * Get DepositWaiverReasonID value
     * @return int
     */
    public function getDepositWaiverReasonID()
    {
        return $this->DepositWaiverReasonID;
    }
    /**
     * Set DepositWaiverReasonID value
     * @param int $depositWaiverReasonID
     * @return \SGCIS\Struct\AccountDepositOption
     */
    public function setDepositWaiverReasonID($depositWaiverReasonID = null)
    {
        // validation for constraint: int
        if (!is_null($depositWaiverReasonID) && !is_numeric($depositWaiverReasonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($depositWaiverReasonID)), __LINE__);
        }
        $this->DepositWaiverReasonID = $depositWaiverReasonID;
        return $this;
    }
    /**
     * Get AccountDeposits value
     * @return \SGCIS\Array\ArrayOfAccountDeposit|null
     */
    public function getAccountDeposits()
    {
        return $this->AccountDeposits;
    }
    /**
     * Set AccountDeposits value
     * @param \SGCIS\Array\ArrayOfAccountDeposit $accountDeposits
     * @return \SGCIS\Struct\AccountDepositOption
     */
    public function setAccountDeposits(\SGCIS\Array\ArrayOfAccountDeposit $accountDeposits = null)
    {
        $this->AccountDeposits = $accountDeposits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountDepositOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
