<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountCustomFieldRequest Struct
 * @subpackage Structs
 */
class AccountCustomFieldRequest extends ServiceRequestBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountCustomFieldID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountCustomFieldID;
    /**
     * The AccountCustomFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountCustomField
     */
    public $AccountCustomFields;
    /**
     * The AccountCustomField
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountCustomField
     */
    public $AccountCustomField;
    /**
     * Constructor method for AccountCustomFieldRequest
     * @uses AccountCustomFieldRequest::setAccountID()
     * @uses AccountCustomFieldRequest::setAccountCustomFieldID()
     * @uses AccountCustomFieldRequest::setAccountCustomFields()
     * @uses AccountCustomFieldRequest::setAccountCustomField()
     * @param int $accountID
     * @param int $accountCustomFieldID
     * @param \SGCIS\Array\ArrayOfAccountCustomField $accountCustomFields
     * @param \SGCIS\Struct\AccountCustomField $accountCustomField
     */
    public function __construct($accountID = null, $accountCustomFieldID = null, \SGCIS\Array\ArrayOfAccountCustomField $accountCustomFields = null, \SGCIS\Struct\AccountCustomField $accountCustomField = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAccountCustomFieldID($accountCustomFieldID)
            ->setAccountCustomFields($accountCustomFields)
            ->setAccountCustomField($accountCustomField);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountCustomFieldRequest
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountCustomFieldID value
     * @return int
     */
    public function getAccountCustomFieldID()
    {
        return $this->AccountCustomFieldID;
    }
    /**
     * Set AccountCustomFieldID value
     * @param int $accountCustomFieldID
     * @return \SGCIS\Struct\AccountCustomFieldRequest
     */
    public function setAccountCustomFieldID($accountCustomFieldID = null)
    {
        // validation for constraint: int
        if (!is_null($accountCustomFieldID) && !is_numeric($accountCustomFieldID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountCustomFieldID)), __LINE__);
        }
        $this->AccountCustomFieldID = $accountCustomFieldID;
        return $this;
    }
    /**
     * Get AccountCustomFields value
     * @return \SGCIS\Array\ArrayOfAccountCustomField|null
     */
    public function getAccountCustomFields()
    {
        return $this->AccountCustomFields;
    }
    /**
     * Set AccountCustomFields value
     * @param \SGCIS\Array\ArrayOfAccountCustomField $accountCustomFields
     * @return \SGCIS\Struct\AccountCustomFieldRequest
     */
    public function setAccountCustomFields(\SGCIS\Array\ArrayOfAccountCustomField $accountCustomFields = null)
    {
        $this->AccountCustomFields = $accountCustomFields;
        return $this;
    }
    /**
     * Get AccountCustomField value
     * @return \SGCIS\Struct\AccountCustomField|null
     */
    public function getAccountCustomField()
    {
        return $this->AccountCustomField;
    }
    /**
     * Set AccountCustomField value
     * @param \SGCIS\Struct\AccountCustomField $accountCustomField
     * @return \SGCIS\Struct\AccountCustomFieldRequest
     */
    public function setAccountCustomField(\SGCIS\Struct\AccountCustomField $accountCustomField = null)
    {
        $this->AccountCustomField = $accountCustomField;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountCustomFieldRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
