<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountAddress Struct
 * @subpackage Structs
 */
class AccountAddress extends BaseDTO
{
    /**
     * The AccountAddressID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountAddressID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AddressTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AddressTypeID;
    /**
     * The CommunityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CommunityID;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The CommunityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommunityName;
    /**
     * Constructor method for AccountAddress
     * @uses AccountAddress::setAccountAddressID()
     * @uses AccountAddress::setAccountID()
     * @uses AccountAddress::setAddressTypeID()
     * @uses AccountAddress::setCommunityID()
     * @uses AccountAddress::setAddress1()
     * @uses AccountAddress::setAddress2()
     * @uses AccountAddress::setCity()
     * @uses AccountAddress::setState()
     * @uses AccountAddress::setPostalCode()
     * @uses AccountAddress::setCommunityName()
     * @param int $accountAddressID
     * @param int $accountID
     * @param int $addressTypeID
     * @param int $communityID
     * @param string $address1
     * @param string $address2
     * @param string $city
     * @param string $state
     * @param string $postalCode
     * @param string $communityName
     */
    public function __construct($accountAddressID = null, $accountID = null, $addressTypeID = null, $communityID = null, $address1 = null, $address2 = null, $city = null, $state = null, $postalCode = null, $communityName = null)
    {
        $this
            ->setAccountAddressID($accountAddressID)
            ->setAccountID($accountID)
            ->setAddressTypeID($addressTypeID)
            ->setCommunityID($communityID)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCity($city)
            ->setState($state)
            ->setPostalCode($postalCode)
            ->setCommunityName($communityName);
    }
    /**
     * Get AccountAddressID value
     * @return int
     */
    public function getAccountAddressID()
    {
        return $this->AccountAddressID;
    }
    /**
     * Set AccountAddressID value
     * @param int $accountAddressID
     * @return \SGCIS\Struct\AccountAddress
     */
    public function setAccountAddressID($accountAddressID = null)
    {
        // validation for constraint: int
        if (!is_null($accountAddressID) && !is_numeric($accountAddressID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountAddressID)), __LINE__);
        }
        $this->AccountAddressID = $accountAddressID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountAddress
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AddressTypeID value
     * @return int
     */
    public function getAddressTypeID()
    {
        return $this->AddressTypeID;
    }
    /**
     * Set AddressTypeID value
     * @param int $addressTypeID
     * @return \SGCIS\Struct\AccountAddress
     */
    public function setAddressTypeID($addressTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($addressTypeID) && !is_numeric($addressTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($addressTypeID)), __LINE__);
        }
        $this->AddressTypeID = $addressTypeID;
        return $this;
    }
    /**
     * Get CommunityID value
     * @return int
     */
    public function getCommunityID()
    {
        return $this->CommunityID;
    }
    /**
     * Set CommunityID value
     * @param int $communityID
     * @return \SGCIS\Struct\AccountAddress
     */
    public function setCommunityID($communityID = null)
    {
        // validation for constraint: int
        if (!is_null($communityID) && !is_numeric($communityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($communityID)), __LINE__);
        }
        $this->CommunityID = $communityID;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \SGCIS\Struct\AccountAddress
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \SGCIS\Struct\AccountAddress
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \SGCIS\Struct\AccountAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \SGCIS\Struct\AccountAddress
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \SGCIS\Struct\AccountAddress
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get CommunityName value
     * @return string|null
     */
    public function getCommunityName()
    {
        return $this->CommunityName;
    }
    /**
     * Set CommunityName value
     * @param string $communityName
     * @return \SGCIS\Struct\AccountAddress
     */
    public function setCommunityName($communityName = null)
    {
        // validation for constraint: string
        if (!is_null($communityName) && !is_string($communityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communityName)), __LINE__);
        }
        $this->CommunityName = $communityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
