<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountActivityRequest Struct
 * @subpackage Structs
 */
class AccountActivityRequest extends ServiceRequestBase
{
    /**
     * The AccountActivityTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountActivityTypeID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The PaymentSourceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentSourceID;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The RowNumberFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RowNumberFrom;
    /**
     * The RowNumberTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RowNumberTo;
    /**
     * The FromDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FromDate;
    /**
     * The ToDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ToDate;
    /**
     * The AccountActivityGroupTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountActivityGroupTypeID;
    /**
     * The TimeParameterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeParameterID;
    /**
     * The AccountCommunicationIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfInt
     */
    public $AccountCommunicationIDs;
    /**
     * Constructor method for AccountActivityRequest
     * @uses AccountActivityRequest::setAccountActivityTypeID()
     * @uses AccountActivityRequest::setAccountID()
     * @uses AccountActivityRequest::setPaymentSourceID()
     * @uses AccountActivityRequest::setUserID()
     * @uses AccountActivityRequest::setRowNumberFrom()
     * @uses AccountActivityRequest::setRowNumberTo()
     * @uses AccountActivityRequest::setFromDate()
     * @uses AccountActivityRequest::setToDate()
     * @uses AccountActivityRequest::setAccountActivityGroupTypeID()
     * @uses AccountActivityRequest::setTimeParameterID()
     * @uses AccountActivityRequest::setAccountCommunicationIDs()
     * @param int $accountActivityTypeID
     * @param int $accountID
     * @param int $paymentSourceID
     * @param int $userID
     * @param int $rowNumberFrom
     * @param int $rowNumberTo
     * @param string $fromDate
     * @param string $toDate
     * @param int $accountActivityGroupTypeID
     * @param string $timeParameterID
     * @param \SGCIS\Array\ArrayOfInt $accountCommunicationIDs
     */
    public function __construct($accountActivityTypeID = null, $accountID = null, $paymentSourceID = null, $userID = null, $rowNumberFrom = null, $rowNumberTo = null, $fromDate = null, $toDate = null, $accountActivityGroupTypeID = null, $timeParameterID = null, \SGCIS\Array\ArrayOfInt $accountCommunicationIDs = null)
    {
        $this
            ->setAccountActivityTypeID($accountActivityTypeID)
            ->setAccountID($accountID)
            ->setPaymentSourceID($paymentSourceID)
            ->setUserID($userID)
            ->setRowNumberFrom($rowNumberFrom)
            ->setRowNumberTo($rowNumberTo)
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setAccountActivityGroupTypeID($accountActivityGroupTypeID)
            ->setTimeParameterID($timeParameterID)
            ->setAccountCommunicationIDs($accountCommunicationIDs);
    }
    /**
     * Get AccountActivityTypeID value
     * @return int
     */
    public function getAccountActivityTypeID()
    {
        return $this->AccountActivityTypeID;
    }
    /**
     * Set AccountActivityTypeID value
     * @param int $accountActivityTypeID
     * @return \SGCIS\Struct\AccountActivityRequest
     */
    public function setAccountActivityTypeID($accountActivityTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountActivityTypeID) && !is_numeric($accountActivityTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountActivityTypeID)), __LINE__);
        }
        $this->AccountActivityTypeID = $accountActivityTypeID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountActivityRequest
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PaymentSourceID value
     * @return int
     */
    public function getPaymentSourceID()
    {
        return $this->PaymentSourceID;
    }
    /**
     * Set PaymentSourceID value
     * @param int $paymentSourceID
     * @return \SGCIS\Struct\AccountActivityRequest
     */
    public function setPaymentSourceID($paymentSourceID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentSourceID) && !is_numeric($paymentSourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentSourceID)), __LINE__);
        }
        $this->PaymentSourceID = $paymentSourceID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\AccountActivityRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get RowNumberFrom value
     * @return int
     */
    public function getRowNumberFrom()
    {
        return $this->RowNumberFrom;
    }
    /**
     * Set RowNumberFrom value
     * @param int $rowNumberFrom
     * @return \SGCIS\Struct\AccountActivityRequest
     */
    public function setRowNumberFrom($rowNumberFrom = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumberFrom) && !is_numeric($rowNumberFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rowNumberFrom)), __LINE__);
        }
        $this->RowNumberFrom = $rowNumberFrom;
        return $this;
    }
    /**
     * Get RowNumberTo value
     * @return int
     */
    public function getRowNumberTo()
    {
        return $this->RowNumberTo;
    }
    /**
     * Set RowNumberTo value
     * @param int $rowNumberTo
     * @return \SGCIS\Struct\AccountActivityRequest
     */
    public function setRowNumberTo($rowNumberTo = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumberTo) && !is_numeric($rowNumberTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rowNumberTo)), __LINE__);
        }
        $this->RowNumberTo = $rowNumberTo;
        return $this;
    }
    /**
     * Get FromDate value
     * @return string
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \SGCIS\Struct\AccountActivityRequest
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDate)), __LINE__);
        }
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \SGCIS\Struct\AccountActivityRequest
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDate)), __LINE__);
        }
        $this->ToDate = $toDate;
        return $this;
    }
    /**
     * Get AccountActivityGroupTypeID value
     * @return int
     */
    public function getAccountActivityGroupTypeID()
    {
        return $this->AccountActivityGroupTypeID;
    }
    /**
     * Set AccountActivityGroupTypeID value
     * @param int $accountActivityGroupTypeID
     * @return \SGCIS\Struct\AccountActivityRequest
     */
    public function setAccountActivityGroupTypeID($accountActivityGroupTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountActivityGroupTypeID) && !is_numeric($accountActivityGroupTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountActivityGroupTypeID)), __LINE__);
        }
        $this->AccountActivityGroupTypeID = $accountActivityGroupTypeID;
        return $this;
    }
    /**
     * Get TimeParameterID value
     * @return string|null
     */
    public function getTimeParameterID()
    {
        return $this->TimeParameterID;
    }
    /**
     * Set TimeParameterID value
     * @param string $timeParameterID
     * @return \SGCIS\Struct\AccountActivityRequest
     */
    public function setTimeParameterID($timeParameterID = null)
    {
        // validation for constraint: string
        if (!is_null($timeParameterID) && !is_string($timeParameterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeParameterID)), __LINE__);
        }
        $this->TimeParameterID = $timeParameterID;
        return $this;
    }
    /**
     * Get AccountCommunicationIDs value
     * @return \SGCIS\Array\ArrayOfInt|null
     */
    public function getAccountCommunicationIDs()
    {
        return $this->AccountCommunicationIDs;
    }
    /**
     * Set AccountCommunicationIDs value
     * @param \SGCIS\Array\ArrayOfInt $accountCommunicationIDs
     * @return \SGCIS\Struct\AccountActivityRequest
     */
    public function setAccountCommunicationIDs(\SGCIS\Array\ArrayOfInt $accountCommunicationIDs = null)
    {
        $this->AccountCommunicationIDs = $accountCommunicationIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountActivityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
