<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Account Struct
 * @subpackage Structs
 */
class Account extends BaseDTO
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountStatusID;
    /**
     * The AccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeID;
    /**
     * The AccountStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountStartDate;
    /**
     * The AccountEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountEndDate;
    /**
     * The AccountTerminationReasonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTerminationReasonID;
    /**
     * The AccountTermType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTermType;
    /**
     * The LanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LanguageID;
    /**
     * The NotificationChannelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NotificationChannelID;
    /**
     * The IsEnergyAssistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEnergyAssistance;
    /**
     * The IsWithinRescissionPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsWithinRescissionPeriod;
    /**
     * The EnrollmentExported
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EnrollmentExported;
    /**
     * The LeadSourceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LeadSourceID;
    /**
     * The IsMarketingOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMarketingOptIn;
    /**
     * The PaymentArrangementBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaymentArrangementBalance;
    /**
     * The BalanceAsOfDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BalanceAsOfDate;
    /**
     * The MinPaymentToReconnect
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MinPaymentToReconnect;
    /**
     * The SuggestedPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SuggestedPayment;
    /**
     * The SuggestedPaymentNoFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SuggestedPaymentNoFee;
    /**
     * The LeadTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LeadTypeID;
    /**
     * The BurnRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BurnRate;
    /**
     * The DisconnectCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DisconnectCount;
    /**
     * The HasAutoPaymentAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasAutoPaymentAccount;
    /**
     * The HasEnergyProgram
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasEnergyProgram;
    /**
     * The IsEnergyProgram
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEnergyProgram;
    /**
     * The HasPaymentArrangement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasPaymentArrangement;
    /**
     * The ReEnrollDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReEnrollDate;
    /**
     * The AddToReferralProgram
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AddToReferralProgram;
    /**
     * The IsOnReferralProgram
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOnReferralProgram;
    /**
     * The AddtoCampaign
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AddtoCampaign;
    /**
     * The SalesPersonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SalesPersonID;
    /**
     * The DisableAutoDisconnect
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DisableAutoDisconnect;
    /**
     * The DisableAutoReconnect
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DisableAutoReconnect;
    /**
     * The isError
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isError;
    /**
     * The IsBudgetBilling
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBudgetBilling;
    /**
     * The BudgetBillMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BudgetBillMonth;
    /**
     * The BudgetBillingStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BudgetBillingStartDate;
    /**
     * The AccountBillingTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountBillingTypeID;
    /**
     * The ManagerUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ManagerUserID;
    /**
     * The NextBillDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NextBillDate;
    /**
     * The IsNoPaymentPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNoPaymentPlan;
    /**
     * The IsPaymentPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPaymentPlan;
    /**
     * The IsCashOnly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCashOnly;
    /**
     * The IsVIP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVIP;
    /**
     * The NoLateFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NoLateFee;
    /**
     * The IsActivePledge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActivePledge;
    /**
     * The IsSwitchHoldBillPay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSwitchHoldBillPay;
    /**
     * The IsSwitchHoldTampering
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSwitchHoldTampering;
    /**
     * The IsWeatherMoratorium
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsWeatherMoratorium;
    /**
     * The IsDebtRecoveryDistributionMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDebtRecoveryDistributionMode;
    /**
     * The SendDailyNotification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SendDailyNotification;
    /**
     * The SkipSendMoveOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SkipSendMoveOut;
    /**
     * The IsPostalMailDocDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPostalMailDocDelivery;
    /**
     * The IsElectronicDocDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsElectronicDocDelivery;
    /**
     * The SecurityQuestionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SecurityQuestionID;
    /**
     * The ScheduledTerminationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ScheduledTerminationDate;
    /**
     * The IsNpVisaRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNpVisaRequest;
    /**
     * The IsPrimary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPrimary;
    /**
     * The AccountBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AccountBalance;
    /**
     * The DebtBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DebtBalance;
    /**
     * The BadDebt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BadDebt;
    /**
     * The DaysRemaining
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DaysRemaining;
    /**
     * The DebtBalancePA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DebtBalancePA;
    /**
     * The DebtBalanceDPP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DebtBalanceDPP;
    /**
     * The DefaultedBalanceDPP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DefaultedBalanceDPP;
    /**
     * The BillingFrequencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillingFrequencyID;
    /**
     * The BillCalculationMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillCalculationMethodID;
    /**
     * The BillingTriggerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillingTriggerID;
    /**
     * The BillingTriggerDaysOffset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillingTriggerDaysOffset;
    /**
     * The PaymentDayOfWeek
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentDayOfWeek;
    /**
     * The PaymentDayOfMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentDayOfMonth;
    /**
     * The DunningModelId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DunningModelId;
    /**
     * The HasBillConverted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasBillConverted;
    /**
     * The HasTransactionsConverted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasTransactionsConverted;
    /**
     * The IsNoPromoAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNoPromoAllowed;
    /**
     * The PastDueBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PastDueBalance;
    /**
     * The SendMessagingAllPersons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SendMessagingAllPersons;
    /**
     * The BillTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillTypeID;
    /**
     * The CompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CompanyID;
    /**
     * The CustomerTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerTypeID;
    /**
     * The AvailableBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AvailableBalance;
    /**
     * The DepositAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DepositAmount;
    /**
     * The DepositAmountOwed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DepositAmountOwed;
    /**
     * The PledgeAmountOwed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PledgeAmountOwed;
    /**
     * The DepositAmountHeld
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DepositAmountHeld;
    /**
     * The PreBillingBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PreBillingBalance;
    /**
     * The IsWaiveReconnectFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsWaiveReconnectFee;
    /**
     * The AmortizedReconciliationAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmortizedReconciliationAmount;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The LOANumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LOANumber;
    /**
     * The LeadSourceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LeadSourceName;
    /**
     * The EnrollmentError
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnrollmentError;
    /**
     * The LeadTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LeadTypeName;
    /**
     * The SalesAgentCompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesAgentCompanyName;
    /**
     * The Provider
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Provider;
    /**
     * The ConsumptionHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServicePointMeterRead
     */
    public $ConsumptionHistory;
    /**
     * The LastMeterReads
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfMeterRead
     */
    public $LastMeterReads;
    /**
     * The MeterStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterStatus;
    /**
     * The AccountServicePointIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfInt
     */
    public $AccountServicePointIDs;
    /**
     * The AccountFlags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountFlags;
    /**
     * The AccountAccountFlags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountAccountFlag
     */
    public $AccountAccountFlags;
    /**
     * The LegacyCreatedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LegacyCreatedBy;
    /**
     * The LegacyAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LegacyAccountNumber;
    /**
     * The MonthlyBillingCycleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MonthlyBillingCycleID;
    /**
     * The MeterStatusColor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterStatusColor;
    /**
     * The SalesForceLeadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesForceLeadID;
    /**
     * The AccountsPrimaryPersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountsPrimaryPersonName;
    /**
     * The AccountsPrimaryPersonPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountsPrimaryPersonPhone;
    /**
     * The SecurityQuestionText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecurityQuestionText;
    /**
     * The SecurityQuestionAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecurityQuestionAnswer;
    /**
     * The AccountStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountStatusName;
    /**
     * The AccountTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountTypeName;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonName;
    /**
     * The FullAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FullAddress;
    /**
     * The NotificationChannelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotificationChannelName;
    /**
     * The LanguageName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LanguageName;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Source;
    /**
     * The PromotionCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PromotionCode;
    /**
     * The BillCalculationMethodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillCalculationMethodName;
    /**
     * The AgentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentID;
    /**
     * The ThirdPartyVerificationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ThirdPartyVerificationCode;
    /**
     * The LegacySystem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LegacySystem;
    /**
     * The EnrollmentIPAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnrollmentIPAddress;
    /**
     * The AccountStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountStatus
     */
    public $AccountStatus;
    /**
     * The AccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountType
     */
    public $AccountType;
    /**
     * The NotificationChannel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\NotificationChannel
     */
    public $NotificationChannel;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Language
     */
    public $Language;
    /**
     * The AccountAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountAddress
     */
    public $AccountAddress;
    /**
     * The AccountTerminationReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountTerminationReason
     */
    public $AccountTerminationReason;
    /**
     * The AutoPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountAutoPay
     */
    public $AutoPayment;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Product
     */
    public $Product;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProduct
     */
    public $Products;
    /**
     * The SnapshotARReport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\SnapshotARReport
     */
    public $SnapshotARReport;
    /**
     * The Persons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPerson
     */
    public $Persons;
    /**
     * The AccountPersons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountPerson
     */
    public $AccountPersons;
    /**
     * The DistributionPoints
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfDistributionPoint
     */
    public $DistributionPoints;
    /**
     * The AccountNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountNote
     */
    public $AccountNotes;
    /**
     * The ServicePoints
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServicePoint
     */
    public $ServicePoints;
    /**
     * The AccountServicePoints
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountServicePoint
     */
    public $AccountServicePoints;
    /**
     * The PaymentAccounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPaymentAccount
     */
    public $PaymentAccounts;
    /**
     * The AccountTransactions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountTransaction
     */
    public $AccountTransactions;
    /**
     * The PaymentArrangements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPaymentArrangement
     */
    public $PaymentArrangements;
    /**
     * The ServiceOrders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServiceOrder
     */
    public $ServiceOrders;
    /**
     * The AccountAutoPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountAutoPay
     */
    public $AccountAutoPayments;
    /**
     * The Tickets
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTicket
     */
    public $Tickets;
    /**
     * The AccountCommunications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountCommunication
     */
    public $AccountCommunications;
    /**
     * The AccountDocuments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountDocument
     */
    public $AccountDocuments;
    /**
     * The AccountHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountStatusHistory
     */
    public $AccountHistory;
    /**
     * The AuditLog
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAuditLog
     */
    public $AuditLog;
    /**
     * The TransactionSummaryItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTransactionSummaryItem
     */
    public $TransactionSummaryItems;
    /**
     * The AccountDepositOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountDepositOption
     */
    public $AccountDepositOption;
    /**
     * The BillHeaders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillHeader
     */
    public $BillHeaders;
    /**
     * The BillDeliveryMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillDeliveryMethod
     */
    public $BillDeliveryMethod;
    /**
     * The AccountCustomFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountCustomField
     */
    public $AccountCustomFields;
    /**
     * The MonthlyBillingCycle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\MonthlyBillingCycle
     */
    public $MonthlyBillingCycle;
    /**
     * The LastPaymentTransaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountTransaction
     */
    public $LastPaymentTransaction;
    /**
     * Constructor method for Account
     * @uses Account::setActive()
     * @uses Account::setAccountID()
     * @uses Account::setAccountStatusID()
     * @uses Account::setAccountTypeID()
     * @uses Account::setAccountStartDate()
     * @uses Account::setAccountEndDate()
     * @uses Account::setAccountTerminationReasonID()
     * @uses Account::setAccountTermType()
     * @uses Account::setLanguageID()
     * @uses Account::setNotificationChannelID()
     * @uses Account::setIsEnergyAssistance()
     * @uses Account::setIsWithinRescissionPeriod()
     * @uses Account::setEnrollmentExported()
     * @uses Account::setLeadSourceID()
     * @uses Account::setIsMarketingOptIn()
     * @uses Account::setPaymentArrangementBalance()
     * @uses Account::setBalanceAsOfDate()
     * @uses Account::setMinPaymentToReconnect()
     * @uses Account::setSuggestedPayment()
     * @uses Account::setSuggestedPaymentNoFee()
     * @uses Account::setLeadTypeID()
     * @uses Account::setBurnRate()
     * @uses Account::setDisconnectCount()
     * @uses Account::setHasAutoPaymentAccount()
     * @uses Account::setHasEnergyProgram()
     * @uses Account::setIsEnergyProgram()
     * @uses Account::setHasPaymentArrangement()
     * @uses Account::setReEnrollDate()
     * @uses Account::setAddToReferralProgram()
     * @uses Account::setIsOnReferralProgram()
     * @uses Account::setAddtoCampaign()
     * @uses Account::setSalesPersonID()
     * @uses Account::setDisableAutoDisconnect()
     * @uses Account::setDisableAutoReconnect()
     * @uses Account::setIsError()
     * @uses Account::setIsBudgetBilling()
     * @uses Account::setBudgetBillMonth()
     * @uses Account::setBudgetBillingStartDate()
     * @uses Account::setAccountBillingTypeID()
     * @uses Account::setManagerUserID()
     * @uses Account::setNextBillDate()
     * @uses Account::setIsNoPaymentPlan()
     * @uses Account::setIsPaymentPlan()
     * @uses Account::setIsCashOnly()
     * @uses Account::setIsVIP()
     * @uses Account::setNoLateFee()
     * @uses Account::setIsActivePledge()
     * @uses Account::setIsSwitchHoldBillPay()
     * @uses Account::setIsSwitchHoldTampering()
     * @uses Account::setIsWeatherMoratorium()
     * @uses Account::setIsDebtRecoveryDistributionMode()
     * @uses Account::setSendDailyNotification()
     * @uses Account::setSkipSendMoveOut()
     * @uses Account::setIsPostalMailDocDelivery()
     * @uses Account::setIsElectronicDocDelivery()
     * @uses Account::setSecurityQuestionID()
     * @uses Account::setScheduledTerminationDate()
     * @uses Account::setIsNpVisaRequest()
     * @uses Account::setIsPrimary()
     * @uses Account::setAccountBalance()
     * @uses Account::setDebtBalance()
     * @uses Account::setBadDebt()
     * @uses Account::setDaysRemaining()
     * @uses Account::setDebtBalancePA()
     * @uses Account::setDebtBalanceDPP()
     * @uses Account::setDefaultedBalanceDPP()
     * @uses Account::setBillingFrequencyID()
     * @uses Account::setBillCalculationMethodID()
     * @uses Account::setBillingTriggerID()
     * @uses Account::setBillingTriggerDaysOffset()
     * @uses Account::setPaymentDayOfWeek()
     * @uses Account::setPaymentDayOfMonth()
     * @uses Account::setDunningModelId()
     * @uses Account::setHasBillConverted()
     * @uses Account::setHasTransactionsConverted()
     * @uses Account::setIsNoPromoAllowed()
     * @uses Account::setPastDueBalance()
     * @uses Account::setSendMessagingAllPersons()
     * @uses Account::setBillTypeID()
     * @uses Account::setCompanyID()
     * @uses Account::setCustomerTypeID()
     * @uses Account::setAvailableBalance()
     * @uses Account::setDepositAmount()
     * @uses Account::setDepositAmountOwed()
     * @uses Account::setPledgeAmountOwed()
     * @uses Account::setDepositAmountHeld()
     * @uses Account::setPreBillingBalance()
     * @uses Account::setIsWaiveReconnectFee()
     * @uses Account::setAmortizedReconciliationAmount()
     * @uses Account::setAccountNumber()
     * @uses Account::setLOANumber()
     * @uses Account::setLeadSourceName()
     * @uses Account::setEnrollmentError()
     * @uses Account::setLeadTypeName()
     * @uses Account::setSalesAgentCompanyName()
     * @uses Account::setProvider()
     * @uses Account::setConsumptionHistory()
     * @uses Account::setLastMeterReads()
     * @uses Account::setMeterStatus()
     * @uses Account::setAccountServicePointIDs()
     * @uses Account::setAccountFlags()
     * @uses Account::setAccountAccountFlags()
     * @uses Account::setLegacyCreatedBy()
     * @uses Account::setLegacyAccountNumber()
     * @uses Account::setMonthlyBillingCycleID()
     * @uses Account::setMeterStatusColor()
     * @uses Account::setSalesForceLeadID()
     * @uses Account::setAccountsPrimaryPersonName()
     * @uses Account::setAccountsPrimaryPersonPhone()
     * @uses Account::setSecurityQuestionText()
     * @uses Account::setSecurityQuestionAnswer()
     * @uses Account::setAccountStatusName()
     * @uses Account::setAccountTypeName()
     * @uses Account::setPersonName()
     * @uses Account::setFullAddress()
     * @uses Account::setNotificationChannelName()
     * @uses Account::setLanguageName()
     * @uses Account::setProductName()
     * @uses Account::setSource()
     * @uses Account::setPromotionCode()
     * @uses Account::setBillCalculationMethodName()
     * @uses Account::setAgentID()
     * @uses Account::setThirdPartyVerificationCode()
     * @uses Account::setLegacySystem()
     * @uses Account::setEnrollmentIPAddress()
     * @uses Account::setAccountStatus()
     * @uses Account::setAccountType()
     * @uses Account::setNotificationChannel()
     * @uses Account::setLanguage()
     * @uses Account::setAccountAddress()
     * @uses Account::setAccountTerminationReason()
     * @uses Account::setAutoPayment()
     * @uses Account::setProduct()
     * @uses Account::setProducts()
     * @uses Account::setSnapshotARReport()
     * @uses Account::setPersons()
     * @uses Account::setAccountPersons()
     * @uses Account::setDistributionPoints()
     * @uses Account::setAccountNotes()
     * @uses Account::setServicePoints()
     * @uses Account::setAccountServicePoints()
     * @uses Account::setPaymentAccounts()
     * @uses Account::setAccountTransactions()
     * @uses Account::setPaymentArrangements()
     * @uses Account::setServiceOrders()
     * @uses Account::setAccountAutoPayments()
     * @uses Account::setTickets()
     * @uses Account::setAccountCommunications()
     * @uses Account::setAccountDocuments()
     * @uses Account::setAccountHistory()
     * @uses Account::setAuditLog()
     * @uses Account::setTransactionSummaryItems()
     * @uses Account::setAccountDepositOption()
     * @uses Account::setBillHeaders()
     * @uses Account::setBillDeliveryMethod()
     * @uses Account::setAccountCustomFields()
     * @uses Account::setMonthlyBillingCycle()
     * @uses Account::setLastPaymentTransaction()
     * @param bool $active
     * @param int $accountID
     * @param int $accountStatusID
     * @param int $accountTypeID
     * @param string $accountStartDate
     * @param string $accountEndDate
     * @param int $accountTerminationReasonID
     * @param int $accountTermType
     * @param int $languageID
     * @param int $notificationChannelID
     * @param bool $isEnergyAssistance
     * @param bool $isWithinRescissionPeriod
     * @param bool $enrollmentExported
     * @param int $leadSourceID
     * @param bool $isMarketingOptIn
     * @param float $paymentArrangementBalance
     * @param string $balanceAsOfDate
     * @param float $minPaymentToReconnect
     * @param float $suggestedPayment
     * @param float $suggestedPaymentNoFee
     * @param int $leadTypeID
     * @param float $burnRate
     * @param int $disconnectCount
     * @param bool $hasAutoPaymentAccount
     * @param bool $hasEnergyProgram
     * @param bool $isEnergyProgram
     * @param bool $hasPaymentArrangement
     * @param string $reEnrollDate
     * @param bool $addToReferralProgram
     * @param bool $isOnReferralProgram
     * @param bool $addtoCampaign
     * @param int $salesPersonID
     * @param bool $disableAutoDisconnect
     * @param bool $disableAutoReconnect
     * @param bool $isError
     * @param bool $isBudgetBilling
     * @param int $budgetBillMonth
     * @param string $budgetBillingStartDate
     * @param int $accountBillingTypeID
     * @param int $managerUserID
     * @param string $nextBillDate
     * @param bool $isNoPaymentPlan
     * @param bool $isPaymentPlan
     * @param bool $isCashOnly
     * @param bool $isVIP
     * @param bool $noLateFee
     * @param bool $isActivePledge
     * @param bool $isSwitchHoldBillPay
     * @param bool $isSwitchHoldTampering
     * @param bool $isWeatherMoratorium
     * @param bool $isDebtRecoveryDistributionMode
     * @param bool $sendDailyNotification
     * @param bool $skipSendMoveOut
     * @param bool $isPostalMailDocDelivery
     * @param bool $isElectronicDocDelivery
     * @param int $securityQuestionID
     * @param string $scheduledTerminationDate
     * @param bool $isNpVisaRequest
     * @param bool $isPrimary
     * @param float $accountBalance
     * @param float $debtBalance
     * @param float $badDebt
     * @param float $daysRemaining
     * @param float $debtBalancePA
     * @param float $debtBalanceDPP
     * @param float $defaultedBalanceDPP
     * @param int $billingFrequencyID
     * @param int $billCalculationMethodID
     * @param int $billingTriggerID
     * @param int $billingTriggerDaysOffset
     * @param int $paymentDayOfWeek
     * @param int $paymentDayOfMonth
     * @param int $dunningModelId
     * @param bool $hasBillConverted
     * @param bool $hasTransactionsConverted
     * @param bool $isNoPromoAllowed
     * @param float $pastDueBalance
     * @param bool $sendMessagingAllPersons
     * @param int $billTypeID
     * @param int $companyID
     * @param int $customerTypeID
     * @param float $availableBalance
     * @param float $depositAmount
     * @param float $depositAmountOwed
     * @param float $pledgeAmountOwed
     * @param float $depositAmountHeld
     * @param float $preBillingBalance
     * @param bool $isWaiveReconnectFee
     * @param float $amortizedReconciliationAmount
     * @param string $accountNumber
     * @param string $lOANumber
     * @param string $leadSourceName
     * @param string $enrollmentError
     * @param string $leadTypeName
     * @param string $salesAgentCompanyName
     * @param string $provider
     * @param \SGCIS\Array\ArrayOfServicePointMeterRead $consumptionHistory
     * @param \SGCIS\Array\ArrayOfMeterRead $lastMeterReads
     * @param string $meterStatus
     * @param \SGCIS\Array\ArrayOfInt $accountServicePointIDs
     * @param string $accountFlags
     * @param \SGCIS\Array\ArrayOfAccountAccountFlag $accountAccountFlags
     * @param string $legacyCreatedBy
     * @param string $legacyAccountNumber
     * @param string $monthlyBillingCycleID
     * @param string $meterStatusColor
     * @param string $salesForceLeadID
     * @param string $accountsPrimaryPersonName
     * @param string $accountsPrimaryPersonPhone
     * @param string $securityQuestionText
     * @param string $securityQuestionAnswer
     * @param string $accountStatusName
     * @param string $accountTypeName
     * @param string $personName
     * @param string $fullAddress
     * @param string $notificationChannelName
     * @param string $languageName
     * @param string $productName
     * @param string $source
     * @param string $promotionCode
     * @param string $billCalculationMethodName
     * @param string $agentID
     * @param string $thirdPartyVerificationCode
     * @param string $legacySystem
     * @param string $enrollmentIPAddress
     * @param \SGCIS\Struct\AccountStatus $accountStatus
     * @param \SGCIS\Struct\AccountType $accountType
     * @param \SGCIS\Struct\NotificationChannel $notificationChannel
     * @param \SGCIS\Struct\Language $language
     * @param \SGCIS\Struct\AccountAddress $accountAddress
     * @param \SGCIS\Struct\AccountTerminationReason $accountTerminationReason
     * @param \SGCIS\Struct\AccountAutoPay $autoPayment
     * @param \SGCIS\Struct\Product $product
     * @param \SGCIS\Array\ArrayOfProduct $products
     * @param \SGCIS\Struct\SnapshotARReport $snapshotARReport
     * @param \SGCIS\Array\ArrayOfPerson $persons
     * @param \SGCIS\Array\ArrayOfAccountPerson $accountPersons
     * @param \SGCIS\Array\ArrayOfDistributionPoint $distributionPoints
     * @param \SGCIS\Array\ArrayOfAccountNote $accountNotes
     * @param \SGCIS\Array\ArrayOfServicePoint $servicePoints
     * @param \SGCIS\Array\ArrayOfAccountServicePoint $accountServicePoints
     * @param \SGCIS\Array\ArrayOfPaymentAccount $paymentAccounts
     * @param \SGCIS\Array\ArrayOfAccountTransaction $accountTransactions
     * @param \SGCIS\Array\ArrayOfPaymentArrangement $paymentArrangements
     * @param \SGCIS\Array\ArrayOfServiceOrder $serviceOrders
     * @param \SGCIS\Array\ArrayOfAccountAutoPay $accountAutoPayments
     * @param \SGCIS\Array\ArrayOfTicket $tickets
     * @param \SGCIS\Array\ArrayOfAccountCommunication $accountCommunications
     * @param \SGCIS\Array\ArrayOfAccountDocument $accountDocuments
     * @param \SGCIS\Array\ArrayOfAccountStatusHistory $accountHistory
     * @param \SGCIS\Array\ArrayOfAuditLog $auditLog
     * @param \SGCIS\Array\ArrayOfTransactionSummaryItem $transactionSummaryItems
     * @param \SGCIS\Struct\AccountDepositOption $accountDepositOption
     * @param \SGCIS\Array\ArrayOfBillHeader $billHeaders
     * @param \SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethod
     * @param \SGCIS\Array\ArrayOfAccountCustomField $accountCustomFields
     * @param \SGCIS\Struct\MonthlyBillingCycle $monthlyBillingCycle
     * @param \SGCIS\Struct\AccountTransaction $lastPaymentTransaction
     */
    public function __construct($active = null, $accountID = null, $accountStatusID = null, $accountTypeID = null, $accountStartDate = null, $accountEndDate = null, $accountTerminationReasonID = null, $accountTermType = null, $languageID = null, $notificationChannelID = null, $isEnergyAssistance = null, $isWithinRescissionPeriod = null, $enrollmentExported = null, $leadSourceID = null, $isMarketingOptIn = null, $paymentArrangementBalance = null, $balanceAsOfDate = null, $minPaymentToReconnect = null, $suggestedPayment = null, $suggestedPaymentNoFee = null, $leadTypeID = null, $burnRate = null, $disconnectCount = null, $hasAutoPaymentAccount = null, $hasEnergyProgram = null, $isEnergyProgram = null, $hasPaymentArrangement = null, $reEnrollDate = null, $addToReferralProgram = null, $isOnReferralProgram = null, $addtoCampaign = null, $salesPersonID = null, $disableAutoDisconnect = null, $disableAutoReconnect = null, $isError = null, $isBudgetBilling = null, $budgetBillMonth = null, $budgetBillingStartDate = null, $accountBillingTypeID = null, $managerUserID = null, $nextBillDate = null, $isNoPaymentPlan = null, $isPaymentPlan = null, $isCashOnly = null, $isVIP = null, $noLateFee = null, $isActivePledge = null, $isSwitchHoldBillPay = null, $isSwitchHoldTampering = null, $isWeatherMoratorium = null, $isDebtRecoveryDistributionMode = null, $sendDailyNotification = null, $skipSendMoveOut = null, $isPostalMailDocDelivery = null, $isElectronicDocDelivery = null, $securityQuestionID = null, $scheduledTerminationDate = null, $isNpVisaRequest = null, $isPrimary = null, $accountBalance = null, $debtBalance = null, $badDebt = null, $daysRemaining = null, $debtBalancePA = null, $debtBalanceDPP = null, $defaultedBalanceDPP = null, $billingFrequencyID = null, $billCalculationMethodID = null, $billingTriggerID = null, $billingTriggerDaysOffset = null, $paymentDayOfWeek = null, $paymentDayOfMonth = null, $dunningModelId = null, $hasBillConverted = null, $hasTransactionsConverted = null, $isNoPromoAllowed = null, $pastDueBalance = null, $sendMessagingAllPersons = null, $billTypeID = null, $companyID = null, $customerTypeID = null, $availableBalance = null, $depositAmount = null, $depositAmountOwed = null, $pledgeAmountOwed = null, $depositAmountHeld = null, $preBillingBalance = null, $isWaiveReconnectFee = null, $amortizedReconciliationAmount = null, $accountNumber = null, $lOANumber = null, $leadSourceName = null, $enrollmentError = null, $leadTypeName = null, $salesAgentCompanyName = null, $provider = null, \SGCIS\Array\ArrayOfServicePointMeterRead $consumptionHistory = null, \SGCIS\Array\ArrayOfMeterRead $lastMeterReads = null, $meterStatus = null, \SGCIS\Array\ArrayOfInt $accountServicePointIDs = null, $accountFlags = null, \SGCIS\Array\ArrayOfAccountAccountFlag $accountAccountFlags = null, $legacyCreatedBy = null, $legacyAccountNumber = null, $monthlyBillingCycleID = null, $meterStatusColor = null, $salesForceLeadID = null, $accountsPrimaryPersonName = null, $accountsPrimaryPersonPhone = null, $securityQuestionText = null, $securityQuestionAnswer = null, $accountStatusName = null, $accountTypeName = null, $personName = null, $fullAddress = null, $notificationChannelName = null, $languageName = null, $productName = null, $source = null, $promotionCode = null, $billCalculationMethodName = null, $agentID = null, $thirdPartyVerificationCode = null, $legacySystem = null, $enrollmentIPAddress = null, \SGCIS\Struct\AccountStatus $accountStatus = null, \SGCIS\Struct\AccountType $accountType = null, \SGCIS\Struct\NotificationChannel $notificationChannel = null, \SGCIS\Struct\Language $language = null, \SGCIS\Struct\AccountAddress $accountAddress = null, \SGCIS\Struct\AccountTerminationReason $accountTerminationReason = null, \SGCIS\Struct\AccountAutoPay $autoPayment = null, \SGCIS\Struct\Product $product = null, \SGCIS\Array\ArrayOfProduct $products = null, \SGCIS\Struct\SnapshotARReport $snapshotARReport = null, \SGCIS\Array\ArrayOfPerson $persons = null, \SGCIS\Array\ArrayOfAccountPerson $accountPersons = null, \SGCIS\Array\ArrayOfDistributionPoint $distributionPoints = null, \SGCIS\Array\ArrayOfAccountNote $accountNotes = null, \SGCIS\Array\ArrayOfServicePoint $servicePoints = null, \SGCIS\Array\ArrayOfAccountServicePoint $accountServicePoints = null, \SGCIS\Array\ArrayOfPaymentAccount $paymentAccounts = null, \SGCIS\Array\ArrayOfAccountTransaction $accountTransactions = null, \SGCIS\Array\ArrayOfPaymentArrangement $paymentArrangements = null, \SGCIS\Array\ArrayOfServiceOrder $serviceOrders = null, \SGCIS\Array\ArrayOfAccountAutoPay $accountAutoPayments = null, \SGCIS\Array\ArrayOfTicket $tickets = null, \SGCIS\Array\ArrayOfAccountCommunication $accountCommunications = null, \SGCIS\Array\ArrayOfAccountDocument $accountDocuments = null, \SGCIS\Array\ArrayOfAccountStatusHistory $accountHistory = null, \SGCIS\Array\ArrayOfAuditLog $auditLog = null, \SGCIS\Array\ArrayOfTransactionSummaryItem $transactionSummaryItems = null, \SGCIS\Struct\AccountDepositOption $accountDepositOption = null, \SGCIS\Array\ArrayOfBillHeader $billHeaders = null, \SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethod = null, \SGCIS\Array\ArrayOfAccountCustomField $accountCustomFields = null, \SGCIS\Struct\MonthlyBillingCycle $monthlyBillingCycle = null, \SGCIS\Struct\AccountTransaction $lastPaymentTransaction = null)
    {
        $this
            ->setActive($active)
            ->setAccountID($accountID)
            ->setAccountStatusID($accountStatusID)
            ->setAccountTypeID($accountTypeID)
            ->setAccountStartDate($accountStartDate)
            ->setAccountEndDate($accountEndDate)
            ->setAccountTerminationReasonID($accountTerminationReasonID)
            ->setAccountTermType($accountTermType)
            ->setLanguageID($languageID)
            ->setNotificationChannelID($notificationChannelID)
            ->setIsEnergyAssistance($isEnergyAssistance)
            ->setIsWithinRescissionPeriod($isWithinRescissionPeriod)
            ->setEnrollmentExported($enrollmentExported)
            ->setLeadSourceID($leadSourceID)
            ->setIsMarketingOptIn($isMarketingOptIn)
            ->setPaymentArrangementBalance($paymentArrangementBalance)
            ->setBalanceAsOfDate($balanceAsOfDate)
            ->setMinPaymentToReconnect($minPaymentToReconnect)
            ->setSuggestedPayment($suggestedPayment)
            ->setSuggestedPaymentNoFee($suggestedPaymentNoFee)
            ->setLeadTypeID($leadTypeID)
            ->setBurnRate($burnRate)
            ->setDisconnectCount($disconnectCount)
            ->setHasAutoPaymentAccount($hasAutoPaymentAccount)
            ->setHasEnergyProgram($hasEnergyProgram)
            ->setIsEnergyProgram($isEnergyProgram)
            ->setHasPaymentArrangement($hasPaymentArrangement)
            ->setReEnrollDate($reEnrollDate)
            ->setAddToReferralProgram($addToReferralProgram)
            ->setIsOnReferralProgram($isOnReferralProgram)
            ->setAddtoCampaign($addtoCampaign)
            ->setSalesPersonID($salesPersonID)
            ->setDisableAutoDisconnect($disableAutoDisconnect)
            ->setDisableAutoReconnect($disableAutoReconnect)
            ->setIsError($isError)
            ->setIsBudgetBilling($isBudgetBilling)
            ->setBudgetBillMonth($budgetBillMonth)
            ->setBudgetBillingStartDate($budgetBillingStartDate)
            ->setAccountBillingTypeID($accountBillingTypeID)
            ->setManagerUserID($managerUserID)
            ->setNextBillDate($nextBillDate)
            ->setIsNoPaymentPlan($isNoPaymentPlan)
            ->setIsPaymentPlan($isPaymentPlan)
            ->setIsCashOnly($isCashOnly)
            ->setIsVIP($isVIP)
            ->setNoLateFee($noLateFee)
            ->setIsActivePledge($isActivePledge)
            ->setIsSwitchHoldBillPay($isSwitchHoldBillPay)
            ->setIsSwitchHoldTampering($isSwitchHoldTampering)
            ->setIsWeatherMoratorium($isWeatherMoratorium)
            ->setIsDebtRecoveryDistributionMode($isDebtRecoveryDistributionMode)
            ->setSendDailyNotification($sendDailyNotification)
            ->setSkipSendMoveOut($skipSendMoveOut)
            ->setIsPostalMailDocDelivery($isPostalMailDocDelivery)
            ->setIsElectronicDocDelivery($isElectronicDocDelivery)
            ->setSecurityQuestionID($securityQuestionID)
            ->setScheduledTerminationDate($scheduledTerminationDate)
            ->setIsNpVisaRequest($isNpVisaRequest)
            ->setIsPrimary($isPrimary)
            ->setAccountBalance($accountBalance)
            ->setDebtBalance($debtBalance)
            ->setBadDebt($badDebt)
            ->setDaysRemaining($daysRemaining)
            ->setDebtBalancePA($debtBalancePA)
            ->setDebtBalanceDPP($debtBalanceDPP)
            ->setDefaultedBalanceDPP($defaultedBalanceDPP)
            ->setBillingFrequencyID($billingFrequencyID)
            ->setBillCalculationMethodID($billCalculationMethodID)
            ->setBillingTriggerID($billingTriggerID)
            ->setBillingTriggerDaysOffset($billingTriggerDaysOffset)
            ->setPaymentDayOfWeek($paymentDayOfWeek)
            ->setPaymentDayOfMonth($paymentDayOfMonth)
            ->setDunningModelId($dunningModelId)
            ->setHasBillConverted($hasBillConverted)
            ->setHasTransactionsConverted($hasTransactionsConverted)
            ->setIsNoPromoAllowed($isNoPromoAllowed)
            ->setPastDueBalance($pastDueBalance)
            ->setSendMessagingAllPersons($sendMessagingAllPersons)
            ->setBillTypeID($billTypeID)
            ->setCompanyID($companyID)
            ->setCustomerTypeID($customerTypeID)
            ->setAvailableBalance($availableBalance)
            ->setDepositAmount($depositAmount)
            ->setDepositAmountOwed($depositAmountOwed)
            ->setPledgeAmountOwed($pledgeAmountOwed)
            ->setDepositAmountHeld($depositAmountHeld)
            ->setPreBillingBalance($preBillingBalance)
            ->setIsWaiveReconnectFee($isWaiveReconnectFee)
            ->setAmortizedReconciliationAmount($amortizedReconciliationAmount)
            ->setAccountNumber($accountNumber)
            ->setLOANumber($lOANumber)
            ->setLeadSourceName($leadSourceName)
            ->setEnrollmentError($enrollmentError)
            ->setLeadTypeName($leadTypeName)
            ->setSalesAgentCompanyName($salesAgentCompanyName)
            ->setProvider($provider)
            ->setConsumptionHistory($consumptionHistory)
            ->setLastMeterReads($lastMeterReads)
            ->setMeterStatus($meterStatus)
            ->setAccountServicePointIDs($accountServicePointIDs)
            ->setAccountFlags($accountFlags)
            ->setAccountAccountFlags($accountAccountFlags)
            ->setLegacyCreatedBy($legacyCreatedBy)
            ->setLegacyAccountNumber($legacyAccountNumber)
            ->setMonthlyBillingCycleID($monthlyBillingCycleID)
            ->setMeterStatusColor($meterStatusColor)
            ->setSalesForceLeadID($salesForceLeadID)
            ->setAccountsPrimaryPersonName($accountsPrimaryPersonName)
            ->setAccountsPrimaryPersonPhone($accountsPrimaryPersonPhone)
            ->setSecurityQuestionText($securityQuestionText)
            ->setSecurityQuestionAnswer($securityQuestionAnswer)
            ->setAccountStatusName($accountStatusName)
            ->setAccountTypeName($accountTypeName)
            ->setPersonName($personName)
            ->setFullAddress($fullAddress)
            ->setNotificationChannelName($notificationChannelName)
            ->setLanguageName($languageName)
            ->setProductName($productName)
            ->setSource($source)
            ->setPromotionCode($promotionCode)
            ->setBillCalculationMethodName($billCalculationMethodName)
            ->setAgentID($agentID)
            ->setThirdPartyVerificationCode($thirdPartyVerificationCode)
            ->setLegacySystem($legacySystem)
            ->setEnrollmentIPAddress($enrollmentIPAddress)
            ->setAccountStatus($accountStatus)
            ->setAccountType($accountType)
            ->setNotificationChannel($notificationChannel)
            ->setLanguage($language)
            ->setAccountAddress($accountAddress)
            ->setAccountTerminationReason($accountTerminationReason)
            ->setAutoPayment($autoPayment)
            ->setProduct($product)
            ->setProducts($products)
            ->setSnapshotARReport($snapshotARReport)
            ->setPersons($persons)
            ->setAccountPersons($accountPersons)
            ->setDistributionPoints($distributionPoints)
            ->setAccountNotes($accountNotes)
            ->setServicePoints($servicePoints)
            ->setAccountServicePoints($accountServicePoints)
            ->setPaymentAccounts($paymentAccounts)
            ->setAccountTransactions($accountTransactions)
            ->setPaymentArrangements($paymentArrangements)
            ->setServiceOrders($serviceOrders)
            ->setAccountAutoPayments($accountAutoPayments)
            ->setTickets($tickets)
            ->setAccountCommunications($accountCommunications)
            ->setAccountDocuments($accountDocuments)
            ->setAccountHistory($accountHistory)
            ->setAuditLog($auditLog)
            ->setTransactionSummaryItems($transactionSummaryItems)
            ->setAccountDepositOption($accountDepositOption)
            ->setBillHeaders($billHeaders)
            ->setBillDeliveryMethod($billDeliveryMethod)
            ->setAccountCustomFields($accountCustomFields)
            ->setMonthlyBillingCycle($monthlyBillingCycle)
            ->setLastPaymentTransaction($lastPaymentTransaction);
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\Account
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\Account
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountStatusID value
     * @return int
     */
    public function getAccountStatusID()
    {
        return $this->AccountStatusID;
    }
    /**
     * Set AccountStatusID value
     * @param int $accountStatusID
     * @return \SGCIS\Struct\Account
     */
    public function setAccountStatusID($accountStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($accountStatusID) && !is_numeric($accountStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountStatusID)), __LINE__);
        }
        $this->AccountStatusID = $accountStatusID;
        return $this;
    }
    /**
     * Get AccountTypeID value
     * @return int
     */
    public function getAccountTypeID()
    {
        return $this->AccountTypeID;
    }
    /**
     * Set AccountTypeID value
     * @param int $accountTypeID
     * @return \SGCIS\Struct\Account
     */
    public function setAccountTypeID($accountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeID) && !is_numeric($accountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTypeID)), __LINE__);
        }
        $this->AccountTypeID = $accountTypeID;
        return $this;
    }
    /**
     * Get AccountStartDate value
     * @return string
     */
    public function getAccountStartDate()
    {
        return $this->AccountStartDate;
    }
    /**
     * Set AccountStartDate value
     * @param string $accountStartDate
     * @return \SGCIS\Struct\Account
     */
    public function setAccountStartDate($accountStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($accountStartDate) && !is_string($accountStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStartDate)), __LINE__);
        }
        $this->AccountStartDate = $accountStartDate;
        return $this;
    }
    /**
     * Get AccountEndDate value
     * @return string
     */
    public function getAccountEndDate()
    {
        return $this->AccountEndDate;
    }
    /**
     * Set AccountEndDate value
     * @param string $accountEndDate
     * @return \SGCIS\Struct\Account
     */
    public function setAccountEndDate($accountEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($accountEndDate) && !is_string($accountEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountEndDate)), __LINE__);
        }
        $this->AccountEndDate = $accountEndDate;
        return $this;
    }
    /**
     * Get AccountTerminationReasonID value
     * @return int
     */
    public function getAccountTerminationReasonID()
    {
        return $this->AccountTerminationReasonID;
    }
    /**
     * Set AccountTerminationReasonID value
     * @param int $accountTerminationReasonID
     * @return \SGCIS\Struct\Account
     */
    public function setAccountTerminationReasonID($accountTerminationReasonID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTerminationReasonID) && !is_numeric($accountTerminationReasonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTerminationReasonID)), __LINE__);
        }
        $this->AccountTerminationReasonID = $accountTerminationReasonID;
        return $this;
    }
    /**
     * Get AccountTermType value
     * @return int
     */
    public function getAccountTermType()
    {
        return $this->AccountTermType;
    }
    /**
     * Set AccountTermType value
     * @param int $accountTermType
     * @return \SGCIS\Struct\Account
     */
    public function setAccountTermType($accountTermType = null)
    {
        // validation for constraint: int
        if (!is_null($accountTermType) && !is_numeric($accountTermType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTermType)), __LINE__);
        }
        $this->AccountTermType = $accountTermType;
        return $this;
    }
    /**
     * Get LanguageID value
     * @return int
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \SGCIS\Struct\Account
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !is_numeric($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get NotificationChannelID value
     * @return int
     */
    public function getNotificationChannelID()
    {
        return $this->NotificationChannelID;
    }
    /**
     * Set NotificationChannelID value
     * @param int $notificationChannelID
     * @return \SGCIS\Struct\Account
     */
    public function setNotificationChannelID($notificationChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($notificationChannelID) && !is_numeric($notificationChannelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notificationChannelID)), __LINE__);
        }
        $this->NotificationChannelID = $notificationChannelID;
        return $this;
    }
    /**
     * Get IsEnergyAssistance value
     * @return bool
     */
    public function getIsEnergyAssistance()
    {
        return $this->IsEnergyAssistance;
    }
    /**
     * Set IsEnergyAssistance value
     * @param bool $isEnergyAssistance
     * @return \SGCIS\Struct\Account
     */
    public function setIsEnergyAssistance($isEnergyAssistance = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnergyAssistance) && !is_bool($isEnergyAssistance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEnergyAssistance)), __LINE__);
        }
        $this->IsEnergyAssistance = $isEnergyAssistance;
        return $this;
    }
    /**
     * Get IsWithinRescissionPeriod value
     * @return bool
     */
    public function getIsWithinRescissionPeriod()
    {
        return $this->IsWithinRescissionPeriod;
    }
    /**
     * Set IsWithinRescissionPeriod value
     * @param bool $isWithinRescissionPeriod
     * @return \SGCIS\Struct\Account
     */
    public function setIsWithinRescissionPeriod($isWithinRescissionPeriod = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWithinRescissionPeriod) && !is_bool($isWithinRescissionPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isWithinRescissionPeriod)), __LINE__);
        }
        $this->IsWithinRescissionPeriod = $isWithinRescissionPeriod;
        return $this;
    }
    /**
     * Get EnrollmentExported value
     * @return bool
     */
    public function getEnrollmentExported()
    {
        return $this->EnrollmentExported;
    }
    /**
     * Set EnrollmentExported value
     * @param bool $enrollmentExported
     * @return \SGCIS\Struct\Account
     */
    public function setEnrollmentExported($enrollmentExported = null)
    {
        // validation for constraint: boolean
        if (!is_null($enrollmentExported) && !is_bool($enrollmentExported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enrollmentExported)), __LINE__);
        }
        $this->EnrollmentExported = $enrollmentExported;
        return $this;
    }
    /**
     * Get LeadSourceID value
     * @return int
     */
    public function getLeadSourceID()
    {
        return $this->LeadSourceID;
    }
    /**
     * Set LeadSourceID value
     * @param int $leadSourceID
     * @return \SGCIS\Struct\Account
     */
    public function setLeadSourceID($leadSourceID = null)
    {
        // validation for constraint: int
        if (!is_null($leadSourceID) && !is_numeric($leadSourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($leadSourceID)), __LINE__);
        }
        $this->LeadSourceID = $leadSourceID;
        return $this;
    }
    /**
     * Get IsMarketingOptIn value
     * @return bool
     */
    public function getIsMarketingOptIn()
    {
        return $this->IsMarketingOptIn;
    }
    /**
     * Set IsMarketingOptIn value
     * @param bool $isMarketingOptIn
     * @return \SGCIS\Struct\Account
     */
    public function setIsMarketingOptIn($isMarketingOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMarketingOptIn) && !is_bool($isMarketingOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMarketingOptIn)), __LINE__);
        }
        $this->IsMarketingOptIn = $isMarketingOptIn;
        return $this;
    }
    /**
     * Get PaymentArrangementBalance value
     * @return float
     */
    public function getPaymentArrangementBalance()
    {
        return $this->PaymentArrangementBalance;
    }
    /**
     * Set PaymentArrangementBalance value
     * @param float $paymentArrangementBalance
     * @return \SGCIS\Struct\Account
     */
    public function setPaymentArrangementBalance($paymentArrangementBalance = null)
    {
        $this->PaymentArrangementBalance = $paymentArrangementBalance;
        return $this;
    }
    /**
     * Get BalanceAsOfDate value
     * @return string
     */
    public function getBalanceAsOfDate()
    {
        return $this->BalanceAsOfDate;
    }
    /**
     * Set BalanceAsOfDate value
     * @param string $balanceAsOfDate
     * @return \SGCIS\Struct\Account
     */
    public function setBalanceAsOfDate($balanceAsOfDate = null)
    {
        // validation for constraint: string
        if (!is_null($balanceAsOfDate) && !is_string($balanceAsOfDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balanceAsOfDate)), __LINE__);
        }
        $this->BalanceAsOfDate = $balanceAsOfDate;
        return $this;
    }
    /**
     * Get MinPaymentToReconnect value
     * @return float
     */
    public function getMinPaymentToReconnect()
    {
        return $this->MinPaymentToReconnect;
    }
    /**
     * Set MinPaymentToReconnect value
     * @param float $minPaymentToReconnect
     * @return \SGCIS\Struct\Account
     */
    public function setMinPaymentToReconnect($minPaymentToReconnect = null)
    {
        $this->MinPaymentToReconnect = $minPaymentToReconnect;
        return $this;
    }
    /**
     * Get SuggestedPayment value
     * @return float
     */
    public function getSuggestedPayment()
    {
        return $this->SuggestedPayment;
    }
    /**
     * Set SuggestedPayment value
     * @param float $suggestedPayment
     * @return \SGCIS\Struct\Account
     */
    public function setSuggestedPayment($suggestedPayment = null)
    {
        $this->SuggestedPayment = $suggestedPayment;
        return $this;
    }
    /**
     * Get SuggestedPaymentNoFee value
     * @return float
     */
    public function getSuggestedPaymentNoFee()
    {
        return $this->SuggestedPaymentNoFee;
    }
    /**
     * Set SuggestedPaymentNoFee value
     * @param float $suggestedPaymentNoFee
     * @return \SGCIS\Struct\Account
     */
    public function setSuggestedPaymentNoFee($suggestedPaymentNoFee = null)
    {
        $this->SuggestedPaymentNoFee = $suggestedPaymentNoFee;
        return $this;
    }
    /**
     * Get LeadTypeID value
     * @return int
     */
    public function getLeadTypeID()
    {
        return $this->LeadTypeID;
    }
    /**
     * Set LeadTypeID value
     * @param int $leadTypeID
     * @return \SGCIS\Struct\Account
     */
    public function setLeadTypeID($leadTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($leadTypeID) && !is_numeric($leadTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($leadTypeID)), __LINE__);
        }
        $this->LeadTypeID = $leadTypeID;
        return $this;
    }
    /**
     * Get BurnRate value
     * @return float
     */
    public function getBurnRate()
    {
        return $this->BurnRate;
    }
    /**
     * Set BurnRate value
     * @param float $burnRate
     * @return \SGCIS\Struct\Account
     */
    public function setBurnRate($burnRate = null)
    {
        $this->BurnRate = $burnRate;
        return $this;
    }
    /**
     * Get DisconnectCount value
     * @return int
     */
    public function getDisconnectCount()
    {
        return $this->DisconnectCount;
    }
    /**
     * Set DisconnectCount value
     * @param int $disconnectCount
     * @return \SGCIS\Struct\Account
     */
    public function setDisconnectCount($disconnectCount = null)
    {
        // validation for constraint: int
        if (!is_null($disconnectCount) && !is_numeric($disconnectCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($disconnectCount)), __LINE__);
        }
        $this->DisconnectCount = $disconnectCount;
        return $this;
    }
    /**
     * Get HasAutoPaymentAccount value
     * @return bool
     */
    public function getHasAutoPaymentAccount()
    {
        return $this->HasAutoPaymentAccount;
    }
    /**
     * Set HasAutoPaymentAccount value
     * @param bool $hasAutoPaymentAccount
     * @return \SGCIS\Struct\Account
     */
    public function setHasAutoPaymentAccount($hasAutoPaymentAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasAutoPaymentAccount) && !is_bool($hasAutoPaymentAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasAutoPaymentAccount)), __LINE__);
        }
        $this->HasAutoPaymentAccount = $hasAutoPaymentAccount;
        return $this;
    }
    /**
     * Get HasEnergyProgram value
     * @return bool
     */
    public function getHasEnergyProgram()
    {
        return $this->HasEnergyProgram;
    }
    /**
     * Set HasEnergyProgram value
     * @param bool $hasEnergyProgram
     * @return \SGCIS\Struct\Account
     */
    public function setHasEnergyProgram($hasEnergyProgram = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasEnergyProgram) && !is_bool($hasEnergyProgram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasEnergyProgram)), __LINE__);
        }
        $this->HasEnergyProgram = $hasEnergyProgram;
        return $this;
    }
    /**
     * Get IsEnergyProgram value
     * @return bool
     */
    public function getIsEnergyProgram()
    {
        return $this->IsEnergyProgram;
    }
    /**
     * Set IsEnergyProgram value
     * @param bool $isEnergyProgram
     * @return \SGCIS\Struct\Account
     */
    public function setIsEnergyProgram($isEnergyProgram = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnergyProgram) && !is_bool($isEnergyProgram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEnergyProgram)), __LINE__);
        }
        $this->IsEnergyProgram = $isEnergyProgram;
        return $this;
    }
    /**
     * Get HasPaymentArrangement value
     * @return bool
     */
    public function getHasPaymentArrangement()
    {
        return $this->HasPaymentArrangement;
    }
    /**
     * Set HasPaymentArrangement value
     * @param bool $hasPaymentArrangement
     * @return \SGCIS\Struct\Account
     */
    public function setHasPaymentArrangement($hasPaymentArrangement = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPaymentArrangement) && !is_bool($hasPaymentArrangement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasPaymentArrangement)), __LINE__);
        }
        $this->HasPaymentArrangement = $hasPaymentArrangement;
        return $this;
    }
    /**
     * Get ReEnrollDate value
     * @return string
     */
    public function getReEnrollDate()
    {
        return $this->ReEnrollDate;
    }
    /**
     * Set ReEnrollDate value
     * @param string $reEnrollDate
     * @return \SGCIS\Struct\Account
     */
    public function setReEnrollDate($reEnrollDate = null)
    {
        // validation for constraint: string
        if (!is_null($reEnrollDate) && !is_string($reEnrollDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reEnrollDate)), __LINE__);
        }
        $this->ReEnrollDate = $reEnrollDate;
        return $this;
    }
    /**
     * Get AddToReferralProgram value
     * @return bool
     */
    public function getAddToReferralProgram()
    {
        return $this->AddToReferralProgram;
    }
    /**
     * Set AddToReferralProgram value
     * @param bool $addToReferralProgram
     * @return \SGCIS\Struct\Account
     */
    public function setAddToReferralProgram($addToReferralProgram = null)
    {
        // validation for constraint: boolean
        if (!is_null($addToReferralProgram) && !is_bool($addToReferralProgram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($addToReferralProgram)), __LINE__);
        }
        $this->AddToReferralProgram = $addToReferralProgram;
        return $this;
    }
    /**
     * Get IsOnReferralProgram value
     * @return bool
     */
    public function getIsOnReferralProgram()
    {
        return $this->IsOnReferralProgram;
    }
    /**
     * Set IsOnReferralProgram value
     * @param bool $isOnReferralProgram
     * @return \SGCIS\Struct\Account
     */
    public function setIsOnReferralProgram($isOnReferralProgram = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnReferralProgram) && !is_bool($isOnReferralProgram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isOnReferralProgram)), __LINE__);
        }
        $this->IsOnReferralProgram = $isOnReferralProgram;
        return $this;
    }
    /**
     * Get AddtoCampaign value
     * @return bool
     */
    public function getAddtoCampaign()
    {
        return $this->AddtoCampaign;
    }
    /**
     * Set AddtoCampaign value
     * @param bool $addtoCampaign
     * @return \SGCIS\Struct\Account
     */
    public function setAddtoCampaign($addtoCampaign = null)
    {
        // validation for constraint: boolean
        if (!is_null($addtoCampaign) && !is_bool($addtoCampaign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($addtoCampaign)), __LINE__);
        }
        $this->AddtoCampaign = $addtoCampaign;
        return $this;
    }
    /**
     * Get SalesPersonID value
     * @return int
     */
    public function getSalesPersonID()
    {
        return $this->SalesPersonID;
    }
    /**
     * Set SalesPersonID value
     * @param int $salesPersonID
     * @return \SGCIS\Struct\Account
     */
    public function setSalesPersonID($salesPersonID = null)
    {
        // validation for constraint: int
        if (!is_null($salesPersonID) && !is_numeric($salesPersonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesPersonID)), __LINE__);
        }
        $this->SalesPersonID = $salesPersonID;
        return $this;
    }
    /**
     * Get DisableAutoDisconnect value
     * @return bool
     */
    public function getDisableAutoDisconnect()
    {
        return $this->DisableAutoDisconnect;
    }
    /**
     * Set DisableAutoDisconnect value
     * @param bool $disableAutoDisconnect
     * @return \SGCIS\Struct\Account
     */
    public function setDisableAutoDisconnect($disableAutoDisconnect = null)
    {
        // validation for constraint: boolean
        if (!is_null($disableAutoDisconnect) && !is_bool($disableAutoDisconnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($disableAutoDisconnect)), __LINE__);
        }
        $this->DisableAutoDisconnect = $disableAutoDisconnect;
        return $this;
    }
    /**
     * Get DisableAutoReconnect value
     * @return bool
     */
    public function getDisableAutoReconnect()
    {
        return $this->DisableAutoReconnect;
    }
    /**
     * Set DisableAutoReconnect value
     * @param bool $disableAutoReconnect
     * @return \SGCIS\Struct\Account
     */
    public function setDisableAutoReconnect($disableAutoReconnect = null)
    {
        // validation for constraint: boolean
        if (!is_null($disableAutoReconnect) && !is_bool($disableAutoReconnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($disableAutoReconnect)), __LINE__);
        }
        $this->DisableAutoReconnect = $disableAutoReconnect;
        return $this;
    }
    /**
     * Get isError value
     * @return bool
     */
    public function getIsError()
    {
        return $this->isError;
    }
    /**
     * Set isError value
     * @param bool $isError
     * @return \SGCIS\Struct\Account
     */
    public function setIsError($isError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isError) && !is_bool($isError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isError)), __LINE__);
        }
        $this->isError = $isError;
        return $this;
    }
    /**
     * Get IsBudgetBilling value
     * @return bool
     */
    public function getIsBudgetBilling()
    {
        return $this->IsBudgetBilling;
    }
    /**
     * Set IsBudgetBilling value
     * @param bool $isBudgetBilling
     * @return \SGCIS\Struct\Account
     */
    public function setIsBudgetBilling($isBudgetBilling = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBudgetBilling) && !is_bool($isBudgetBilling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBudgetBilling)), __LINE__);
        }
        $this->IsBudgetBilling = $isBudgetBilling;
        return $this;
    }
    /**
     * Get BudgetBillMonth value
     * @return int
     */
    public function getBudgetBillMonth()
    {
        return $this->BudgetBillMonth;
    }
    /**
     * Set BudgetBillMonth value
     * @param int $budgetBillMonth
     * @return \SGCIS\Struct\Account
     */
    public function setBudgetBillMonth($budgetBillMonth = null)
    {
        // validation for constraint: int
        if (!is_null($budgetBillMonth) && !is_numeric($budgetBillMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($budgetBillMonth)), __LINE__);
        }
        $this->BudgetBillMonth = $budgetBillMonth;
        return $this;
    }
    /**
     * Get BudgetBillingStartDate value
     * @return string
     */
    public function getBudgetBillingStartDate()
    {
        return $this->BudgetBillingStartDate;
    }
    /**
     * Set BudgetBillingStartDate value
     * @param string $budgetBillingStartDate
     * @return \SGCIS\Struct\Account
     */
    public function setBudgetBillingStartDate($budgetBillingStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($budgetBillingStartDate) && !is_string($budgetBillingStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($budgetBillingStartDate)), __LINE__);
        }
        $this->BudgetBillingStartDate = $budgetBillingStartDate;
        return $this;
    }
    /**
     * Get AccountBillingTypeID value
     * @return int
     */
    public function getAccountBillingTypeID()
    {
        return $this->AccountBillingTypeID;
    }
    /**
     * Set AccountBillingTypeID value
     * @param int $accountBillingTypeID
     * @return \SGCIS\Struct\Account
     */
    public function setAccountBillingTypeID($accountBillingTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountBillingTypeID) && !is_numeric($accountBillingTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountBillingTypeID)), __LINE__);
        }
        $this->AccountBillingTypeID = $accountBillingTypeID;
        return $this;
    }
    /**
     * Get ManagerUserID value
     * @return int
     */
    public function getManagerUserID()
    {
        return $this->ManagerUserID;
    }
    /**
     * Set ManagerUserID value
     * @param int $managerUserID
     * @return \SGCIS\Struct\Account
     */
    public function setManagerUserID($managerUserID = null)
    {
        // validation for constraint: int
        if (!is_null($managerUserID) && !is_numeric($managerUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($managerUserID)), __LINE__);
        }
        $this->ManagerUserID = $managerUserID;
        return $this;
    }
    /**
     * Get NextBillDate value
     * @return string
     */
    public function getNextBillDate()
    {
        return $this->NextBillDate;
    }
    /**
     * Set NextBillDate value
     * @param string $nextBillDate
     * @return \SGCIS\Struct\Account
     */
    public function setNextBillDate($nextBillDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextBillDate) && !is_string($nextBillDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextBillDate)), __LINE__);
        }
        $this->NextBillDate = $nextBillDate;
        return $this;
    }
    /**
     * Get IsNoPaymentPlan value
     * @return bool
     */
    public function getIsNoPaymentPlan()
    {
        return $this->IsNoPaymentPlan;
    }
    /**
     * Set IsNoPaymentPlan value
     * @param bool $isNoPaymentPlan
     * @return \SGCIS\Struct\Account
     */
    public function setIsNoPaymentPlan($isNoPaymentPlan = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNoPaymentPlan) && !is_bool($isNoPaymentPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isNoPaymentPlan)), __LINE__);
        }
        $this->IsNoPaymentPlan = $isNoPaymentPlan;
        return $this;
    }
    /**
     * Get IsPaymentPlan value
     * @return bool
     */
    public function getIsPaymentPlan()
    {
        return $this->IsPaymentPlan;
    }
    /**
     * Set IsPaymentPlan value
     * @param bool $isPaymentPlan
     * @return \SGCIS\Struct\Account
     */
    public function setIsPaymentPlan($isPaymentPlan = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaymentPlan) && !is_bool($isPaymentPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPaymentPlan)), __LINE__);
        }
        $this->IsPaymentPlan = $isPaymentPlan;
        return $this;
    }
    /**
     * Get IsCashOnly value
     * @return bool
     */
    public function getIsCashOnly()
    {
        return $this->IsCashOnly;
    }
    /**
     * Set IsCashOnly value
     * @param bool $isCashOnly
     * @return \SGCIS\Struct\Account
     */
    public function setIsCashOnly($isCashOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCashOnly) && !is_bool($isCashOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCashOnly)), __LINE__);
        }
        $this->IsCashOnly = $isCashOnly;
        return $this;
    }
    /**
     * Get IsVIP value
     * @return bool
     */
    public function getIsVIP()
    {
        return $this->IsVIP;
    }
    /**
     * Set IsVIP value
     * @param bool $isVIP
     * @return \SGCIS\Struct\Account
     */
    public function setIsVIP($isVIP = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVIP) && !is_bool($isVIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isVIP)), __LINE__);
        }
        $this->IsVIP = $isVIP;
        return $this;
    }
    /**
     * Get NoLateFee value
     * @return bool
     */
    public function getNoLateFee()
    {
        return $this->NoLateFee;
    }
    /**
     * Set NoLateFee value
     * @param bool $noLateFee
     * @return \SGCIS\Struct\Account
     */
    public function setNoLateFee($noLateFee = null)
    {
        // validation for constraint: boolean
        if (!is_null($noLateFee) && !is_bool($noLateFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($noLateFee)), __LINE__);
        }
        $this->NoLateFee = $noLateFee;
        return $this;
    }
    /**
     * Get IsActivePledge value
     * @return bool
     */
    public function getIsActivePledge()
    {
        return $this->IsActivePledge;
    }
    /**
     * Set IsActivePledge value
     * @param bool $isActivePledge
     * @return \SGCIS\Struct\Account
     */
    public function setIsActivePledge($isActivePledge = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActivePledge) && !is_bool($isActivePledge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActivePledge)), __LINE__);
        }
        $this->IsActivePledge = $isActivePledge;
        return $this;
    }
    /**
     * Get IsSwitchHoldBillPay value
     * @return bool
     */
    public function getIsSwitchHoldBillPay()
    {
        return $this->IsSwitchHoldBillPay;
    }
    /**
     * Set IsSwitchHoldBillPay value
     * @param bool $isSwitchHoldBillPay
     * @return \SGCIS\Struct\Account
     */
    public function setIsSwitchHoldBillPay($isSwitchHoldBillPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSwitchHoldBillPay) && !is_bool($isSwitchHoldBillPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSwitchHoldBillPay)), __LINE__);
        }
        $this->IsSwitchHoldBillPay = $isSwitchHoldBillPay;
        return $this;
    }
    /**
     * Get IsSwitchHoldTampering value
     * @return bool
     */
    public function getIsSwitchHoldTampering()
    {
        return $this->IsSwitchHoldTampering;
    }
    /**
     * Set IsSwitchHoldTampering value
     * @param bool $isSwitchHoldTampering
     * @return \SGCIS\Struct\Account
     */
    public function setIsSwitchHoldTampering($isSwitchHoldTampering = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSwitchHoldTampering) && !is_bool($isSwitchHoldTampering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSwitchHoldTampering)), __LINE__);
        }
        $this->IsSwitchHoldTampering = $isSwitchHoldTampering;
        return $this;
    }
    /**
     * Get IsWeatherMoratorium value
     * @return bool
     */
    public function getIsWeatherMoratorium()
    {
        return $this->IsWeatherMoratorium;
    }
    /**
     * Set IsWeatherMoratorium value
     * @param bool $isWeatherMoratorium
     * @return \SGCIS\Struct\Account
     */
    public function setIsWeatherMoratorium($isWeatherMoratorium = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWeatherMoratorium) && !is_bool($isWeatherMoratorium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isWeatherMoratorium)), __LINE__);
        }
        $this->IsWeatherMoratorium = $isWeatherMoratorium;
        return $this;
    }
    /**
     * Get IsDebtRecoveryDistributionMode value
     * @return bool
     */
    public function getIsDebtRecoveryDistributionMode()
    {
        return $this->IsDebtRecoveryDistributionMode;
    }
    /**
     * Set IsDebtRecoveryDistributionMode value
     * @param bool $isDebtRecoveryDistributionMode
     * @return \SGCIS\Struct\Account
     */
    public function setIsDebtRecoveryDistributionMode($isDebtRecoveryDistributionMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDebtRecoveryDistributionMode) && !is_bool($isDebtRecoveryDistributionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDebtRecoveryDistributionMode)), __LINE__);
        }
        $this->IsDebtRecoveryDistributionMode = $isDebtRecoveryDistributionMode;
        return $this;
    }
    /**
     * Get SendDailyNotification value
     * @return bool
     */
    public function getSendDailyNotification()
    {
        return $this->SendDailyNotification;
    }
    /**
     * Set SendDailyNotification value
     * @param bool $sendDailyNotification
     * @return \SGCIS\Struct\Account
     */
    public function setSendDailyNotification($sendDailyNotification = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendDailyNotification) && !is_bool($sendDailyNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendDailyNotification)), __LINE__);
        }
        $this->SendDailyNotification = $sendDailyNotification;
        return $this;
    }
    /**
     * Get SkipSendMoveOut value
     * @return bool
     */
    public function getSkipSendMoveOut()
    {
        return $this->SkipSendMoveOut;
    }
    /**
     * Set SkipSendMoveOut value
     * @param bool $skipSendMoveOut
     * @return \SGCIS\Struct\Account
     */
    public function setSkipSendMoveOut($skipSendMoveOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipSendMoveOut) && !is_bool($skipSendMoveOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($skipSendMoveOut)), __LINE__);
        }
        $this->SkipSendMoveOut = $skipSendMoveOut;
        return $this;
    }
    /**
     * Get IsPostalMailDocDelivery value
     * @return bool
     */
    public function getIsPostalMailDocDelivery()
    {
        return $this->IsPostalMailDocDelivery;
    }
    /**
     * Set IsPostalMailDocDelivery value
     * @param bool $isPostalMailDocDelivery
     * @return \SGCIS\Struct\Account
     */
    public function setIsPostalMailDocDelivery($isPostalMailDocDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPostalMailDocDelivery) && !is_bool($isPostalMailDocDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPostalMailDocDelivery)), __LINE__);
        }
        $this->IsPostalMailDocDelivery = $isPostalMailDocDelivery;
        return $this;
    }
    /**
     * Get IsElectronicDocDelivery value
     * @return bool
     */
    public function getIsElectronicDocDelivery()
    {
        return $this->IsElectronicDocDelivery;
    }
    /**
     * Set IsElectronicDocDelivery value
     * @param bool $isElectronicDocDelivery
     * @return \SGCIS\Struct\Account
     */
    public function setIsElectronicDocDelivery($isElectronicDocDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($isElectronicDocDelivery) && !is_bool($isElectronicDocDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isElectronicDocDelivery)), __LINE__);
        }
        $this->IsElectronicDocDelivery = $isElectronicDocDelivery;
        return $this;
    }
    /**
     * Get SecurityQuestionID value
     * @return int
     */
    public function getSecurityQuestionID()
    {
        return $this->SecurityQuestionID;
    }
    /**
     * Set SecurityQuestionID value
     * @param int $securityQuestionID
     * @return \SGCIS\Struct\Account
     */
    public function setSecurityQuestionID($securityQuestionID = null)
    {
        // validation for constraint: int
        if (!is_null($securityQuestionID) && !is_numeric($securityQuestionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($securityQuestionID)), __LINE__);
        }
        $this->SecurityQuestionID = $securityQuestionID;
        return $this;
    }
    /**
     * Get ScheduledTerminationDate value
     * @return string
     */
    public function getScheduledTerminationDate()
    {
        return $this->ScheduledTerminationDate;
    }
    /**
     * Set ScheduledTerminationDate value
     * @param string $scheduledTerminationDate
     * @return \SGCIS\Struct\Account
     */
    public function setScheduledTerminationDate($scheduledTerminationDate = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledTerminationDate) && !is_string($scheduledTerminationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledTerminationDate)), __LINE__);
        }
        $this->ScheduledTerminationDate = $scheduledTerminationDate;
        return $this;
    }
    /**
     * Get IsNpVisaRequest value
     * @return bool
     */
    public function getIsNpVisaRequest()
    {
        return $this->IsNpVisaRequest;
    }
    /**
     * Set IsNpVisaRequest value
     * @param bool $isNpVisaRequest
     * @return \SGCIS\Struct\Account
     */
    public function setIsNpVisaRequest($isNpVisaRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNpVisaRequest) && !is_bool($isNpVisaRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isNpVisaRequest)), __LINE__);
        }
        $this->IsNpVisaRequest = $isNpVisaRequest;
        return $this;
    }
    /**
     * Get IsPrimary value
     * @return bool
     */
    public function getIsPrimary()
    {
        return $this->IsPrimary;
    }
    /**
     * Set IsPrimary value
     * @param bool $isPrimary
     * @return \SGCIS\Struct\Account
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPrimary)), __LINE__);
        }
        $this->IsPrimary = $isPrimary;
        return $this;
    }
    /**
     * Get AccountBalance value
     * @return float
     */
    public function getAccountBalance()
    {
        return $this->AccountBalance;
    }
    /**
     * Set AccountBalance value
     * @param float $accountBalance
     * @return \SGCIS\Struct\Account
     */
    public function setAccountBalance($accountBalance = null)
    {
        $this->AccountBalance = $accountBalance;
        return $this;
    }
    /**
     * Get DebtBalance value
     * @return float
     */
    public function getDebtBalance()
    {
        return $this->DebtBalance;
    }
    /**
     * Set DebtBalance value
     * @param float $debtBalance
     * @return \SGCIS\Struct\Account
     */
    public function setDebtBalance($debtBalance = null)
    {
        $this->DebtBalance = $debtBalance;
        return $this;
    }
    /**
     * Get BadDebt value
     * @return float
     */
    public function getBadDebt()
    {
        return $this->BadDebt;
    }
    /**
     * Set BadDebt value
     * @param float $badDebt
     * @return \SGCIS\Struct\Account
     */
    public function setBadDebt($badDebt = null)
    {
        $this->BadDebt = $badDebt;
        return $this;
    }
    /**
     * Get DaysRemaining value
     * @return float
     */
    public function getDaysRemaining()
    {
        return $this->DaysRemaining;
    }
    /**
     * Set DaysRemaining value
     * @param float $daysRemaining
     * @return \SGCIS\Struct\Account
     */
    public function setDaysRemaining($daysRemaining = null)
    {
        $this->DaysRemaining = $daysRemaining;
        return $this;
    }
    /**
     * Get DebtBalancePA value
     * @return float
     */
    public function getDebtBalancePA()
    {
        return $this->DebtBalancePA;
    }
    /**
     * Set DebtBalancePA value
     * @param float $debtBalancePA
     * @return \SGCIS\Struct\Account
     */
    public function setDebtBalancePA($debtBalancePA = null)
    {
        $this->DebtBalancePA = $debtBalancePA;
        return $this;
    }
    /**
     * Get DebtBalanceDPP value
     * @return float
     */
    public function getDebtBalanceDPP()
    {
        return $this->DebtBalanceDPP;
    }
    /**
     * Set DebtBalanceDPP value
     * @param float $debtBalanceDPP
     * @return \SGCIS\Struct\Account
     */
    public function setDebtBalanceDPP($debtBalanceDPP = null)
    {
        $this->DebtBalanceDPP = $debtBalanceDPP;
        return $this;
    }
    /**
     * Get DefaultedBalanceDPP value
     * @return float
     */
    public function getDefaultedBalanceDPP()
    {
        return $this->DefaultedBalanceDPP;
    }
    /**
     * Set DefaultedBalanceDPP value
     * @param float $defaultedBalanceDPP
     * @return \SGCIS\Struct\Account
     */
    public function setDefaultedBalanceDPP($defaultedBalanceDPP = null)
    {
        $this->DefaultedBalanceDPP = $defaultedBalanceDPP;
        return $this;
    }
    /**
     * Get BillingFrequencyID value
     * @return int
     */
    public function getBillingFrequencyID()
    {
        return $this->BillingFrequencyID;
    }
    /**
     * Set BillingFrequencyID value
     * @param int $billingFrequencyID
     * @return \SGCIS\Struct\Account
     */
    public function setBillingFrequencyID($billingFrequencyID = null)
    {
        // validation for constraint: int
        if (!is_null($billingFrequencyID) && !is_numeric($billingFrequencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billingFrequencyID)), __LINE__);
        }
        $this->BillingFrequencyID = $billingFrequencyID;
        return $this;
    }
    /**
     * Get BillCalculationMethodID value
     * @return int
     */
    public function getBillCalculationMethodID()
    {
        return $this->BillCalculationMethodID;
    }
    /**
     * Set BillCalculationMethodID value
     * @param int $billCalculationMethodID
     * @return \SGCIS\Struct\Account
     */
    public function setBillCalculationMethodID($billCalculationMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($billCalculationMethodID) && !is_numeric($billCalculationMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billCalculationMethodID)), __LINE__);
        }
        $this->BillCalculationMethodID = $billCalculationMethodID;
        return $this;
    }
    /**
     * Get BillingTriggerID value
     * @return int
     */
    public function getBillingTriggerID()
    {
        return $this->BillingTriggerID;
    }
    /**
     * Set BillingTriggerID value
     * @param int $billingTriggerID
     * @return \SGCIS\Struct\Account
     */
    public function setBillingTriggerID($billingTriggerID = null)
    {
        // validation for constraint: int
        if (!is_null($billingTriggerID) && !is_numeric($billingTriggerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billingTriggerID)), __LINE__);
        }
        $this->BillingTriggerID = $billingTriggerID;
        return $this;
    }
    /**
     * Get BillingTriggerDaysOffset value
     * @return int
     */
    public function getBillingTriggerDaysOffset()
    {
        return $this->BillingTriggerDaysOffset;
    }
    /**
     * Set BillingTriggerDaysOffset value
     * @param int $billingTriggerDaysOffset
     * @return \SGCIS\Struct\Account
     */
    public function setBillingTriggerDaysOffset($billingTriggerDaysOffset = null)
    {
        // validation for constraint: int
        if (!is_null($billingTriggerDaysOffset) && !is_numeric($billingTriggerDaysOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billingTriggerDaysOffset)), __LINE__);
        }
        $this->BillingTriggerDaysOffset = $billingTriggerDaysOffset;
        return $this;
    }
    /**
     * Get PaymentDayOfWeek value
     * @return int
     */
    public function getPaymentDayOfWeek()
    {
        return $this->PaymentDayOfWeek;
    }
    /**
     * Set PaymentDayOfWeek value
     * @param int $paymentDayOfWeek
     * @return \SGCIS\Struct\Account
     */
    public function setPaymentDayOfWeek($paymentDayOfWeek = null)
    {
        // validation for constraint: int
        if (!is_null($paymentDayOfWeek) && !is_numeric($paymentDayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentDayOfWeek)), __LINE__);
        }
        $this->PaymentDayOfWeek = $paymentDayOfWeek;
        return $this;
    }
    /**
     * Get PaymentDayOfMonth value
     * @return int
     */
    public function getPaymentDayOfMonth()
    {
        return $this->PaymentDayOfMonth;
    }
    /**
     * Set PaymentDayOfMonth value
     * @param int $paymentDayOfMonth
     * @return \SGCIS\Struct\Account
     */
    public function setPaymentDayOfMonth($paymentDayOfMonth = null)
    {
        // validation for constraint: int
        if (!is_null($paymentDayOfMonth) && !is_numeric($paymentDayOfMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentDayOfMonth)), __LINE__);
        }
        $this->PaymentDayOfMonth = $paymentDayOfMonth;
        return $this;
    }
    /**
     * Get DunningModelId value
     * @return int
     */
    public function getDunningModelId()
    {
        return $this->DunningModelId;
    }
    /**
     * Set DunningModelId value
     * @param int $dunningModelId
     * @return \SGCIS\Struct\Account
     */
    public function setDunningModelId($dunningModelId = null)
    {
        // validation for constraint: int
        if (!is_null($dunningModelId) && !is_numeric($dunningModelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dunningModelId)), __LINE__);
        }
        $this->DunningModelId = $dunningModelId;
        return $this;
    }
    /**
     * Get HasBillConverted value
     * @return bool
     */
    public function getHasBillConverted()
    {
        return $this->HasBillConverted;
    }
    /**
     * Set HasBillConverted value
     * @param bool $hasBillConverted
     * @return \SGCIS\Struct\Account
     */
    public function setHasBillConverted($hasBillConverted = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasBillConverted) && !is_bool($hasBillConverted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasBillConverted)), __LINE__);
        }
        $this->HasBillConverted = $hasBillConverted;
        return $this;
    }
    /**
     * Get HasTransactionsConverted value
     * @return bool
     */
    public function getHasTransactionsConverted()
    {
        return $this->HasTransactionsConverted;
    }
    /**
     * Set HasTransactionsConverted value
     * @param bool $hasTransactionsConverted
     * @return \SGCIS\Struct\Account
     */
    public function setHasTransactionsConverted($hasTransactionsConverted = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTransactionsConverted) && !is_bool($hasTransactionsConverted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasTransactionsConverted)), __LINE__);
        }
        $this->HasTransactionsConverted = $hasTransactionsConverted;
        return $this;
    }
    /**
     * Get IsNoPromoAllowed value
     * @return bool
     */
    public function getIsNoPromoAllowed()
    {
        return $this->IsNoPromoAllowed;
    }
    /**
     * Set IsNoPromoAllowed value
     * @param bool $isNoPromoAllowed
     * @return \SGCIS\Struct\Account
     */
    public function setIsNoPromoAllowed($isNoPromoAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNoPromoAllowed) && !is_bool($isNoPromoAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isNoPromoAllowed)), __LINE__);
        }
        $this->IsNoPromoAllowed = $isNoPromoAllowed;
        return $this;
    }
    /**
     * Get PastDueBalance value
     * @return float
     */
    public function getPastDueBalance()
    {
        return $this->PastDueBalance;
    }
    /**
     * Set PastDueBalance value
     * @param float $pastDueBalance
     * @return \SGCIS\Struct\Account
     */
    public function setPastDueBalance($pastDueBalance = null)
    {
        $this->PastDueBalance = $pastDueBalance;
        return $this;
    }
    /**
     * Get SendMessagingAllPersons value
     * @return bool
     */
    public function getSendMessagingAllPersons()
    {
        return $this->SendMessagingAllPersons;
    }
    /**
     * Set SendMessagingAllPersons value
     * @param bool $sendMessagingAllPersons
     * @return \SGCIS\Struct\Account
     */
    public function setSendMessagingAllPersons($sendMessagingAllPersons = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendMessagingAllPersons) && !is_bool($sendMessagingAllPersons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendMessagingAllPersons)), __LINE__);
        }
        $this->SendMessagingAllPersons = $sendMessagingAllPersons;
        return $this;
    }
    /**
     * Get BillTypeID value
     * @return int
     */
    public function getBillTypeID()
    {
        return $this->BillTypeID;
    }
    /**
     * Set BillTypeID value
     * @param int $billTypeID
     * @return \SGCIS\Struct\Account
     */
    public function setBillTypeID($billTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($billTypeID) && !is_numeric($billTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billTypeID)), __LINE__);
        }
        $this->BillTypeID = $billTypeID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \SGCIS\Struct\Account
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !is_numeric($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get CustomerTypeID value
     * @return int
     */
    public function getCustomerTypeID()
    {
        return $this->CustomerTypeID;
    }
    /**
     * Set CustomerTypeID value
     * @param int $customerTypeID
     * @return \SGCIS\Struct\Account
     */
    public function setCustomerTypeID($customerTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($customerTypeID) && !is_numeric($customerTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerTypeID)), __LINE__);
        }
        $this->CustomerTypeID = $customerTypeID;
        return $this;
    }
    /**
     * Get AvailableBalance value
     * @return float
     */
    public function getAvailableBalance()
    {
        return $this->AvailableBalance;
    }
    /**
     * Set AvailableBalance value
     * @param float $availableBalance
     * @return \SGCIS\Struct\Account
     */
    public function setAvailableBalance($availableBalance = null)
    {
        $this->AvailableBalance = $availableBalance;
        return $this;
    }
    /**
     * Get DepositAmount value
     * @return float
     */
    public function getDepositAmount()
    {
        return $this->DepositAmount;
    }
    /**
     * Set DepositAmount value
     * @param float $depositAmount
     * @return \SGCIS\Struct\Account
     */
    public function setDepositAmount($depositAmount = null)
    {
        $this->DepositAmount = $depositAmount;
        return $this;
    }
    /**
     * Get DepositAmountOwed value
     * @return float
     */
    public function getDepositAmountOwed()
    {
        return $this->DepositAmountOwed;
    }
    /**
     * Set DepositAmountOwed value
     * @param float $depositAmountOwed
     * @return \SGCIS\Struct\Account
     */
    public function setDepositAmountOwed($depositAmountOwed = null)
    {
        $this->DepositAmountOwed = $depositAmountOwed;
        return $this;
    }
    /**
     * Get PledgeAmountOwed value
     * @return float
     */
    public function getPledgeAmountOwed()
    {
        return $this->PledgeAmountOwed;
    }
    /**
     * Set PledgeAmountOwed value
     * @param float $pledgeAmountOwed
     * @return \SGCIS\Struct\Account
     */
    public function setPledgeAmountOwed($pledgeAmountOwed = null)
    {
        $this->PledgeAmountOwed = $pledgeAmountOwed;
        return $this;
    }
    /**
     * Get DepositAmountHeld value
     * @return float
     */
    public function getDepositAmountHeld()
    {
        return $this->DepositAmountHeld;
    }
    /**
     * Set DepositAmountHeld value
     * @param float $depositAmountHeld
     * @return \SGCIS\Struct\Account
     */
    public function setDepositAmountHeld($depositAmountHeld = null)
    {
        $this->DepositAmountHeld = $depositAmountHeld;
        return $this;
    }
    /**
     * Get PreBillingBalance value
     * @return float
     */
    public function getPreBillingBalance()
    {
        return $this->PreBillingBalance;
    }
    /**
     * Set PreBillingBalance value
     * @param float $preBillingBalance
     * @return \SGCIS\Struct\Account
     */
    public function setPreBillingBalance($preBillingBalance = null)
    {
        $this->PreBillingBalance = $preBillingBalance;
        return $this;
    }
    /**
     * Get IsWaiveReconnectFee value
     * @return bool
     */
    public function getIsWaiveReconnectFee()
    {
        return $this->IsWaiveReconnectFee;
    }
    /**
     * Set IsWaiveReconnectFee value
     * @param bool $isWaiveReconnectFee
     * @return \SGCIS\Struct\Account
     */
    public function setIsWaiveReconnectFee($isWaiveReconnectFee = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWaiveReconnectFee) && !is_bool($isWaiveReconnectFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isWaiveReconnectFee)), __LINE__);
        }
        $this->IsWaiveReconnectFee = $isWaiveReconnectFee;
        return $this;
    }
    /**
     * Get AmortizedReconciliationAmount value
     * @return float
     */
    public function getAmortizedReconciliationAmount()
    {
        return $this->AmortizedReconciliationAmount;
    }
    /**
     * Set AmortizedReconciliationAmount value
     * @param float $amortizedReconciliationAmount
     * @return \SGCIS\Struct\Account
     */
    public function setAmortizedReconciliationAmount($amortizedReconciliationAmount = null)
    {
        $this->AmortizedReconciliationAmount = $amortizedReconciliationAmount;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\Account
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get LOANumber value
     * @return string|null
     */
    public function getLOANumber()
    {
        return $this->LOANumber;
    }
    /**
     * Set LOANumber value
     * @param string $lOANumber
     * @return \SGCIS\Struct\Account
     */
    public function setLOANumber($lOANumber = null)
    {
        // validation for constraint: string
        if (!is_null($lOANumber) && !is_string($lOANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lOANumber)), __LINE__);
        }
        $this->LOANumber = $lOANumber;
        return $this;
    }
    /**
     * Get LeadSourceName value
     * @return string|null
     */
    public function getLeadSourceName()
    {
        return $this->LeadSourceName;
    }
    /**
     * Set LeadSourceName value
     * @param string $leadSourceName
     * @return \SGCIS\Struct\Account
     */
    public function setLeadSourceName($leadSourceName = null)
    {
        // validation for constraint: string
        if (!is_null($leadSourceName) && !is_string($leadSourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leadSourceName)), __LINE__);
        }
        $this->LeadSourceName = $leadSourceName;
        return $this;
    }
    /**
     * Get EnrollmentError value
     * @return string|null
     */
    public function getEnrollmentError()
    {
        return $this->EnrollmentError;
    }
    /**
     * Set EnrollmentError value
     * @param string $enrollmentError
     * @return \SGCIS\Struct\Account
     */
    public function setEnrollmentError($enrollmentError = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentError) && !is_string($enrollmentError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollmentError)), __LINE__);
        }
        $this->EnrollmentError = $enrollmentError;
        return $this;
    }
    /**
     * Get LeadTypeName value
     * @return string|null
     */
    public function getLeadTypeName()
    {
        return $this->LeadTypeName;
    }
    /**
     * Set LeadTypeName value
     * @param string $leadTypeName
     * @return \SGCIS\Struct\Account
     */
    public function setLeadTypeName($leadTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($leadTypeName) && !is_string($leadTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leadTypeName)), __LINE__);
        }
        $this->LeadTypeName = $leadTypeName;
        return $this;
    }
    /**
     * Get SalesAgentCompanyName value
     * @return string|null
     */
    public function getSalesAgentCompanyName()
    {
        return $this->SalesAgentCompanyName;
    }
    /**
     * Set SalesAgentCompanyName value
     * @param string $salesAgentCompanyName
     * @return \SGCIS\Struct\Account
     */
    public function setSalesAgentCompanyName($salesAgentCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($salesAgentCompanyName) && !is_string($salesAgentCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesAgentCompanyName)), __LINE__);
        }
        $this->SalesAgentCompanyName = $salesAgentCompanyName;
        return $this;
    }
    /**
     * Get Provider value
     * @return string|null
     */
    public function getProvider()
    {
        return $this->Provider;
    }
    /**
     * Set Provider value
     * @param string $provider
     * @return \SGCIS\Struct\Account
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provider)), __LINE__);
        }
        $this->Provider = $provider;
        return $this;
    }
    /**
     * Get ConsumptionHistory value
     * @return \SGCIS\Array\ArrayOfServicePointMeterRead|null
     */
    public function getConsumptionHistory()
    {
        return $this->ConsumptionHistory;
    }
    /**
     * Set ConsumptionHistory value
     * @param \SGCIS\Array\ArrayOfServicePointMeterRead $consumptionHistory
     * @return \SGCIS\Struct\Account
     */
    public function setConsumptionHistory(\SGCIS\Array\ArrayOfServicePointMeterRead $consumptionHistory = null)
    {
        $this->ConsumptionHistory = $consumptionHistory;
        return $this;
    }
    /**
     * Get LastMeterReads value
     * @return \SGCIS\Array\ArrayOfMeterRead|null
     */
    public function getLastMeterReads()
    {
        return $this->LastMeterReads;
    }
    /**
     * Set LastMeterReads value
     * @param \SGCIS\Array\ArrayOfMeterRead $lastMeterReads
     * @return \SGCIS\Struct\Account
     */
    public function setLastMeterReads(\SGCIS\Array\ArrayOfMeterRead $lastMeterReads = null)
    {
        $this->LastMeterReads = $lastMeterReads;
        return $this;
    }
    /**
     * Get MeterStatus value
     * @return string|null
     */
    public function getMeterStatus()
    {
        return $this->MeterStatus;
    }
    /**
     * Set MeterStatus value
     * @param string $meterStatus
     * @return \SGCIS\Struct\Account
     */
    public function setMeterStatus($meterStatus = null)
    {
        // validation for constraint: string
        if (!is_null($meterStatus) && !is_string($meterStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterStatus)), __LINE__);
        }
        $this->MeterStatus = $meterStatus;
        return $this;
    }
    /**
     * Get AccountServicePointIDs value
     * @return \SGCIS\Array\ArrayOfInt|null
     */
    public function getAccountServicePointIDs()
    {
        return $this->AccountServicePointIDs;
    }
    /**
     * Set AccountServicePointIDs value
     * @param \SGCIS\Array\ArrayOfInt $accountServicePointIDs
     * @return \SGCIS\Struct\Account
     */
    public function setAccountServicePointIDs(\SGCIS\Array\ArrayOfInt $accountServicePointIDs = null)
    {
        $this->AccountServicePointIDs = $accountServicePointIDs;
        return $this;
    }
    /**
     * Get AccountFlags value
     * @return string|null
     */
    public function getAccountFlags()
    {
        return $this->AccountFlags;
    }
    /**
     * Set AccountFlags value
     * @param string $accountFlags
     * @return \SGCIS\Struct\Account
     */
    public function setAccountFlags($accountFlags = null)
    {
        // validation for constraint: string
        if (!is_null($accountFlags) && !is_string($accountFlags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountFlags)), __LINE__);
        }
        $this->AccountFlags = $accountFlags;
        return $this;
    }
    /**
     * Get AccountAccountFlags value
     * @return \SGCIS\Array\ArrayOfAccountAccountFlag|null
     */
    public function getAccountAccountFlags()
    {
        return $this->AccountAccountFlags;
    }
    /**
     * Set AccountAccountFlags value
     * @param \SGCIS\Array\ArrayOfAccountAccountFlag $accountAccountFlags
     * @return \SGCIS\Struct\Account
     */
    public function setAccountAccountFlags(\SGCIS\Array\ArrayOfAccountAccountFlag $accountAccountFlags = null)
    {
        $this->AccountAccountFlags = $accountAccountFlags;
        return $this;
    }
    /**
     * Get LegacyCreatedBy value
     * @return string|null
     */
    public function getLegacyCreatedBy()
    {
        return $this->LegacyCreatedBy;
    }
    /**
     * Set LegacyCreatedBy value
     * @param string $legacyCreatedBy
     * @return \SGCIS\Struct\Account
     */
    public function setLegacyCreatedBy($legacyCreatedBy = null)
    {
        // validation for constraint: string
        if (!is_null($legacyCreatedBy) && !is_string($legacyCreatedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legacyCreatedBy)), __LINE__);
        }
        $this->LegacyCreatedBy = $legacyCreatedBy;
        return $this;
    }
    /**
     * Get LegacyAccountNumber value
     * @return string|null
     */
    public function getLegacyAccountNumber()
    {
        return $this->LegacyAccountNumber;
    }
    /**
     * Set LegacyAccountNumber value
     * @param string $legacyAccountNumber
     * @return \SGCIS\Struct\Account
     */
    public function setLegacyAccountNumber($legacyAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($legacyAccountNumber) && !is_string($legacyAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legacyAccountNumber)), __LINE__);
        }
        $this->LegacyAccountNumber = $legacyAccountNumber;
        return $this;
    }
    /**
     * Get MonthlyBillingCycleID value
     * @return string|null
     */
    public function getMonthlyBillingCycleID()
    {
        return $this->MonthlyBillingCycleID;
    }
    /**
     * Set MonthlyBillingCycleID value
     * @param string $monthlyBillingCycleID
     * @return \SGCIS\Struct\Account
     */
    public function setMonthlyBillingCycleID($monthlyBillingCycleID = null)
    {
        // validation for constraint: string
        if (!is_null($monthlyBillingCycleID) && !is_string($monthlyBillingCycleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($monthlyBillingCycleID)), __LINE__);
        }
        $this->MonthlyBillingCycleID = $monthlyBillingCycleID;
        return $this;
    }
    /**
     * Get MeterStatusColor value
     * @return string|null
     */
    public function getMeterStatusColor()
    {
        return $this->MeterStatusColor;
    }
    /**
     * Set MeterStatusColor value
     * @param string $meterStatusColor
     * @return \SGCIS\Struct\Account
     */
    public function setMeterStatusColor($meterStatusColor = null)
    {
        // validation for constraint: string
        if (!is_null($meterStatusColor) && !is_string($meterStatusColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterStatusColor)), __LINE__);
        }
        $this->MeterStatusColor = $meterStatusColor;
        return $this;
    }
    /**
     * Get SalesForceLeadID value
     * @return string|null
     */
    public function getSalesForceLeadID()
    {
        return $this->SalesForceLeadID;
    }
    /**
     * Set SalesForceLeadID value
     * @param string $salesForceLeadID
     * @return \SGCIS\Struct\Account
     */
    public function setSalesForceLeadID($salesForceLeadID = null)
    {
        // validation for constraint: string
        if (!is_null($salesForceLeadID) && !is_string($salesForceLeadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesForceLeadID)), __LINE__);
        }
        $this->SalesForceLeadID = $salesForceLeadID;
        return $this;
    }
    /**
     * Get AccountsPrimaryPersonName value
     * @return string|null
     */
    public function getAccountsPrimaryPersonName()
    {
        return $this->AccountsPrimaryPersonName;
    }
    /**
     * Set AccountsPrimaryPersonName value
     * @param string $accountsPrimaryPersonName
     * @return \SGCIS\Struct\Account
     */
    public function setAccountsPrimaryPersonName($accountsPrimaryPersonName = null)
    {
        // validation for constraint: string
        if (!is_null($accountsPrimaryPersonName) && !is_string($accountsPrimaryPersonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountsPrimaryPersonName)), __LINE__);
        }
        $this->AccountsPrimaryPersonName = $accountsPrimaryPersonName;
        return $this;
    }
    /**
     * Get AccountsPrimaryPersonPhone value
     * @return string|null
     */
    public function getAccountsPrimaryPersonPhone()
    {
        return $this->AccountsPrimaryPersonPhone;
    }
    /**
     * Set AccountsPrimaryPersonPhone value
     * @param string $accountsPrimaryPersonPhone
     * @return \SGCIS\Struct\Account
     */
    public function setAccountsPrimaryPersonPhone($accountsPrimaryPersonPhone = null)
    {
        // validation for constraint: string
        if (!is_null($accountsPrimaryPersonPhone) && !is_string($accountsPrimaryPersonPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountsPrimaryPersonPhone)), __LINE__);
        }
        $this->AccountsPrimaryPersonPhone = $accountsPrimaryPersonPhone;
        return $this;
    }
    /**
     * Get SecurityQuestionText value
     * @return string|null
     */
    public function getSecurityQuestionText()
    {
        return $this->SecurityQuestionText;
    }
    /**
     * Set SecurityQuestionText value
     * @param string $securityQuestionText
     * @return \SGCIS\Struct\Account
     */
    public function setSecurityQuestionText($securityQuestionText = null)
    {
        // validation for constraint: string
        if (!is_null($securityQuestionText) && !is_string($securityQuestionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityQuestionText)), __LINE__);
        }
        $this->SecurityQuestionText = $securityQuestionText;
        return $this;
    }
    /**
     * Get SecurityQuestionAnswer value
     * @return string|null
     */
    public function getSecurityQuestionAnswer()
    {
        return $this->SecurityQuestionAnswer;
    }
    /**
     * Set SecurityQuestionAnswer value
     * @param string $securityQuestionAnswer
     * @return \SGCIS\Struct\Account
     */
    public function setSecurityQuestionAnswer($securityQuestionAnswer = null)
    {
        // validation for constraint: string
        if (!is_null($securityQuestionAnswer) && !is_string($securityQuestionAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityQuestionAnswer)), __LINE__);
        }
        $this->SecurityQuestionAnswer = $securityQuestionAnswer;
        return $this;
    }
    /**
     * Get AccountStatusName value
     * @return string|null
     */
    public function getAccountStatusName()
    {
        return $this->AccountStatusName;
    }
    /**
     * Set AccountStatusName value
     * @param string $accountStatusName
     * @return \SGCIS\Struct\Account
     */
    public function setAccountStatusName($accountStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($accountStatusName) && !is_string($accountStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStatusName)), __LINE__);
        }
        $this->AccountStatusName = $accountStatusName;
        return $this;
    }
    /**
     * Get AccountTypeName value
     * @return string|null
     */
    public function getAccountTypeName()
    {
        return $this->AccountTypeName;
    }
    /**
     * Set AccountTypeName value
     * @param string $accountTypeName
     * @return \SGCIS\Struct\Account
     */
    public function setAccountTypeName($accountTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($accountTypeName) && !is_string($accountTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountTypeName)), __LINE__);
        }
        $this->AccountTypeName = $accountTypeName;
        return $this;
    }
    /**
     * Get PersonName value
     * @return string|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param string $personName
     * @return \SGCIS\Struct\Account
     */
    public function setPersonName($personName = null)
    {
        // validation for constraint: string
        if (!is_null($personName) && !is_string($personName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personName)), __LINE__);
        }
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get FullAddress value
     * @return string|null
     */
    public function getFullAddress()
    {
        return $this->FullAddress;
    }
    /**
     * Set FullAddress value
     * @param string $fullAddress
     * @return \SGCIS\Struct\Account
     */
    public function setFullAddress($fullAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fullAddress) && !is_string($fullAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullAddress)), __LINE__);
        }
        $this->FullAddress = $fullAddress;
        return $this;
    }
    /**
     * Get NotificationChannelName value
     * @return string|null
     */
    public function getNotificationChannelName()
    {
        return $this->NotificationChannelName;
    }
    /**
     * Set NotificationChannelName value
     * @param string $notificationChannelName
     * @return \SGCIS\Struct\Account
     */
    public function setNotificationChannelName($notificationChannelName = null)
    {
        // validation for constraint: string
        if (!is_null($notificationChannelName) && !is_string($notificationChannelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationChannelName)), __LINE__);
        }
        $this->NotificationChannelName = $notificationChannelName;
        return $this;
    }
    /**
     * Get LanguageName value
     * @return string|null
     */
    public function getLanguageName()
    {
        return $this->LanguageName;
    }
    /**
     * Set LanguageName value
     * @param string $languageName
     * @return \SGCIS\Struct\Account
     */
    public function setLanguageName($languageName = null)
    {
        // validation for constraint: string
        if (!is_null($languageName) && !is_string($languageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageName)), __LINE__);
        }
        $this->LanguageName = $languageName;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SGCIS\Struct\Account
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \SGCIS\Struct\Account
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \SGCIS\Struct\Account
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get BillCalculationMethodName value
     * @return string|null
     */
    public function getBillCalculationMethodName()
    {
        return $this->BillCalculationMethodName;
    }
    /**
     * Set BillCalculationMethodName value
     * @param string $billCalculationMethodName
     * @return \SGCIS\Struct\Account
     */
    public function setBillCalculationMethodName($billCalculationMethodName = null)
    {
        // validation for constraint: string
        if (!is_null($billCalculationMethodName) && !is_string($billCalculationMethodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billCalculationMethodName)), __LINE__);
        }
        $this->BillCalculationMethodName = $billCalculationMethodName;
        return $this;
    }
    /**
     * Get AgentID value
     * @return string|null
     */
    public function getAgentID()
    {
        return $this->AgentID;
    }
    /**
     * Set AgentID value
     * @param string $agentID
     * @return \SGCIS\Struct\Account
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentID)), __LINE__);
        }
        $this->AgentID = $agentID;
        return $this;
    }
    /**
     * Get ThirdPartyVerificationCode value
     * @return string|null
     */
    public function getThirdPartyVerificationCode()
    {
        return $this->ThirdPartyVerificationCode;
    }
    /**
     * Set ThirdPartyVerificationCode value
     * @param string $thirdPartyVerificationCode
     * @return \SGCIS\Struct\Account
     */
    public function setThirdPartyVerificationCode($thirdPartyVerificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyVerificationCode) && !is_string($thirdPartyVerificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thirdPartyVerificationCode)), __LINE__);
        }
        $this->ThirdPartyVerificationCode = $thirdPartyVerificationCode;
        return $this;
    }
    /**
     * Get LegacySystem value
     * @return string|null
     */
    public function getLegacySystem()
    {
        return $this->LegacySystem;
    }
    /**
     * Set LegacySystem value
     * @param string $legacySystem
     * @return \SGCIS\Struct\Account
     */
    public function setLegacySystem($legacySystem = null)
    {
        // validation for constraint: string
        if (!is_null($legacySystem) && !is_string($legacySystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legacySystem)), __LINE__);
        }
        $this->LegacySystem = $legacySystem;
        return $this;
    }
    /**
     * Get EnrollmentIPAddress value
     * @return string|null
     */
    public function getEnrollmentIPAddress()
    {
        return $this->EnrollmentIPAddress;
    }
    /**
     * Set EnrollmentIPAddress value
     * @param string $enrollmentIPAddress
     * @return \SGCIS\Struct\Account
     */
    public function setEnrollmentIPAddress($enrollmentIPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentIPAddress) && !is_string($enrollmentIPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollmentIPAddress)), __LINE__);
        }
        $this->EnrollmentIPAddress = $enrollmentIPAddress;
        return $this;
    }
    /**
     * Get AccountStatus value
     * @return \SGCIS\Struct\AccountStatus|null
     */
    public function getAccountStatus()
    {
        return $this->AccountStatus;
    }
    /**
     * Set AccountStatus value
     * @param \SGCIS\Struct\AccountStatus $accountStatus
     * @return \SGCIS\Struct\Account
     */
    public function setAccountStatus(\SGCIS\Struct\AccountStatus $accountStatus = null)
    {
        $this->AccountStatus = $accountStatus;
        return $this;
    }
    /**
     * Get AccountType value
     * @return \SGCIS\Struct\AccountType|null
     */
    public function getAccountType()
    {
        return $this->AccountType;
    }
    /**
     * Set AccountType value
     * @param \SGCIS\Struct\AccountType $accountType
     * @return \SGCIS\Struct\Account
     */
    public function setAccountType(\SGCIS\Struct\AccountType $accountType = null)
    {
        $this->AccountType = $accountType;
        return $this;
    }
    /**
     * Get NotificationChannel value
     * @return \SGCIS\Struct\NotificationChannel|null
     */
    public function getNotificationChannel()
    {
        return $this->NotificationChannel;
    }
    /**
     * Set NotificationChannel value
     * @param \SGCIS\Struct\NotificationChannel $notificationChannel
     * @return \SGCIS\Struct\Account
     */
    public function setNotificationChannel(\SGCIS\Struct\NotificationChannel $notificationChannel = null)
    {
        $this->NotificationChannel = $notificationChannel;
        return $this;
    }
    /**
     * Get Language value
     * @return \SGCIS\Struct\Language|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param \SGCIS\Struct\Language $language
     * @return \SGCIS\Struct\Account
     */
    public function setLanguage(\SGCIS\Struct\Language $language = null)
    {
        $this->Language = $language;
        return $this;
    }
    /**
     * Get AccountAddress value
     * @return \SGCIS\Struct\AccountAddress|null
     */
    public function getAccountAddress()
    {
        return $this->AccountAddress;
    }
    /**
     * Set AccountAddress value
     * @param \SGCIS\Struct\AccountAddress $accountAddress
     * @return \SGCIS\Struct\Account
     */
    public function setAccountAddress(\SGCIS\Struct\AccountAddress $accountAddress = null)
    {
        $this->AccountAddress = $accountAddress;
        return $this;
    }
    /**
     * Get AccountTerminationReason value
     * @return \SGCIS\Struct\AccountTerminationReason|null
     */
    public function getAccountTerminationReason()
    {
        return $this->AccountTerminationReason;
    }
    /**
     * Set AccountTerminationReason value
     * @param \SGCIS\Struct\AccountTerminationReason $accountTerminationReason
     * @return \SGCIS\Struct\Account
     */
    public function setAccountTerminationReason(\SGCIS\Struct\AccountTerminationReason $accountTerminationReason = null)
    {
        $this->AccountTerminationReason = $accountTerminationReason;
        return $this;
    }
    /**
     * Get AutoPayment value
     * @return \SGCIS\Struct\AccountAutoPay|null
     */
    public function getAutoPayment()
    {
        return $this->AutoPayment;
    }
    /**
     * Set AutoPayment value
     * @param \SGCIS\Struct\AccountAutoPay $autoPayment
     * @return \SGCIS\Struct\Account
     */
    public function setAutoPayment(\SGCIS\Struct\AccountAutoPay $autoPayment = null)
    {
        $this->AutoPayment = $autoPayment;
        return $this;
    }
    /**
     * Get Product value
     * @return \SGCIS\Struct\Product|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \SGCIS\Struct\Product $product
     * @return \SGCIS\Struct\Account
     */
    public function setProduct(\SGCIS\Struct\Product $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get Products value
     * @return \SGCIS\Array\ArrayOfProduct|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \SGCIS\Array\ArrayOfProduct $products
     * @return \SGCIS\Struct\Account
     */
    public function setProducts(\SGCIS\Array\ArrayOfProduct $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get SnapshotARReport value
     * @return \SGCIS\Struct\SnapshotARReport|null
     */
    public function getSnapshotARReport()
    {
        return $this->SnapshotARReport;
    }
    /**
     * Set SnapshotARReport value
     * @param \SGCIS\Struct\SnapshotARReport $snapshotARReport
     * @return \SGCIS\Struct\Account
     */
    public function setSnapshotARReport(\SGCIS\Struct\SnapshotARReport $snapshotARReport = null)
    {
        $this->SnapshotARReport = $snapshotARReport;
        return $this;
    }
    /**
     * Get Persons value
     * @return \SGCIS\Array\ArrayOfPerson|null
     */
    public function getPersons()
    {
        return $this->Persons;
    }
    /**
     * Set Persons value
     * @param \SGCIS\Array\ArrayOfPerson $persons
     * @return \SGCIS\Struct\Account
     */
    public function setPersons(\SGCIS\Array\ArrayOfPerson $persons = null)
    {
        $this->Persons = $persons;
        return $this;
    }
    /**
     * Get AccountPersons value
     * @return \SGCIS\Array\ArrayOfAccountPerson|null
     */
    public function getAccountPersons()
    {
        return $this->AccountPersons;
    }
    /**
     * Set AccountPersons value
     * @param \SGCIS\Array\ArrayOfAccountPerson $accountPersons
     * @return \SGCIS\Struct\Account
     */
    public function setAccountPersons(\SGCIS\Array\ArrayOfAccountPerson $accountPersons = null)
    {
        $this->AccountPersons = $accountPersons;
        return $this;
    }
    /**
     * Get DistributionPoints value
     * @return \SGCIS\Array\ArrayOfDistributionPoint|null
     */
    public function getDistributionPoints()
    {
        return $this->DistributionPoints;
    }
    /**
     * Set DistributionPoints value
     * @param \SGCIS\Array\ArrayOfDistributionPoint $distributionPoints
     * @return \SGCIS\Struct\Account
     */
    public function setDistributionPoints(\SGCIS\Array\ArrayOfDistributionPoint $distributionPoints = null)
    {
        $this->DistributionPoints = $distributionPoints;
        return $this;
    }
    /**
     * Get AccountNotes value
     * @return \SGCIS\Array\ArrayOfAccountNote|null
     */
    public function getAccountNotes()
    {
        return $this->AccountNotes;
    }
    /**
     * Set AccountNotes value
     * @param \SGCIS\Array\ArrayOfAccountNote $accountNotes
     * @return \SGCIS\Struct\Account
     */
    public function setAccountNotes(\SGCIS\Array\ArrayOfAccountNote $accountNotes = null)
    {
        $this->AccountNotes = $accountNotes;
        return $this;
    }
    /**
     * Get ServicePoints value
     * @return \SGCIS\Array\ArrayOfServicePoint|null
     */
    public function getServicePoints()
    {
        return $this->ServicePoints;
    }
    /**
     * Set ServicePoints value
     * @param \SGCIS\Array\ArrayOfServicePoint $servicePoints
     * @return \SGCIS\Struct\Account
     */
    public function setServicePoints(\SGCIS\Array\ArrayOfServicePoint $servicePoints = null)
    {
        $this->ServicePoints = $servicePoints;
        return $this;
    }
    /**
     * Get AccountServicePoints value
     * @return \SGCIS\Array\ArrayOfAccountServicePoint|null
     */
    public function getAccountServicePoints()
    {
        return $this->AccountServicePoints;
    }
    /**
     * Set AccountServicePoints value
     * @param \SGCIS\Array\ArrayOfAccountServicePoint $accountServicePoints
     * @return \SGCIS\Struct\Account
     */
    public function setAccountServicePoints(\SGCIS\Array\ArrayOfAccountServicePoint $accountServicePoints = null)
    {
        $this->AccountServicePoints = $accountServicePoints;
        return $this;
    }
    /**
     * Get PaymentAccounts value
     * @return \SGCIS\Array\ArrayOfPaymentAccount|null
     */
    public function getPaymentAccounts()
    {
        return $this->PaymentAccounts;
    }
    /**
     * Set PaymentAccounts value
     * @param \SGCIS\Array\ArrayOfPaymentAccount $paymentAccounts
     * @return \SGCIS\Struct\Account
     */
    public function setPaymentAccounts(\SGCIS\Array\ArrayOfPaymentAccount $paymentAccounts = null)
    {
        $this->PaymentAccounts = $paymentAccounts;
        return $this;
    }
    /**
     * Get AccountTransactions value
     * @return \SGCIS\Array\ArrayOfAccountTransaction|null
     */
    public function getAccountTransactions()
    {
        return $this->AccountTransactions;
    }
    /**
     * Set AccountTransactions value
     * @param \SGCIS\Array\ArrayOfAccountTransaction $accountTransactions
     * @return \SGCIS\Struct\Account
     */
    public function setAccountTransactions(\SGCIS\Array\ArrayOfAccountTransaction $accountTransactions = null)
    {
        $this->AccountTransactions = $accountTransactions;
        return $this;
    }
    /**
     * Get PaymentArrangements value
     * @return \SGCIS\Array\ArrayOfPaymentArrangement|null
     */
    public function getPaymentArrangements()
    {
        return $this->PaymentArrangements;
    }
    /**
     * Set PaymentArrangements value
     * @param \SGCIS\Array\ArrayOfPaymentArrangement $paymentArrangements
     * @return \SGCIS\Struct\Account
     */
    public function setPaymentArrangements(\SGCIS\Array\ArrayOfPaymentArrangement $paymentArrangements = null)
    {
        $this->PaymentArrangements = $paymentArrangements;
        return $this;
    }
    /**
     * Get ServiceOrders value
     * @return \SGCIS\Array\ArrayOfServiceOrder|null
     */
    public function getServiceOrders()
    {
        return $this->ServiceOrders;
    }
    /**
     * Set ServiceOrders value
     * @param \SGCIS\Array\ArrayOfServiceOrder $serviceOrders
     * @return \SGCIS\Struct\Account
     */
    public function setServiceOrders(\SGCIS\Array\ArrayOfServiceOrder $serviceOrders = null)
    {
        $this->ServiceOrders = $serviceOrders;
        return $this;
    }
    /**
     * Get AccountAutoPayments value
     * @return \SGCIS\Array\ArrayOfAccountAutoPay|null
     */
    public function getAccountAutoPayments()
    {
        return $this->AccountAutoPayments;
    }
    /**
     * Set AccountAutoPayments value
     * @param \SGCIS\Array\ArrayOfAccountAutoPay $accountAutoPayments
     * @return \SGCIS\Struct\Account
     */
    public function setAccountAutoPayments(\SGCIS\Array\ArrayOfAccountAutoPay $accountAutoPayments = null)
    {
        $this->AccountAutoPayments = $accountAutoPayments;
        return $this;
    }
    /**
     * Get Tickets value
     * @return \SGCIS\Array\ArrayOfTicket|null
     */
    public function getTickets()
    {
        return $this->Tickets;
    }
    /**
     * Set Tickets value
     * @param \SGCIS\Array\ArrayOfTicket $tickets
     * @return \SGCIS\Struct\Account
     */
    public function setTickets(\SGCIS\Array\ArrayOfTicket $tickets = null)
    {
        $this->Tickets = $tickets;
        return $this;
    }
    /**
     * Get AccountCommunications value
     * @return \SGCIS\Array\ArrayOfAccountCommunication|null
     */
    public function getAccountCommunications()
    {
        return $this->AccountCommunications;
    }
    /**
     * Set AccountCommunications value
     * @param \SGCIS\Array\ArrayOfAccountCommunication $accountCommunications
     * @return \SGCIS\Struct\Account
     */
    public function setAccountCommunications(\SGCIS\Array\ArrayOfAccountCommunication $accountCommunications = null)
    {
        $this->AccountCommunications = $accountCommunications;
        return $this;
    }
    /**
     * Get AccountDocuments value
     * @return \SGCIS\Array\ArrayOfAccountDocument|null
     */
    public function getAccountDocuments()
    {
        return $this->AccountDocuments;
    }
    /**
     * Set AccountDocuments value
     * @param \SGCIS\Array\ArrayOfAccountDocument $accountDocuments
     * @return \SGCIS\Struct\Account
     */
    public function setAccountDocuments(\SGCIS\Array\ArrayOfAccountDocument $accountDocuments = null)
    {
        $this->AccountDocuments = $accountDocuments;
        return $this;
    }
    /**
     * Get AccountHistory value
     * @return \SGCIS\Array\ArrayOfAccountStatusHistory|null
     */
    public function getAccountHistory()
    {
        return $this->AccountHistory;
    }
    /**
     * Set AccountHistory value
     * @param \SGCIS\Array\ArrayOfAccountStatusHistory $accountHistory
     * @return \SGCIS\Struct\Account
     */
    public function setAccountHistory(\SGCIS\Array\ArrayOfAccountStatusHistory $accountHistory = null)
    {
        $this->AccountHistory = $accountHistory;
        return $this;
    }
    /**
     * Get AuditLog value
     * @return \SGCIS\Array\ArrayOfAuditLog|null
     */
    public function getAuditLog()
    {
        return $this->AuditLog;
    }
    /**
     * Set AuditLog value
     * @param \SGCIS\Array\ArrayOfAuditLog $auditLog
     * @return \SGCIS\Struct\Account
     */
    public function setAuditLog(\SGCIS\Array\ArrayOfAuditLog $auditLog = null)
    {
        $this->AuditLog = $auditLog;
        return $this;
    }
    /**
     * Get TransactionSummaryItems value
     * @return \SGCIS\Array\ArrayOfTransactionSummaryItem|null
     */
    public function getTransactionSummaryItems()
    {
        return $this->TransactionSummaryItems;
    }
    /**
     * Set TransactionSummaryItems value
     * @param \SGCIS\Array\ArrayOfTransactionSummaryItem $transactionSummaryItems
     * @return \SGCIS\Struct\Account
     */
    public function setTransactionSummaryItems(\SGCIS\Array\ArrayOfTransactionSummaryItem $transactionSummaryItems = null)
    {
        $this->TransactionSummaryItems = $transactionSummaryItems;
        return $this;
    }
    /**
     * Get AccountDepositOption value
     * @return \SGCIS\Struct\AccountDepositOption|null
     */
    public function getAccountDepositOption()
    {
        return $this->AccountDepositOption;
    }
    /**
     * Set AccountDepositOption value
     * @param \SGCIS\Struct\AccountDepositOption $accountDepositOption
     * @return \SGCIS\Struct\Account
     */
    public function setAccountDepositOption(\SGCIS\Struct\AccountDepositOption $accountDepositOption = null)
    {
        $this->AccountDepositOption = $accountDepositOption;
        return $this;
    }
    /**
     * Get BillHeaders value
     * @return \SGCIS\Array\ArrayOfBillHeader|null
     */
    public function getBillHeaders()
    {
        return $this->BillHeaders;
    }
    /**
     * Set BillHeaders value
     * @param \SGCIS\Array\ArrayOfBillHeader $billHeaders
     * @return \SGCIS\Struct\Account
     */
    public function setBillHeaders(\SGCIS\Array\ArrayOfBillHeader $billHeaders = null)
    {
        $this->BillHeaders = $billHeaders;
        return $this;
    }
    /**
     * Get BillDeliveryMethod value
     * @return \SGCIS\Array\ArrayOfBillDeliveryMethod|null
     */
    public function getBillDeliveryMethod()
    {
        return $this->BillDeliveryMethod;
    }
    /**
     * Set BillDeliveryMethod value
     * @param \SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethod
     * @return \SGCIS\Struct\Account
     */
    public function setBillDeliveryMethod(\SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethod = null)
    {
        $this->BillDeliveryMethod = $billDeliveryMethod;
        return $this;
    }
    /**
     * Get AccountCustomFields value
     * @return \SGCIS\Array\ArrayOfAccountCustomField|null
     */
    public function getAccountCustomFields()
    {
        return $this->AccountCustomFields;
    }
    /**
     * Set AccountCustomFields value
     * @param \SGCIS\Array\ArrayOfAccountCustomField $accountCustomFields
     * @return \SGCIS\Struct\Account
     */
    public function setAccountCustomFields(\SGCIS\Array\ArrayOfAccountCustomField $accountCustomFields = null)
    {
        $this->AccountCustomFields = $accountCustomFields;
        return $this;
    }
    /**
     * Get MonthlyBillingCycle value
     * @return \SGCIS\Struct\MonthlyBillingCycle|null
     */
    public function getMonthlyBillingCycle()
    {
        return $this->MonthlyBillingCycle;
    }
    /**
     * Set MonthlyBillingCycle value
     * @param \SGCIS\Struct\MonthlyBillingCycle $monthlyBillingCycle
     * @return \SGCIS\Struct\Account
     */
    public function setMonthlyBillingCycle(\SGCIS\Struct\MonthlyBillingCycle $monthlyBillingCycle = null)
    {
        $this->MonthlyBillingCycle = $monthlyBillingCycle;
        return $this;
    }
    /**
     * Get LastPaymentTransaction value
     * @return \SGCIS\Struct\AccountTransaction|null
     */
    public function getLastPaymentTransaction()
    {
        return $this->LastPaymentTransaction;
    }
    /**
     * Set LastPaymentTransaction value
     * @param \SGCIS\Struct\AccountTransaction $lastPaymentTransaction
     * @return \SGCIS\Struct\Account
     */
    public function setLastPaymentTransaction(\SGCIS\Struct\AccountTransaction $lastPaymentTransaction = null)
    {
        $this->LastPaymentTransaction = $lastPaymentTransaction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Account
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
