<?php

namespace SGCIS\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update Service
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateAccountProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\UpdateAccountProfile $parameters
     * @return \SGCIS\Struct\UpdateAccountProfileResponse|bool
     */
    public function UpdateAccountProfile(\SGCIS\Struct\UpdateAccountProfile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateAccountProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateAccountCommunicationViewStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\UpdateAccountCommunicationViewStatus $parameters
     * @return \SGCIS\Struct\UpdateAccountCommunicationViewStatusResponse|bool
     */
    public function UpdateAccountCommunicationViewStatus(\SGCIS\Struct\UpdateAccountCommunicationViewStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateAccountCommunicationViewStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \SGCIS\Struct\UpdateAccountCommunicationViewStatusResponse|\SGCIS\Struct\UpdateAccountProfileResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
