<?php

namespace SGCIS\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Post Service
 * @subpackage Services
 */
class Post extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PostUspPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\PostUspPayment $parameters
     * @return \SGCIS\Struct\PostUspPaymentResponse|bool
     */
    public function PostUspPayment(\SGCIS\Struct\PostUspPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PostUspPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostAccountPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\PostAccountPayment $parameters
     * @return \SGCIS\Struct\PostAccountPaymentResponse|bool
     */
    public function PostAccountPayment(\SGCIS\Struct\PostAccountPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PostAccountPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \SGCIS\Struct\PostAccountPaymentResponse|\SGCIS\Struct\PostUspPaymentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
