<?php

namespace SGCIS\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Connect Service
 * @subpackage Services
 */
class Connect extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConnectSoftArmedMeter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ConnectSoftArmedMeter $parameters
     * @return \SGCIS\Struct\ConnectSoftArmedMeterResponse|bool
     */
    public function ConnectSoftArmedMeter(\SGCIS\Struct\ConnectSoftArmedMeter $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConnectSoftArmedMeter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \SGCIS\Struct\ConnectSoftArmedMeterResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
