<?php

namespace SGCIS\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Capture Service
 * @subpackage Services
 */
class Capture extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CaptureLead
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\CaptureLead $parameters
     * @return \SGCIS\Struct\CaptureLeadResponse|bool
     */
    public function CaptureLead(\SGCIS\Struct\CaptureLead $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CaptureLead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \SGCIS\Struct\CaptureLeadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
