<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWebProduct Array
 * @subpackage Arrays
 */
class ArrayOfWebProduct extends AbstractStructArrayBase
{
    /**
     * The WebProduct
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\WebProduct[]
     */
    public $WebProduct;
    /**
     * Constructor method for ArrayOfWebProduct
     * @uses ArrayOfWebProduct::setWebProduct()
     * @param \SGCIS\Struct\WebProduct[] $webProduct
     */
    public function __construct(array $webProduct = array())
    {
        $this
            ->setWebProduct($webProduct);
    }
    /**
     * Get WebProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\WebProduct[]|null
     */
    public function getWebProduct()
    {
        return isset($this->WebProduct) ? $this->WebProduct : null;
    }
    /**
     * Set WebProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\WebProduct[] $webProduct
     * @return \SGCIS\Array\ArrayOfWebProduct
     */
    public function setWebProduct(array $webProduct = array())
    {
        foreach ($webProduct as $arrayOfWebProductWebProductItem) {
            // validation for constraint: itemType
            if (!$arrayOfWebProductWebProductItem instanceof \SGCIS\Struct\WebProduct) {
                throw new \InvalidArgumentException(sprintf('The WebProduct property can only contain items of \SGCIS\Struct\WebProduct, "%s" given', is_object($arrayOfWebProductWebProductItem) ? get_class($arrayOfWebProductWebProductItem) : gettype($arrayOfWebProductWebProductItem)), __LINE__);
            }
        }
        if (is_null($webProduct) || (is_array($webProduct) && empty($webProduct))) {
            unset($this->WebProduct);
        } else {
            $this->WebProduct = $webProduct;
        }
        return $this;
    }
    /**
     * Add item to WebProduct value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\WebProduct $item
     * @return \SGCIS\Array\ArrayOfWebProduct
     */
    public function addToWebProduct(\SGCIS\Struct\WebProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\WebProduct) {
            throw new \InvalidArgumentException(sprintf('The WebProduct property can only contain items of \SGCIS\Struct\WebProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WebProduct[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\WebProduct|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\WebProduct|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\WebProduct|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\WebProduct|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\WebProduct|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WebProduct
     */
    public function getAttributeName()
    {
        return 'WebProduct';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfWebProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
