<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransactionAssociateAccount Array
 * @subpackage Arrays
 */
class ArrayOfTransactionAssociateAccount extends AbstractStructArrayBase
{
    /**
     * The TransactionAssociateAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\TransactionAssociateAccount[]
     */
    public $TransactionAssociateAccount;
    /**
     * Constructor method for ArrayOfTransactionAssociateAccount
     * @uses ArrayOfTransactionAssociateAccount::setTransactionAssociateAccount()
     * @param \SGCIS\Struct\TransactionAssociateAccount[] $transactionAssociateAccount
     */
    public function __construct(array $transactionAssociateAccount = array())
    {
        $this
            ->setTransactionAssociateAccount($transactionAssociateAccount);
    }
    /**
     * Get TransactionAssociateAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\TransactionAssociateAccount[]|null
     */
    public function getTransactionAssociateAccount()
    {
        return isset($this->TransactionAssociateAccount) ? $this->TransactionAssociateAccount : null;
    }
    /**
     * Set TransactionAssociateAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TransactionAssociateAccount[] $transactionAssociateAccount
     * @return \SGCIS\Array\ArrayOfTransactionAssociateAccount
     */
    public function setTransactionAssociateAccount(array $transactionAssociateAccount = array())
    {
        foreach ($transactionAssociateAccount as $arrayOfTransactionAssociateAccountTransactionAssociateAccountItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransactionAssociateAccountTransactionAssociateAccountItem instanceof \SGCIS\Struct\TransactionAssociateAccount) {
                throw new \InvalidArgumentException(sprintf('The TransactionAssociateAccount property can only contain items of \SGCIS\Struct\TransactionAssociateAccount, "%s" given', is_object($arrayOfTransactionAssociateAccountTransactionAssociateAccountItem) ? get_class($arrayOfTransactionAssociateAccountTransactionAssociateAccountItem) : gettype($arrayOfTransactionAssociateAccountTransactionAssociateAccountItem)), __LINE__);
            }
        }
        if (is_null($transactionAssociateAccount) || (is_array($transactionAssociateAccount) && empty($transactionAssociateAccount))) {
            unset($this->TransactionAssociateAccount);
        } else {
            $this->TransactionAssociateAccount = $transactionAssociateAccount;
        }
        return $this;
    }
    /**
     * Add item to TransactionAssociateAccount value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TransactionAssociateAccount $item
     * @return \SGCIS\Array\ArrayOfTransactionAssociateAccount
     */
    public function addToTransactionAssociateAccount(\SGCIS\Struct\TransactionAssociateAccount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\TransactionAssociateAccount) {
            throw new \InvalidArgumentException(sprintf('The TransactionAssociateAccount property can only contain items of \SGCIS\Struct\TransactionAssociateAccount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransactionAssociateAccount[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\TransactionAssociateAccount|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\TransactionAssociateAccount|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\TransactionAssociateAccount|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\TransactionAssociateAccount|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\TransactionAssociateAccount|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransactionAssociateAccount
     */
    public function getAttributeName()
    {
        return 'TransactionAssociateAccount';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfTransactionAssociateAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
