<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTicketFieldValue Array
 * @subpackage Arrays
 */
class ArrayOfTicketFieldValue extends AbstractStructArrayBase
{
    /**
     * The TicketFieldValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\TicketFieldValue[]
     */
    public $TicketFieldValue;
    /**
     * Constructor method for ArrayOfTicketFieldValue
     * @uses ArrayOfTicketFieldValue::setTicketFieldValue()
     * @param \SGCIS\Struct\TicketFieldValue[] $ticketFieldValue
     */
    public function __construct(array $ticketFieldValue = array())
    {
        $this
            ->setTicketFieldValue($ticketFieldValue);
    }
    /**
     * Get TicketFieldValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\TicketFieldValue[]|null
     */
    public function getTicketFieldValue()
    {
        return isset($this->TicketFieldValue) ? $this->TicketFieldValue : null;
    }
    /**
     * Set TicketFieldValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TicketFieldValue[] $ticketFieldValue
     * @return \SGCIS\Array\ArrayOfTicketFieldValue
     */
    public function setTicketFieldValue(array $ticketFieldValue = array())
    {
        foreach ($ticketFieldValue as $arrayOfTicketFieldValueTicketFieldValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfTicketFieldValueTicketFieldValueItem instanceof \SGCIS\Struct\TicketFieldValue) {
                throw new \InvalidArgumentException(sprintf('The TicketFieldValue property can only contain items of \SGCIS\Struct\TicketFieldValue, "%s" given', is_object($arrayOfTicketFieldValueTicketFieldValueItem) ? get_class($arrayOfTicketFieldValueTicketFieldValueItem) : gettype($arrayOfTicketFieldValueTicketFieldValueItem)), __LINE__);
            }
        }
        if (is_null($ticketFieldValue) || (is_array($ticketFieldValue) && empty($ticketFieldValue))) {
            unset($this->TicketFieldValue);
        } else {
            $this->TicketFieldValue = $ticketFieldValue;
        }
        return $this;
    }
    /**
     * Add item to TicketFieldValue value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TicketFieldValue $item
     * @return \SGCIS\Array\ArrayOfTicketFieldValue
     */
    public function addToTicketFieldValue(\SGCIS\Struct\TicketFieldValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\TicketFieldValue) {
            throw new \InvalidArgumentException(sprintf('The TicketFieldValue property can only contain items of \SGCIS\Struct\TicketFieldValue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketFieldValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\TicketFieldValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\TicketFieldValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\TicketFieldValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\TicketFieldValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\TicketFieldValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TicketFieldValue
     */
    public function getAttributeName()
    {
        return 'TicketFieldValue';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfTicketFieldValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
