<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTOU Array
 * @subpackage Arrays
 */
class ArrayOfTOU extends AbstractStructArrayBase
{
    /**
     * The TOU
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\TOU[]
     */
    public $TOU;
    /**
     * Constructor method for ArrayOfTOU
     * @uses ArrayOfTOU::setTOU()
     * @param \SGCIS\Struct\TOU[] $tOU
     */
    public function __construct(array $tOU = array())
    {
        $this
            ->setTOU($tOU);
    }
    /**
     * Get TOU value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\TOU[]|null
     */
    public function getTOU()
    {
        return isset($this->TOU) ? $this->TOU : null;
    }
    /**
     * Set TOU value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TOU[] $tOU
     * @return \SGCIS\Array\ArrayOfTOU
     */
    public function setTOU(array $tOU = array())
    {
        foreach ($tOU as $arrayOfTOUTOUItem) {
            // validation for constraint: itemType
            if (!$arrayOfTOUTOUItem instanceof \SGCIS\Struct\TOU) {
                throw new \InvalidArgumentException(sprintf('The TOU property can only contain items of \SGCIS\Struct\TOU, "%s" given', is_object($arrayOfTOUTOUItem) ? get_class($arrayOfTOUTOUItem) : gettype($arrayOfTOUTOUItem)), __LINE__);
            }
        }
        if (is_null($tOU) || (is_array($tOU) && empty($tOU))) {
            unset($this->TOU);
        } else {
            $this->TOU = $tOU;
        }
        return $this;
    }
    /**
     * Add item to TOU value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TOU $item
     * @return \SGCIS\Array\ArrayOfTOU
     */
    public function addToTOU(\SGCIS\Struct\TOU $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\TOU) {
            throw new \InvalidArgumentException(sprintf('The TOU property can only contain items of \SGCIS\Struct\TOU, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TOU[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\TOU|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\TOU|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\TOU|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\TOU|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\TOU|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TOU
     */
    public function getAttributeName()
    {
        return 'TOU';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfTOU
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
