<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSystemRoleApplicationWidget Array
 * @subpackage Arrays
 */
class ArrayOfSystemRoleApplicationWidget extends AbstractStructArrayBase
{
    /**
     * The SystemRoleApplicationWidget
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\SystemRoleApplicationWidget[]
     */
    public $SystemRoleApplicationWidget;
    /**
     * Constructor method for ArrayOfSystemRoleApplicationWidget
     * @uses ArrayOfSystemRoleApplicationWidget::setSystemRoleApplicationWidget()
     * @param \SGCIS\Struct\SystemRoleApplicationWidget[] $systemRoleApplicationWidget
     */
    public function __construct(array $systemRoleApplicationWidget = array())
    {
        $this
            ->setSystemRoleApplicationWidget($systemRoleApplicationWidget);
    }
    /**
     * Get SystemRoleApplicationWidget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\SystemRoleApplicationWidget[]|null
     */
    public function getSystemRoleApplicationWidget()
    {
        return isset($this->SystemRoleApplicationWidget) ? $this->SystemRoleApplicationWidget : null;
    }
    /**
     * Set SystemRoleApplicationWidget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemRoleApplicationWidget[] $systemRoleApplicationWidget
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationWidget
     */
    public function setSystemRoleApplicationWidget(array $systemRoleApplicationWidget = array())
    {
        foreach ($systemRoleApplicationWidget as $arrayOfSystemRoleApplicationWidgetSystemRoleApplicationWidgetItem) {
            // validation for constraint: itemType
            if (!$arrayOfSystemRoleApplicationWidgetSystemRoleApplicationWidgetItem instanceof \SGCIS\Struct\SystemRoleApplicationWidget) {
                throw new \InvalidArgumentException(sprintf('The SystemRoleApplicationWidget property can only contain items of \SGCIS\Struct\SystemRoleApplicationWidget, "%s" given', is_object($arrayOfSystemRoleApplicationWidgetSystemRoleApplicationWidgetItem) ? get_class($arrayOfSystemRoleApplicationWidgetSystemRoleApplicationWidgetItem) : gettype($arrayOfSystemRoleApplicationWidgetSystemRoleApplicationWidgetItem)), __LINE__);
            }
        }
        if (is_null($systemRoleApplicationWidget) || (is_array($systemRoleApplicationWidget) && empty($systemRoleApplicationWidget))) {
            unset($this->SystemRoleApplicationWidget);
        } else {
            $this->SystemRoleApplicationWidget = $systemRoleApplicationWidget;
        }
        return $this;
    }
    /**
     * Add item to SystemRoleApplicationWidget value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemRoleApplicationWidget $item
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationWidget
     */
    public function addToSystemRoleApplicationWidget(\SGCIS\Struct\SystemRoleApplicationWidget $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\SystemRoleApplicationWidget) {
            throw new \InvalidArgumentException(sprintf('The SystemRoleApplicationWidget property can only contain items of \SGCIS\Struct\SystemRoleApplicationWidget, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SystemRoleApplicationWidget[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\SystemRoleApplicationWidget|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\SystemRoleApplicationWidget|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\SystemRoleApplicationWidget|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\SystemRoleApplicationWidget|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\SystemRoleApplicationWidget|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SystemRoleApplicationWidget
     */
    public function getAttributeName()
    {
        return 'SystemRoleApplicationWidget';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationWidget
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
