<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSystemRoleApplicationExportFunction Array
 * @subpackage Arrays
 */
class ArrayOfSystemRoleApplicationExportFunction extends AbstractStructArrayBase
{
    /**
     * The SystemRoleApplicationExportFunction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\SystemRoleApplicationExportFunction[]
     */
    public $SystemRoleApplicationExportFunction;
    /**
     * Constructor method for ArrayOfSystemRoleApplicationExportFunction
     * @uses ArrayOfSystemRoleApplicationExportFunction::setSystemRoleApplicationExportFunction()
     * @param \SGCIS\Struct\SystemRoleApplicationExportFunction[] $systemRoleApplicationExportFunction
     */
    public function __construct(array $systemRoleApplicationExportFunction = array())
    {
        $this
            ->setSystemRoleApplicationExportFunction($systemRoleApplicationExportFunction);
    }
    /**
     * Get SystemRoleApplicationExportFunction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\SystemRoleApplicationExportFunction[]|null
     */
    public function getSystemRoleApplicationExportFunction()
    {
        return isset($this->SystemRoleApplicationExportFunction) ? $this->SystemRoleApplicationExportFunction : null;
    }
    /**
     * Set SystemRoleApplicationExportFunction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemRoleApplicationExportFunction[] $systemRoleApplicationExportFunction
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationExportFunction
     */
    public function setSystemRoleApplicationExportFunction(array $systemRoleApplicationExportFunction = array())
    {
        foreach ($systemRoleApplicationExportFunction as $arrayOfSystemRoleApplicationExportFunctionSystemRoleApplicationExportFunctionItem) {
            // validation for constraint: itemType
            if (!$arrayOfSystemRoleApplicationExportFunctionSystemRoleApplicationExportFunctionItem instanceof \SGCIS\Struct\SystemRoleApplicationExportFunction) {
                throw new \InvalidArgumentException(sprintf('The SystemRoleApplicationExportFunction property can only contain items of \SGCIS\Struct\SystemRoleApplicationExportFunction, "%s" given', is_object($arrayOfSystemRoleApplicationExportFunctionSystemRoleApplicationExportFunctionItem) ? get_class($arrayOfSystemRoleApplicationExportFunctionSystemRoleApplicationExportFunctionItem) : gettype($arrayOfSystemRoleApplicationExportFunctionSystemRoleApplicationExportFunctionItem)), __LINE__);
            }
        }
        if (is_null($systemRoleApplicationExportFunction) || (is_array($systemRoleApplicationExportFunction) && empty($systemRoleApplicationExportFunction))) {
            unset($this->SystemRoleApplicationExportFunction);
        } else {
            $this->SystemRoleApplicationExportFunction = $systemRoleApplicationExportFunction;
        }
        return $this;
    }
    /**
     * Add item to SystemRoleApplicationExportFunction value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemRoleApplicationExportFunction $item
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationExportFunction
     */
    public function addToSystemRoleApplicationExportFunction(\SGCIS\Struct\SystemRoleApplicationExportFunction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\SystemRoleApplicationExportFunction) {
            throw new \InvalidArgumentException(sprintf('The SystemRoleApplicationExportFunction property can only contain items of \SGCIS\Struct\SystemRoleApplicationExportFunction, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SystemRoleApplicationExportFunction[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\SystemRoleApplicationExportFunction|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\SystemRoleApplicationExportFunction|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\SystemRoleApplicationExportFunction|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\SystemRoleApplicationExportFunction|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\SystemRoleApplicationExportFunction|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SystemRoleApplicationExportFunction
     */
    public function getAttributeName()
    {
        return 'SystemRoleApplicationExportFunction';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationExportFunction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
