<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServicePointMeterReadDetail Array
 * @subpackage Arrays
 */
class ArrayOfServicePointMeterReadDetail extends AbstractStructArrayBase
{
    /**
     * The ServicePointMeterReadDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ServicePointMeterReadDetail[]
     */
    public $ServicePointMeterReadDetail;
    /**
     * Constructor method for ArrayOfServicePointMeterReadDetail
     * @uses ArrayOfServicePointMeterReadDetail::setServicePointMeterReadDetail()
     * @param \SGCIS\Struct\ServicePointMeterReadDetail[] $servicePointMeterReadDetail
     */
    public function __construct(array $servicePointMeterReadDetail = array())
    {
        $this
            ->setServicePointMeterReadDetail($servicePointMeterReadDetail);
    }
    /**
     * Get ServicePointMeterReadDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ServicePointMeterReadDetail[]|null
     */
    public function getServicePointMeterReadDetail()
    {
        return isset($this->ServicePointMeterReadDetail) ? $this->ServicePointMeterReadDetail : null;
    }
    /**
     * Set ServicePointMeterReadDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ServicePointMeterReadDetail[] $servicePointMeterReadDetail
     * @return \SGCIS\Array\ArrayOfServicePointMeterReadDetail
     */
    public function setServicePointMeterReadDetail(array $servicePointMeterReadDetail = array())
    {
        foreach ($servicePointMeterReadDetail as $arrayOfServicePointMeterReadDetailServicePointMeterReadDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfServicePointMeterReadDetailServicePointMeterReadDetailItem instanceof \SGCIS\Struct\ServicePointMeterReadDetail) {
                throw new \InvalidArgumentException(sprintf('The ServicePointMeterReadDetail property can only contain items of \SGCIS\Struct\ServicePointMeterReadDetail, "%s" given', is_object($arrayOfServicePointMeterReadDetailServicePointMeterReadDetailItem) ? get_class($arrayOfServicePointMeterReadDetailServicePointMeterReadDetailItem) : gettype($arrayOfServicePointMeterReadDetailServicePointMeterReadDetailItem)), __LINE__);
            }
        }
        if (is_null($servicePointMeterReadDetail) || (is_array($servicePointMeterReadDetail) && empty($servicePointMeterReadDetail))) {
            unset($this->ServicePointMeterReadDetail);
        } else {
            $this->ServicePointMeterReadDetail = $servicePointMeterReadDetail;
        }
        return $this;
    }
    /**
     * Add item to ServicePointMeterReadDetail value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ServicePointMeterReadDetail $item
     * @return \SGCIS\Array\ArrayOfServicePointMeterReadDetail
     */
    public function addToServicePointMeterReadDetail(\SGCIS\Struct\ServicePointMeterReadDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ServicePointMeterReadDetail) {
            throw new \InvalidArgumentException(sprintf('The ServicePointMeterReadDetail property can only contain items of \SGCIS\Struct\ServicePointMeterReadDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServicePointMeterReadDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ServicePointMeterReadDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ServicePointMeterReadDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ServicePointMeterReadDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ServicePointMeterReadDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ServicePointMeterReadDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServicePointMeterReadDetail
     */
    public function getAttributeName()
    {
        return 'ServicePointMeterReadDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfServicePointMeterReadDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
