<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServicePointMeterRead Array
 * @subpackage Arrays
 */
class ArrayOfServicePointMeterRead extends AbstractStructArrayBase
{
    /**
     * The ServicePointMeterRead
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ServicePointMeterRead[]
     */
    public $ServicePointMeterRead;
    /**
     * Constructor method for ArrayOfServicePointMeterRead
     * @uses ArrayOfServicePointMeterRead::setServicePointMeterRead()
     * @param \SGCIS\Struct\ServicePointMeterRead[] $servicePointMeterRead
     */
    public function __construct(array $servicePointMeterRead = array())
    {
        $this
            ->setServicePointMeterRead($servicePointMeterRead);
    }
    /**
     * Get ServicePointMeterRead value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ServicePointMeterRead[]|null
     */
    public function getServicePointMeterRead()
    {
        return isset($this->ServicePointMeterRead) ? $this->ServicePointMeterRead : null;
    }
    /**
     * Set ServicePointMeterRead value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ServicePointMeterRead[] $servicePointMeterRead
     * @return \SGCIS\Array\ArrayOfServicePointMeterRead
     */
    public function setServicePointMeterRead(array $servicePointMeterRead = array())
    {
        foreach ($servicePointMeterRead as $arrayOfServicePointMeterReadServicePointMeterReadItem) {
            // validation for constraint: itemType
            if (!$arrayOfServicePointMeterReadServicePointMeterReadItem instanceof \SGCIS\Struct\ServicePointMeterRead) {
                throw new \InvalidArgumentException(sprintf('The ServicePointMeterRead property can only contain items of \SGCIS\Struct\ServicePointMeterRead, "%s" given', is_object($arrayOfServicePointMeterReadServicePointMeterReadItem) ? get_class($arrayOfServicePointMeterReadServicePointMeterReadItem) : gettype($arrayOfServicePointMeterReadServicePointMeterReadItem)), __LINE__);
            }
        }
        if (is_null($servicePointMeterRead) || (is_array($servicePointMeterRead) && empty($servicePointMeterRead))) {
            unset($this->ServicePointMeterRead);
        } else {
            $this->ServicePointMeterRead = $servicePointMeterRead;
        }
        return $this;
    }
    /**
     * Add item to ServicePointMeterRead value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ServicePointMeterRead $item
     * @return \SGCIS\Array\ArrayOfServicePointMeterRead
     */
    public function addToServicePointMeterRead(\SGCIS\Struct\ServicePointMeterRead $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ServicePointMeterRead) {
            throw new \InvalidArgumentException(sprintf('The ServicePointMeterRead property can only contain items of \SGCIS\Struct\ServicePointMeterRead, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServicePointMeterRead[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ServicePointMeterRead|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ServicePointMeterRead|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ServicePointMeterRead|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ServicePointMeterRead|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ServicePointMeterRead|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServicePointMeterRead
     */
    public function getAttributeName()
    {
        return 'ServicePointMeterRead';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfServicePointMeterRead
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
